/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class AtomHybridizationDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    AtomTypeManipulator atman = null;
    IAtom atom = null;
    IAtomType matched = null;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomHybridization", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"aHyb"};
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer container2) {
        try {
            this.matched = CDKAtomTypeMatcher.getInstance(atom.getBuilder()).findMatchingAtomType(container2, atom);
        }
        catch (CDKException e2) {
            return this.getDummyDescriptorValue(e2);
        }
        if (this.matched == null) {
            int atnum = container2.indexOf(atom);
            return this.getDummyDescriptorValue(new CDKException("The matched atom type was null (atom number " + atnum + ") " + atom.getSymbol()));
        }
        IAtomType.Hybridization atomHybridization = this.matched.getHybridization();
        IntegerResult result = new IntegerResult(atomHybridization == null ? 0 : atomHybridization.ordinal());
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

