/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class IPAtomicHOSEDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"ipAtomicHOSE"};
    final int maxSpheresToUse = 10;
    private final IPdb db = new IPdb();

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer container2) {
        String originalAtomtypeName = atom.getAtomTypeName();
        Integer originalNeighborCount = atom.getFormalNeighbourCount();
        Integer originalValency = atom.getValency();
        Double originalBondOrderSum = atom.getBondOrderSum();
        IBond.Order originalMaxBondOrder = atom.getMaxBondOrder();
        IAtomType.Hybridization originalHybridization = atom.getHybridization();
        if (!this.isCachedAtomContainer(container2)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container2);
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(container2);
            }
            catch (CDKException e2) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e2);
            }
        }
        double value = this.db.extractIP(container2, atom);
        atom.setAtomTypeName(originalAtomtypeName);
        atom.setFormalNeighbourCount(originalNeighborCount);
        atom.setValency(originalValency);
        atom.setHybridization(originalHybridization);
        atom.setMaxBondOrder(originalMaxBondOrder);
        atom.setBondOrderSum(originalBondOrderSum);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(value), NAMES);
    }

    private boolean familyHalogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    private static List<String> extractInfo(String str2) {
        int end;
        int beg = 0;
        int len = str2.length();
        ArrayList<String> parts = new ArrayList<String>();
        for (end = 0; end < len && !Character.isSpaceChar(str2.charAt(end)); ++end) {
        }
        parts.add(str2.substring(beg, end));
        while (end < len && Character.isSpaceChar(str2.charAt(end))) {
            ++end;
        }
        beg = end;
        while (end < len && !Character.isSpaceChar(str2.charAt(end))) {
            ++end;
        }
        parts.add(str2.substring(beg, end));
        return parts;
    }

    private class IPdb {
        public static final String X_IP_HOSE_DB = "/org/openscience/cdk/qsar/descriptors/atomic/data/X_IP_HOSE.db";
        public static final String X_IP_HOSE_DB_S = "/org/openscience/cdk/qsar/descriptors/atomic/data/X_IP_HOSE_S.db";

        public double extractIP(IAtomContainer container2, IAtom atom) {
            HashMap<String, Double> hoseVSenergyS;
            HashMap<String, Double> hoseVSenergy;
            block39: {
                if (IPAtomicHOSEDescriptor.this.familyHalogen(atom)) {
                    BufferedReader insr;
                    InputStream ins;
                    try {
                        ins = this.getClass().getResourceAsStream(X_IP_HOSE_DB);
                        try {
                            insr = new BufferedReader(new InputStreamReader(ins));
                            try {
                                hoseVSenergy = this.extractAttributes(insr);
                            }
                            finally {
                                insr.close();
                            }
                        }
                        finally {
                            if (ins != null) {
                                ins.close();
                            }
                        }
                    }
                    catch (IOException e2) {
                        LoggingToolFactory.createLoggingTool(this.getClass()).error(e2);
                        return 0.0;
                    }
                    try {
                        ins = this.getClass().getResourceAsStream(X_IP_HOSE_DB_S);
                        try {
                            insr = new BufferedReader(new InputStreamReader(ins));
                            try {
                                hoseVSenergyS = this.extractAttributes(insr);
                                break block39;
                            }
                            finally {
                                insr.close();
                            }
                        }
                        finally {
                            if (ins != null) {
                                ins.close();
                            }
                        }
                    }
                    catch (IOException e3) {
                        LoggingToolFactory.createLoggingTool(this.getClass()).error(e3);
                        return 0.0;
                    }
                }
                return 0.0;
            }
            try {
                HOSECodeGenerator hcg = new HOSECodeGenerator(1);
                int exactSphere = 0;
                String hoseCode = "";
                for (int spheres = 10; spheres > 0; --spheres) {
                    hcg.getSpheres(container2, atom, spheres, true);
                    List<IAtom> atoms = hcg.getNodesInSphere(spheres);
                    if (atoms.size() == 0) continue;
                    exactSphere = spheres;
                    hoseCode = hcg.getHOSECode(container2, atom, spheres, true);
                    if (hoseVSenergy.containsKey(hoseCode)) {
                        return hoseVSenergy.get(hoseCode);
                    }
                    if (!hoseVSenergyS.containsKey(hoseCode)) break;
                    return hoseVSenergyS.get(hoseCode);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int plusMinus = 0; plusMinus < 2; ++plusMinus) {
                        int sign = -1;
                        if (plusMinus == 1) {
                            sign = 1;
                        }
                        StringTokenizer st = new StringTokenizer(hoseCode, "()/");
                        StringBuilder hoseCodeBuffer = new StringBuilder();
                        int sum = exactSphere + sign * (i + 1);
                        for (int k = 0; k < sum; ++k) {
                            if (st.hasMoreTokens()) {
                                String partcode = st.nextToken();
                                hoseCodeBuffer.append(partcode);
                            }
                            if (k == 0) {
                                hoseCodeBuffer.append('(');
                                continue;
                            }
                            if (k == 3) {
                                hoseCodeBuffer.append(')');
                                continue;
                            }
                            hoseCodeBuffer.append('/');
                        }
                        String hoseCodeBU = hoseCodeBuffer.toString();
                        if (!hoseVSenergyS.containsKey(hoseCodeBU)) continue;
                        return hoseVSenergyS.get(hoseCodeBU);
                    }
                }
            }
            catch (CDKException e4) {
                LoggingToolFactory.createLoggingTool(IPAtomicHOSEDescriptor.class).warn("Unexpected Error:", e4);
            }
            return 0.0;
        }

        private HashMap<String, Double> extractAttributes(BufferedReader input) {
            HashMap<String, Double> hoseVSenergy = new HashMap<String, Double>();
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    List values;
                    if (line.startsWith("#") || ((String)(values = IPAtomicHOSEDescriptor.extractInfo(line)).get(1)).equals("")) continue;
                    hoseVSenergy.put((String)values.get(0), Double.valueOf((String)values.get(1)));
                }
            }
            catch (IOException e2) {
                LoggingToolFactory.createLoggingTool(IPAtomicHOSEDescriptor.class).warn("Unexpected Error:", e2);
            }
            return hoseVSenergy;
        }
    }
}

