/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class APolDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(APolDescriptor.class);
    private static double[] polarizabilities;
    private static final String[] NAMES;

    public APolDescriptor() {
        if (polarizabilities == null) {
            polarizabilities = new double[]{0.0, 0.666793, 0.204956, 24.3, 5.6, 3.03, 1.76, 1.1, 0.802, 0.557, 0.3956, 23.6, 10.6, 6.8, 5.38, 3.63, 2.9, 2.18, 1.6411, 43.4, 22.8, 17.8, 14.6, 12.4, 11.6, 9.4, 8.4, 7.5, 6.8, 6.1, 7.1, 8.12, 6.07, 4.31, 3.77, 3.05, 2.4844, 47.3, 27.6, 22.7, 17.9, 15.7, 12.8, 11.4, 9.6, 8.6, 4.8, 7.2, 7.2, 10.2, 7.7, 6.6, 5.5, 5.35, 4.044, 59.6, 39.7, 31.1, 29.6, 28.2, 31.4, 30.1, 28.8, 27.7, 23.5, 25.5, 24.5, 23.6, 22.7, 21.8, 21.0, 21.9, 16.2, 13.1, 11.1, 9.7, 8.5, 7.6, 6.5, 5.8, 5.7, 7.6, 6.8, 7.4, 6.8, 6.0, 5.3, 48.7, 38.3, 32.1, 32.1, 25.4, 27.4, 24.8, 24.5, 23.3, 23.0, 22.7, 20.5, 19.7, 23.8, 18.2, 17.5};
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#apol", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        double apol = 0.0;
        try {
            Isotopes ifac = Isotopes.getInstance();
            for (IAtom atom : container2.atoms()) {
                String symbol = atom.getSymbol();
                IElement element = ifac.getElement(symbol);
                int atomicNumber = element.getAtomicNumber();
                apol += polarizabilities[atomicNumber];
                if (atom.getImplicitHydrogenCount() == CDKConstants.UNSET) continue;
                apol += polarizabilities[1] * (double)atom.getImplicitHydrogenCount().intValue();
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(apol), this.getDescriptorNames());
        }
        catch (Exception ex1) {
            logger.debug(ex1);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), new CDKException("Problems with IsotopeFactory due to " + ex1, ex1));
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    static {
        NAMES = new String[]{"apol"};
    }
}

