/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class AtomCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private String elementName = "*";

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomCount", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("AtomCount only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.elementName};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        String name = "n";
        name = this.elementName.equals("*") ? "nAtom" : name + this.elementName;
        return new String[]{name};
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        int atomCount = 0;
        if (container2 == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer was NULL"));
        }
        if (container2.getAtomCount() == 0) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer did not have any atoms"));
        }
        if (this.elementName.equals("*")) {
            for (int i = 0; i < container2.getAtomCount(); ++i) {
                Integer hcount = container2.getAtom(i).getImplicitHydrogenCount();
                if (hcount == CDKConstants.UNSET) continue;
                atomCount += hcount.intValue();
            }
            atomCount += container2.getAtomCount();
        } else if (this.elementName.equals("H")) {
            for (int i = 0; i < container2.getAtomCount(); ++i) {
                if (container2.getAtom(i).getSymbol().equals(this.elementName)) {
                    ++atomCount;
                    continue;
                }
                Integer hcount = container2.getAtom(i).getImplicitHydrogenCount();
                if (hcount == CDKConstants.UNSET) continue;
                atomCount += hcount.intValue();
            }
        } else {
            for (int i = 0; i < container2.getAtomCount(); ++i) {
                if (!container2.getAtom(i).getSymbol().equals(this.elementName)) continue;
                ++atomCount;
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(atomCount), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"elementName"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return "";
    }
}

