/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.ChiIndexUtils;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class ChiChainDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ChiChainDescriptor.class);
    private SmilesParser sp;
    private static final String[] NAMES = new String[]{"SCH-3", "SCH-4", "SCH-5", "SCH-6", "SCH-7", "VCH-3", "VCH-4", "VCH-5", "VCH-6", "VCH-7"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#chiChain", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        double order7v;
        double order6v;
        double order5v;
        double order4v;
        double order3v;
        if (this.sp == null) {
            this.sp = new SmilesParser(container2.getBuilder());
        }
        IAtomContainer localAtomContainer = AtomContainerManipulator.removeHydrogens(container2);
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container2.getBuilder());
        for (IAtom atom : localAtomContainer.atoms()) {
            try {
                IAtomType type = matcher.findMatchingAtomType(localAtomContainer, atom);
                AtomTypeManipulator.configure(atom, type);
            }
            catch (Exception e2) {
                return this.getDummyDescriptorValue(new CDKException("Error in atom typing: " + atom));
            }
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(container2.getBuilder());
        try {
            hAdder.addImplicitHydrogens(localAtomContainer);
        }
        catch (CDKException e3) {
            return this.getDummyDescriptorValue(new CDKException("Error in adding hydrogens: " + e3.getMessage()));
        }
        List subgraph3 = this.order3(localAtomContainer);
        List subgraph4 = this.order4(localAtomContainer);
        List subgraph5 = this.order5(localAtomContainer);
        List subgraph6 = this.order6(localAtomContainer);
        List subgraph7 = this.order7(localAtomContainer);
        double order3s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph3);
        double order4s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph4);
        double order5s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph5);
        double order6s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph6);
        double order7s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph7);
        try {
            order3v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph3);
            order4v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph4);
            order5v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph5);
            order6v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph6);
            order7v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph7);
        }
        catch (CDKException e4) {
            return this.getDummyDescriptorValue(new CDKException("Error in substructure search: " + e4.getMessage()));
        }
        DoubleArrayResult retval = new DoubleArrayResult();
        retval.add(order3s);
        retval.add(order4s);
        retval.add(order5s);
        retval.add(order6s);
        retval.add(order7s);
        retval.add(order3v);
        retval.add(order4v);
        retval.add(order5v);
        retval.add(order6v);
        retval.add(order7v);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(10);
    }

    private List order3(IAtomContainer container2) {
        ArrayList ret = new ArrayList();
        IRingSet rings = Cycles.sssr(container2).toRingSet();
        int nring = rings.getAtomContainerCount();
        for (int i = 0; i < nring; ++i) {
            IAtomContainer ring = rings.getAtomContainer(i);
            if (ring.getAtomCount() != 3) continue;
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            for (IAtom atom : ring.atoms()) {
                tmp.add(container2.indexOf(atom));
            }
            ret.add(tmp);
        }
        return ret;
    }

    private List order4(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[2];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("C1CCC1"), false);
            queries[1] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CC1"), false);
        }
        catch (InvalidSmilesException e2) {
            LoggingToolFactory.createLoggingTool(ChiChainDescriptor.class).warn("Unexpected Error:", e2);
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List order5(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[3];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("C1CCCC1"), false);
            queries[1] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CCC1"), false);
            queries[2] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CC1(C)"), false);
        }
        catch (InvalidSmilesException e2) {
            LoggingToolFactory.createLoggingTool(ChiChainDescriptor.class).warn("Unexpected Error:", e2);
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List order6(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[9];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CCCC1"), false);
            queries[1] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CC(C)C1"), false);
            queries[2] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1(C)(CCC1)"), false);
            queries[3] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC1CCC1"), false);
            queries[4] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("C1CCCCC1"), false);
            queries[5] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1CCC1(C)"), false);
            queries[6] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC1C(C)C1(C)"), false);
            queries[7] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCC1CC1"), false);
            queries[8] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC1CC1(C)"), false);
        }
        catch (InvalidSmilesException e2) {
            LoggingToolFactory.createLoggingTool(ChiChainDescriptor.class).warn("Unexpected Error:", e2);
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List order7(IAtomContainer atomContainer) {
        String[] smiles = new String[]{"C1CCCCC1C", "C1CCCC1(C)(C)", "C1(C)C(C)CCC1", "C1(C)CC(C)CC1", "C1CCCC1(CC)", "C1(C)C(C)C(C)C1", "C1CC(C)C1(CC)", "C1C(C)CC1(CC)", "C1CCC1(CCC)", "C1CCC1C(C)(C)", "C1CCC1(C)(CC)", "C1CC(C)C1(C)(C)", "C1C(C)CC1(C)(C)", "C1(C)C(C)C1(CC)", "C1C(C)(C)C1(C)(C)", "C1CC1CCCC", "C1C(C)C1(CCC)", "C1C(CC)C1(CC)", "C1C(C)C1C(C)(C)", "C1C(C)C1(C)(CC)", "C1CC1CC(C)(C)", "C1CC1C(C)CC", "C1CC1C(C)(C)(C)"};
        QueryAtomContainer[] queries = new QueryAtomContainer[smiles.length];
        try {
            for (int i = 0; i < smiles.length; ++i) {
                queries[i] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles(smiles[i]), false);
            }
        }
        catch (InvalidSmilesException e2) {
            LoggingToolFactory.createLoggingTool(ChiChainDescriptor.class).warn("Unexpected Error:", e2);
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }
}

