/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class GravitationalIndexDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(GravitationalIndexDescriptor.class);
    private static final String[] NAMES = new String[]{"GRAV-1", "GRAV-2", "GRAV-3", "GRAVH-1", "GRAVH-2", "GRAVH-3", "GRAV-4", "GRAV-5", "GRAV-6"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#gravitationalIndex", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        double mass2;
        double mass1;
        if (!GeometryUtil.has3DCoordinates(container2)) {
            return this.getDummyDescriptorValue(new CDKException("Molecule must have 3D coordinates"));
        }
        Isotopes factory = null;
        try {
            factory = Isotopes.getInstance();
        }
        catch (Exception e2) {
            logger.debug(e2);
        }
        double sum = 0.0;
        for (int i = 0; i < container2.getBondCount(); ++i) {
            IBond bond = container2.getBond(i);
            if (bond.getAtomCount() != 2) {
                return this.getDummyDescriptorValue(new CDKException("GravitationalIndex: Only handles 2 center bonds"));
            }
            mass1 = factory.getMajorIsotope(bond.getBegin().getSymbol()).getMassNumber().intValue();
            mass2 = factory.getMajorIsotope(bond.getEnd().getSymbol()).getMassNumber().intValue();
            Point3d p1 = bond.getBegin().getPoint3d();
            Point3d p2 = bond.getEnd().getPoint3d();
            double x1 = p1.x;
            double y1 = p1.y;
            double z1 = p1.z;
            double x2 = p2.x;
            double y2 = p2.y;
            double z2 = p2.z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            sum += mass1 * mass2 / dist;
        }
        double heavysum = 0.0;
        for (int i = 0; i < container2.getBondCount(); ++i) {
            IBond b = container2.getBond(i);
            if (b.getAtomCount() != 2) {
                return this.getDummyDescriptorValue(new CDKException("GravitationalIndex: Only handles 2 center bonds"));
            }
            if (b.getBegin().getAtomicNumber() == 1 || b.getEnd().getAtomicNumber() == 1) continue;
            mass1 = factory.getMajorIsotope(b.getBegin().getSymbol()).getMassNumber().intValue();
            mass2 = factory.getMajorIsotope(b.getEnd().getSymbol()).getMassNumber().intValue();
            Point3d point0 = b.getBegin().getPoint3d();
            Point3d point1 = b.getEnd().getPoint3d();
            double x1 = point0.x;
            double y1 = point0.y;
            double z1 = point0.z;
            double x2 = point1.x;
            double y2 = point1.y;
            double z2 = point1.z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            heavysum += mass1 * mass2 / dist;
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int i = 0; i < container2.getAtomCount(); ++i) {
            if (container2.getAtom(i).getAtomicNumber() == 1) continue;
            x.add(i);
        }
        int npair = x.size() * (x.size() - 1) / 2;
        pair[] p = new pair[npair];
        for (int i = 0; i < npair; ++i) {
            p[i] = new pair();
        }
        int pcount = 0;
        for (int i = 0; i < x.size() - 1; ++i) {
            for (int j = i + 1; j < x.size(); ++j) {
                boolean present = false;
                int a = (Integer)x.get(i);
                int b = (Integer)x.get(j);
                for (int k = 0; k < pcount; ++k) {
                    if ((p[k].x != a || p[k].y != b) && (p[k].y != a || p[k].x != b)) continue;
                    present = true;
                }
                if (present) continue;
                p[pcount].x = a;
                p[pcount].y = b;
                ++pcount;
            }
        }
        double allheavysum = 0.0;
        for (pair aP : p) {
            int atomNumber1 = aP.x;
            int atomNumber2 = aP.y;
            mass1 = factory.getMajorIsotope(container2.getAtom(atomNumber1).getSymbol()).getMassNumber().intValue();
            mass2 = factory.getMajorIsotope(container2.getAtom(atomNumber2).getSymbol()).getMassNumber().intValue();
            double x1 = container2.getAtom((int)atomNumber1).getPoint3d().x;
            double y1 = container2.getAtom((int)atomNumber1).getPoint3d().y;
            double z1 = container2.getAtom((int)atomNumber1).getPoint3d().z;
            double x2 = container2.getAtom((int)atomNumber2).getPoint3d().x;
            double y2 = container2.getAtom((int)atomNumber2).getPoint3d().y;
            double z2 = container2.getAtom((int)atomNumber2).getPoint3d().z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            allheavysum += mass1 * mass2 / dist;
        }
        DoubleArrayResult retval = new DoubleArrayResult(9);
        retval.add(heavysum);
        retval.add(Math.sqrt(heavysum));
        retval.add(Math.pow(heavysum, 0.3333333333333333));
        retval.add(sum);
        retval.add(Math.sqrt(sum));
        retval.add(Math.pow(sum, 0.3333333333333333));
        retval.add(allheavysum);
        retval.add(Math.sqrt(allheavysum));
        retval.add(Math.pow(allheavysum, 0.3333333333333333));
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(9);
    }

    private class pair {
        int x = 0;
        int y = 0;
    }
}

