/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class HybridizationRatioDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#hybratio", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"HybRatio"};
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        try {
            IAtomContainer clone = container2.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(clone);
            int nsp2 = 0;
            int nsp3 = 0;
            for (IAtom atom : clone.atoms()) {
                if (atom.getAtomicNumber() != 6) continue;
                if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                    ++nsp2;
                    continue;
                }
                if (atom.getHybridization() != IAtomType.Hybridization.SP3) continue;
                ++nsp3;
            }
            if (nsp2 + nsp3 == 0) {
                return this.getDummyDescriptorValue(new ArithmeticException("Cannot divide by 0"));
            }
            double ratio = (double)nsp3 / (double)(nsp2 + nsp3);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(ratio), this.getDescriptorNames());
        }
        catch (CloneNotSupportedException | CDKException e2) {
            return this.getDummyDescriptorValue(e2);
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return "";
    }
}

