/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class LargestPiSystemDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] NAMES = new String[]{"nAtomP"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#largestPiSystem", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("LargestPiSystemDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        int i;
        boolean[] originalFlag4 = new boolean[container2.getAtomCount()];
        for (int i2 = 0; i2 < originalFlag4.length; ++i2) {
            originalFlag4[i2] = container2.getAtom(i2).getFlag(16);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container2);
                Aromaticity.cdkLegacy().apply(container2);
            }
            catch (CDKException e2) {
                return this.getDummyDescriptorValue(e2);
            }
        }
        int largestPiSystemAtomsCount = 0;
        for (i = 0; i < container2.getAtomCount(); ++i) {
            container2.getAtom(i).setFlag(16, false);
        }
        for (i = 0; i < container2.getAtomCount(); ++i) {
            if (container2.getMaximumBondOrder(container2.getAtom(i)) == IBond.Order.SINGLE && Math.abs(container2.getAtom(i).getFormalCharge()) < 1 && !container2.getAtom(i).getFlag(32) && container2.getAtom(i).getAtomicNumber() != 7 && container2.getAtom(i).getAtomicNumber() != 8 || container2.getAtom(i).getFlag(16)) continue;
            ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
            ArrayList<IAtom> path = new ArrayList<IAtom>();
            startSphere.add(container2.getAtom(i));
            try {
                this.breadthFirstSearch(container2, startSphere, path);
            }
            catch (CDKException e3) {
                return this.getDummyDescriptorValue(e3);
            }
            if (path.size() <= largestPiSystemAtomsCount) continue;
            largestPiSystemAtomsCount = path.size();
        }
        for (i = 0; i < originalFlag4.length; ++i) {
            container2.getAtom(i).setFlag(16, originalFlag4[i]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(largestPiSystemAtomsCount), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    private void breadthFirstSearch(IAtomContainer container2, List<IAtom> sphere, List<IAtom> path) throws CDKException {
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (IAtom atom : sphere) {
            List<IBond> bonds = container2.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom = bond.getOther(atom);
                if ((container2.getMaximumBondOrder(nextAtom) != IBond.Order.SINGLE || Math.abs(nextAtom.getFormalCharge()) >= 1 || nextAtom.getFlag(32) || nextAtom.getAtomicNumber() == 7 || nextAtom.getAtomicNumber() == 8) & !nextAtom.getFlag(16)) {
                    path.add(nextAtom);
                    nextAtom.setFlag(16, true);
                    if (container2.getConnectedBondsCount(nextAtom) <= 1) continue;
                    newSphere.add(nextAtom);
                    continue;
                }
                nextAtom.setFlag(16, true);
            }
        }
        if (newSphere.size() > 0) {
            this.breadthFirstSearch(container2, newSphere, path);
        }
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if ("checkAromaticity".equals(name)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

