/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.AverageBondLengthCalculator;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.MoleculeSetRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class ReactionRenderer
extends AbstractRenderer<IReaction>
implements IRenderer<IReaction> {
    private final IRenderer<IAtomContainerSet> moleculeSetRenderer;

    public ReactionRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this(new RendererModel(), generators, fontManager);
        for (IGenerator<IAtomContainer> generator : generators) {
            this.rendererModel.registerParameters(generator);
        }
    }

    public ReactionRenderer(RendererModel rendererModel, List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        super(rendererModel);
        this.fontManager = fontManager;
        this.moleculeSetRenderer = new MoleculeSetRenderer(rendererModel, generators, fontManager);
    }

    public ReactionRenderer(List<IGenerator<IAtomContainer>> generators, List<IGenerator<IReaction>> reactionGenerators, IFontManager fontManager) {
        this(generators, fontManager);
        for (IGenerator<IReaction> generator : reactionGenerators) {
            this.rendererModel.registerParameters(generator);
        }
        this.generators = reactionGenerators;
        this.setup();
    }

    @Override
    public void setup(IReaction reaction, Rectangle screen) {
        this.setScale(reaction);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(reaction);
        this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    @Override
    public void setScale(IReaction reaction) {
        double bondLength = AverageBondLengthCalculator.calculateAverageBondLength(reaction);
        double scale = this.calculateScaleForBondLength(bondLength);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(scale);
    }

    @Override
    public Rectangle paint(IReaction reaction, IDrawVisitor drawVisitor) {
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(reaction);
        this.setupTransformNatural(modelBounds);
        IRenderingElement diagram = this.generateDiagram(reaction);
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(modelBounds);
    }

    @Override
    public void paint(IReaction reaction, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(reaction);
        this.setupTransformToFit(bounds, modelBounds, AverageBondLengthCalculator.calculateAverageBondLength(reaction), resetCenter);
        IRenderingElement diagram = this.generateDiagram(reaction);
        this.paint(drawVisitor, diagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IReaction reaction) {
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds(reaction));
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getDefault();
        }
        return (Double)this.rendererModel.getParameter(BasicSceneGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public IRenderingElement generateDiagram(IReaction reaction) {
        ElementGroup diagram = new ElementGroup();
        for (IGenerator generator : this.generators) {
            diagram.add(generator.generate(reaction, this.rendererModel));
        }
        diagram.add(this.moleculeSetRenderer.generateDiagram(reaction.getReactants()));
        diagram.add(this.moleculeSetRenderer.generateDiagram(reaction.getProducts()));
        return diagram;
    }

    @Override
    public List<IGenerator<IReaction>> getGenerators() {
        return new ArrayList<IGenerator<IReaction>>(this.generators);
    }
}

