/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.AverageBondLengthCalculator;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.ReactionRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class ReactionSetRenderer
extends AbstractRenderer<IReactionSet>
implements IRenderer<IReactionSet> {
    private final IRenderer<IReaction> reactionRenderer;

    public ReactionSetRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this(new RendererModel(), generators, fontManager);
        for (IGenerator<IAtomContainer> generator : generators) {
            this.rendererModel.registerParameters(generator);
        }
    }

    public ReactionSetRenderer(RendererModel rendererModel, List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        super(rendererModel);
        this.fontManager = fontManager;
        this.reactionRenderer = new ReactionRenderer(rendererModel, generators, fontManager);
        this.setup();
    }

    public ReactionSetRenderer(List<IGenerator<IAtomContainer>> generators, List<IGenerator<IReaction>> reactionGenerators, IFontManager fontManager) {
        this(new RendererModel(), generators, reactionGenerators, fontManager);
    }

    protected ReactionSetRenderer(RendererModel rendererModel, List<IGenerator<IAtomContainer>> generators, List<IGenerator<IReaction>> reactionGenerators, IFontManager fontManager) {
        super(rendererModel);
        this.fontManager = fontManager;
        this.reactionRenderer = new ReactionRenderer(generators, reactionGenerators, fontManager);
        this.setup();
    }

    @Override
    public void setup(IReactionSet reactionSet, Rectangle screen) {
        this.setScale(reactionSet);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(reactionSet);
        this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    @Override
    public void setScale(IReactionSet reactionSet) {
        double bondLength = AverageBondLengthCalculator.calculateAverageBondLength(reactionSet);
        double scale = this.calculateScaleForBondLength(bondLength);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(scale);
    }

    @Override
    public Rectangle paint(IReactionSet reactionSet, IDrawVisitor drawVisitor) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds(reactionSet);
        this.setupTransformNatural(totalBounds);
        ElementGroup diagram = new ElementGroup();
        for (IReaction reaction : reactionSet.reactions()) {
            diagram.add(this.reactionRenderer.generateDiagram(reaction));
        }
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(totalBounds);
    }

    @Override
    public void paint(IReactionSet reactionSet, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds(reactionSet);
        this.setupTransformToFit(bounds, totalBounds, AverageBondLengthCalculator.calculateAverageBondLength(reactionSet), resetCenter);
        ElementGroup diagram = new ElementGroup();
        for (IReaction reaction : reactionSet.reactions()) {
            diagram.add(this.reactionRenderer.generateDiagram(reaction));
        }
        this.paint(drawVisitor, diagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IReactionSet reactionSet) {
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds(reactionSet));
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getDefault();
        }
        return (Double)this.rendererModel.getParameter(BasicSceneGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public List<IGenerator<IReactionSet>> getGenerators() {
        return null;
    }
}

