/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.io.IOException;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class AtomMassGenerator
extends BasicAtomGenerator {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomMassGenerator.class);

    @Override
    public boolean showCarbon(IAtom atom, IAtomContainer container2, RendererModel model) {
        Integer massNumber = atom.getMassNumber();
        if (massNumber != null) {
            try {
                Integer expectedMassNumber = Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getMassNumber();
                if (!massNumber.equals(expectedMassNumber)) {
                    return true;
                }
            }
            catch (IOException e2) {
                this.logger.warn(e2);
            }
        }
        return super.showCarbon(atom, container2, model);
    }
}

