/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.config.Elements;

final class AbbreviationLabel {
    private static final String MINUS_STRING = "\u2212";
    private static final String[] PREFIX_LIST = new String[]{"n", "norm", "n-", "c", "cy", "cyc", "cyclo", "c-", "cy-", "cyc-", "i", "iso", "i-", "t", "tert", "t-", "s", "sec", "s-", "o", "ortho", "o-", "m", "meta", "m-", "p", "para", "p-", "1-", "2-", "3-", "4-", "5-", "6-", "7-", "8-", "9-"};
    private static final String[] ITAL_PREFIX = new String[]{"n", "norm", "sec", "s", "tert", "t", "ortho", "o", "meta", "m", "para", "p"};
    private static final String[] SYMBOL_LIST = new String[]{"acac", "Ace", "Acetyl", "Acyl", "Ad", "All", "Alloc", "Allyl", "Amyl", "AOC", "BDMS", "Benzoyl", "Benzyl", "Bn", "BOC", "Boc", "BOM", "bpy", "Bromo", "Bs", "Bu", "But", "Butyl", "Bz", "Bzl", "Car", "Cbz", "Chloro", "CoA", "Cy", "dppf", "dppp", "dba", "D", "Dan", "Dansyl", "DEIPS", "DEM", "Dip", "Dmb", "DPA", "DTBMS", "EE", "EOM", "Et", "Ethyl", "Fluoro", "FMOC", "Fmoc", "Formyl", "Heptyl", "Hexyl", "Iodo", "IPDMS", "Me", "MEM", "Mesityl", "Mesyl", "Methoxy", "Methyl", "MOM", "Ms", "Nitro", "Oct", "Octyl", "PAB", "Pentyl", "Ph", "Phenyl", "Pivaloyl", "PMB", "Pro", "Propargyl", "Propyl", "Pv", "R", "SEM", "T", "TBS", "TBDMS", "Trt", "TBDPS", "TES", "Tf", "THP", "THPO", "TIPS", "TMS", "Tos", "Tol", "Tosyl", "Tr", "Troc", "Vinyl", "Voc", "Z"};
    private static final Trie PREFIX_TRIE = new Trie();
    private static final Trie ITAL_PREFIX_TRIE = new Trie();
    private static final Trie SYMBOL_TRIE = new Trie();
    static final int STYLE_NORMAL = 0;
    static final int STYLE_SUBSCRIPT = -1;
    static final int STYLE_SUPSCRIPT = 1;
    static final int STYLE_ITALIC = 2;

    AbbreviationLabel() {
    }

    static boolean parse(String label, List<String> tokens) {
        int i = 0;
        int len = label.length();
        while (i < len) {
            int st = i;
            char c = label.charAt(i);
            if (c == '(' || c == ')') {
                tokens.add(Character.toString(c));
                ++i;
                if (c != ')') continue;
                st = i;
                while (i < len && AbbreviationLabel.isDigit(c = label.charAt(i))) {
                    ++i;
                }
                if (i <= st) continue;
                tokens.add(label.substring(st, i));
                continue;
            }
            if (c == '/' || c == '\u00b7' || c == '.' || c == '\u2022' || c == '=') {
                tokens.add(Character.toString(c));
                int beg = ++i;
                while (i < label.length() && AbbreviationLabel.isDigit(label.charAt(i))) {
                    ++i;
                }
                if (i <= beg) continue;
                tokens.add(label.substring(beg, i));
                continue;
            }
            int last = AbbreviationLabel.findPrefix(PREFIX_TRIE, label, i, -1);
            if (last > 0) {
                i += last - i;
            }
            int symSt = i;
            last = AbbreviationLabel.findPrefix(SYMBOL_TRIE, label, i, -1);
            if (last > 0) {
                i += last - i;
                while (i < len && AbbreviationLabel.isDigit(label.charAt(i))) {
                    ++i;
                }
            } else if (i == st && st > 0 && ((c = AbbreviationLabel.norm(label.charAt(i))) == '-' || c == '+')) {
                ++i;
                while (i < len && AbbreviationLabel.isDigit(label.charAt(i))) {
                    ++i;
                }
                if (i < len) {
                    return AbbreviationLabel.failParse(label, tokens);
                }
            }
            if (i == st || i == symSt) {
                return AbbreviationLabel.failParse(label, tokens);
            }
            tokens.add(label.substring(st, i));
        }
        return true;
    }

    private static boolean failParse(String label, List<String> tokens) {
        tokens.clear();
        tokens.add(label);
        return false;
    }

    private static boolean isNumber(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            if (AbbreviationLabel.isDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static void reverse(List<String> tokens) {
        Collections.reverse(tokens);
        ArrayDeque<String> numbers = new ArrayDeque<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.equals("(")) {
                tokens.set(i, ")");
                String num = (String)numbers.pop();
                if (num.isEmpty()) continue;
                tokens.add(i + 1, num);
                ++i;
                continue;
            }
            if (!token.equals(")")) continue;
            tokens.set(i, "(");
            if (i > 0 && AbbreviationLabel.isNumber(tokens.get(i - 1))) {
                numbers.push(tokens.remove(i - 1));
                --i;
                continue;
            }
            numbers.push("");
        }
    }

    static List<FormattedText> format(List<String> tokens) {
        ArrayList<FormattedText> texts = new ArrayList<FormattedText>(2 + tokens.size());
        for (String token : tokens) {
            int j;
            if (AbbreviationLabel.isChargeToken(token)) {
                String coef;
                String sign = Character.toString(AbbreviationLabel.norm(token.charAt(0)));
                String string = coef = token.length() > 1 ? token.substring(1) : "";
                if (sign.equals("-")) {
                    sign = MINUS_STRING;
                }
                texts.add(new FormattedText(coef + sign, 1));
                continue;
            }
            if (token.length() == 1 && AbbreviationLabel.isDigit(token.charAt(0)) && !texts.isEmpty() && ((FormattedText)texts.get((int)(texts.size() - 1))).text.equals(")")) {
                texts.add(new FormattedText(token, -1));
                continue;
            }
            int i = AbbreviationLabel.findPrefix(ITAL_PREFIX_TRIE, token, 0, 0);
            for (j = token.length(); j > 0 && AbbreviationLabel.isDigit(token.charAt(j - 1)); --j) {
            }
            if (j > 0 && j < token.length()) {
                if (i > j) {
                    i = 0;
                }
                if (i > 0) {
                    texts.add(new FormattedText(token.substring(0, i), 2));
                }
                texts.add(new FormattedText(token.substring(i, j), 0));
                texts.add(new FormattedText(token.substring(j), -1));
                continue;
            }
            if (i > 0) {
                texts.add(new FormattedText(token.substring(0, i), 2));
            }
            texts.add(new FormattedText(token.substring(i), 0));
        }
        return texts;
    }

    static void reduce(List<FormattedText> texts, int from, int to) {
        ArrayList<FormattedText> tmp = new ArrayList<FormattedText>(texts.size());
        FormattedText prev = null;
        tmp.addAll(texts.subList(0, from));
        for (FormattedText curr : texts.subList(from, to)) {
            if (prev == null || prev.style != curr.style) {
                prev = curr;
                tmp.add(prev);
                continue;
            }
            prev.text = prev.text + curr.text;
        }
        tmp.addAll(texts.subList(to, texts.size()));
        texts.clear();
        texts.addAll(tmp);
    }

    private static boolean isChargeToken(String token) {
        return token.length() > 0 && (AbbreviationLabel.norm(token.charAt(0)) == '-' || token.charAt(0) == '+');
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static char norm(char c) {
        switch (c) {
            case '-': 
            case '\u2012': 
            case '\u2013': 
            case '\u2014': 
            case '\u2212': {
                return '-';
            }
        }
        return c;
    }

    private static int findPrefix(Trie trie, String string, int i, int best) {
        if (trie == null) {
            return best;
        }
        if (trie.token != null) {
            best = i;
        }
        if (i == string.length()) {
            return best;
        }
        char c = AbbreviationLabel.norm(string.charAt(i));
        if (c > '\u0080') {
            return best;
        }
        return AbbreviationLabel.findPrefix(trie.children[c], string, i + 1, best);
    }

    private static Trie insert(Trie trie, String str2, int i) {
        if (trie == null) {
            trie = new Trie();
        }
        if (i == str2.length()) {
            trie.token = str2;
        } else {
            char c = str2.charAt(i);
            trie.children[c] = AbbreviationLabel.insert(trie.children[c], str2, i + 1);
        }
        return trie;
    }

    static {
        for (String string : PREFIX_LIST) {
            AbbreviationLabel.insert(PREFIX_TRIE, string, 0);
        }
        for (String string : ITAL_PREFIX) {
            AbbreviationLabel.insert(ITAL_PREFIX_TRIE, string, 0);
        }
        for (Elements elements : Elements.values()) {
            if (elements.symbol().isEmpty()) continue;
            AbbreviationLabel.insert(SYMBOL_TRIE, elements.symbol(), 0);
        }
        for (String string : SYMBOL_LIST) {
            AbbreviationLabel.insert(SYMBOL_TRIE, string, 0);
        }
    }

    private static final class Trie {
        String token;
        final Trie[] children = new Trie[128];

        private Trie() {
        }
    }

    static final class FormattedText {
        String text;
        final int style;

        public FormattedText(String text, int style) {
            this.text = text;
            this.style = style;
        }
    }
}

