/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregor;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.map.VFMapper;
import org.openscience.cdk.smsd.algorithm.vflib.query.QueryCompiler;
import org.openscience.cdk.smsd.interfaces.AbstractSubGraph;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class VFlibTurboHandler
extends AbstractSubGraph
implements IMCSBase {
    private List<Map<IAtom, IAtom>> allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
    private Map<IAtom, IAtom> atomsMCS;
    private List<Map<IAtom, IAtom>> allAtomMCSCopy = new ArrayList<Map<IAtom, IAtom>>();
    private Map<Integer, Integer> firstMCS;
    private List<Map<Integer, Integer>> allMCS;
    private List<Map<Integer, Integer>> allMCSCopy;
    private IQueryAtomContainer queryMol = null;
    private IAtomContainer mol1 = null;
    private IAtomContainer mol2 = null;
    private Map<INode, IAtom> vfLibSolutions = null;
    private int vfMCSSize = -1;
    private boolean bondMatchFlag = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(VFlibTurboHandler.class);

    public VFlibTurboHandler() {
        this.atomsMCS = new HashMap<IAtom, IAtom>();
        this.firstMCS = new TreeMap<Integer, Integer>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allMCSCopy = new ArrayList<Map<Integer, Integer>>();
    }

    private void setFirstMappings() {
        if (!this.allAtomMCS.isEmpty()) {
            this.atomsMCS.putAll(this.allAtomMCS.get(0));
            this.firstMCS.putAll(this.allMCS.get(0));
        }
    }

    private boolean mcgregorFlag() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        return commonAtomCount > this.vfMCSSize;
    }

    @Override
    public void set(MolHandler reactant, MolHandler product) {
        this.mol1 = reactant.getMolecule();
        this.mol2 = product.getMolecule();
    }

    @Override
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.queryMol = source;
        this.mol2 = target;
    }

    private boolean hasMap(Map<Integer, Integer> map, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> test : mapGlobal) {
            if (!test.equals(map)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public List<Map<Integer, Integer>> getAllMapping() {
        return Collections.unmodifiableList(this.allMCS);
    }

    @Override
    public Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(this.atomsMCS);
    }

    @Override
    public Map<Integer, Integer> getFirstMapping() {
        return Collections.unmodifiableMap(this.firstMCS);
    }

    private int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    private void searchVFMappings() {
        this.vfLibSolutions = new HashMap<INode, IAtom>();
        if (this.queryMol != null) {
            Map<INode, IAtom> map;
            IQuery query = new QueryCompiler(this.queryMol).compile();
            VFMapper mapper = new VFMapper(query);
            if (mapper.hasMap(this.getProductMol()) && (map = mapper.getFirstMap(this.getProductMol())) != null) {
                this.vfLibSolutions.putAll(map);
            }
            this.setVFMappings(true, query);
        } else if (this.getReactantMol().getAtomCount() <= this.getProductMol().getAtomCount()) {
            Map<INode, IAtom> map;
            IQuery query = new QueryCompiler(this.mol1, this.isBondMatchFlag()).compile();
            VFMapper mapper = new VFMapper(query);
            if (mapper.hasMap(this.getProductMol()) && (map = mapper.getFirstMap(this.getProductMol())) != null) {
                this.vfLibSolutions.putAll(map);
            }
            this.setVFMappings(true, query);
        } else {
            Map<INode, IAtom> map;
            IQuery query = new QueryCompiler(this.getProductMol(), this.isBondMatchFlag()).compile();
            VFMapper mapper = new VFMapper(query);
            if (mapper.hasMap(this.getReactantMol()) && (map = mapper.getFirstMap(this.getReactantMol())) != null) {
                this.vfLibSolutions.putAll(map);
            }
            this.setVFMappings(false, query);
        }
    }

    private void searchMcGregorMapping() throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        for (Map<Integer, Integer> firstPassMappings : this.allMCSCopy) {
            McGregor mgit = new McGregor(this.getReactantMol(), this.getProductMol(), mappings, this.isBondMatchFlag());
            mgit.startMcGregorIteration(mgit.getMCSSize(), firstPassMappings);
            mappings = mgit.getMappings();
            mgit = null;
        }
        this.setMcGregorMappings(mappings);
        this.vfMCSSize /= 2;
    }

    private void setVFMappings(boolean ronp, IQuery query) {
        int counter = 0;
        HashMap<IAtom, IAtom> atomatomMapping = new HashMap<IAtom, IAtom>();
        TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
        if (this.vfLibSolutions.size() > this.vfMCSSize) {
            this.vfMCSSize = this.vfLibSolutions.size();
            this.allAtomMCSCopy.clear();
            this.allMCSCopy.clear();
            counter = 0;
        }
        for (Map.Entry<INode, IAtom> mapping : this.vfLibSolutions.entrySet()) {
            IAtom tAtom;
            IAtom qAtom;
            if (ronp) {
                qAtom = query.getAtom(mapping.getKey());
                tAtom = mapping.getValue();
            } else {
                tAtom = query.getAtom(mapping.getKey());
                qAtom = mapping.getValue();
            }
            Integer qIndex = this.getReactantMol().indexOf(qAtom);
            Integer tIndex = this.getProductMol().indexOf(tAtom);
            if (qIndex != null && tIndex != null) {
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
                continue;
            }
            try {
                throw new CDKException("Atom index pointing to NULL");
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        if (!atomatomMapping.isEmpty() && !this.hasMap(indexindexMapping, this.allMCSCopy) && indexindexMapping.size() == this.vfMCSSize) {
            this.allAtomMCSCopy.add(counter, atomatomMapping);
            this.allMCSCopy.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private void setMcGregorMappings(List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        this.vfMCSSize = 0;
        for (List<Integer> mapping : mappings) {
            if (mapping.size() > this.vfMCSSize) {
                this.vfMCSSize = mapping.size() / 2;
                this.allAtomMCS.clear();
                this.allMCS.clear();
                counter = 0;
            }
            HashMap<IAtom, IAtom> atomatomMapping = new HashMap<IAtom, IAtom>();
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                IAtom qAtom = this.getReactantMol().getAtom(mapping.get(index));
                IAtom tAtom = this.getProductMol().getAtom(mapping.get(index + 1));
                Integer qIndex = mapping.get(index);
                Integer tIndex = mapping.get(index + 1);
                if (qIndex == -1 || tIndex == -1) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, this.allMCS) || indexindexMapping.size() != this.vfMCSSize) continue;
            this.allAtomMCS.add(counter, atomatomMapping);
            this.allMCS.add(counter, indexindexMapping);
            ++counter;
        }
    }

    @Override
    public boolean isSubgraph(boolean shouldMatchBonds) {
        this.setBondMatchFlag(shouldMatchBonds);
        this.searchVFMappings();
        if (!this.allAtomMCSCopy.isEmpty()) {
            this.allAtomMCS.addAll(this.allAtomMCSCopy);
            this.allMCS.addAll(this.allMCSCopy);
        }
        this.setFirstMappings();
        return !this.allMCS.isEmpty() && this.allMCS.iterator().next().size() == this.getReactantMol().getAtomCount();
    }

    public boolean isBondMatchFlag() {
        return this.bondMatchFlag;
    }

    public void setBondMatchFlag(boolean shouldMatchBonds) {
        this.bondMatchFlag = shouldMatchBonds;
    }

    private IAtomContainer getReactantMol() {
        return this.queryMol == null ? this.mol1 : this.queryMol;
    }

    private IAtomContainer getProductMol() {
        return this.mol2;
    }
}

