/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.smsd.labelling.CanonicalLabellingAdaptor;
import org.openscience.cdk.smsd.labelling.ICanonicalMoleculeLabeller;
import org.openscience.cdk.smsd.tools.ExtAtomContainerManipulator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class MolHandler {
    private IAtomContainer atomContainer = null;
    private boolean removeHydrogen;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MolHandler.class);
    private final ICanonicalMoleculeLabeller canonLabeler = new CanonicalLabellingAdaptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MolHandler(String molFile, boolean removeHydrogen, boolean cleanMolecule) {
        MDLReader molRead = null;
        this.removeHydrogen = removeHydrogen;
        FileInputStream readMolecule = new FileInputStream(molFile);
        molRead = new MDLReader(new InputStreamReader(readMolecule));
        this.atomContainer = molRead.read(new AtomContainer());
        molRead.close();
        readMolecule.close();
        if (removeHydrogen) {
            this.atomContainer = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(this.atomContainer);
        }
        if (cleanMolecule) {
            if (!this.isPseudoAtoms()) {
                this.atomContainer = this.canonLabeler.getCanonicalMolecule(this.atomContainer);
            }
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.atomContainer);
            CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance(this.atomContainer.getBuilder());
            adder.addImplicitHydrogens(this.atomContainer);
            Aromaticity.cdkLegacy().apply(this.atomContainer);
            BondTools.makeUpDownBonds(this.atomContainer);
        }
        if (molRead == null) return;
        try {
            molRead.close();
            return;
        }
        catch (IOException ioe) {
            this.logger.warn("Couldn't close molReader: ", ioe.getMessage());
            this.logger.debug(ioe);
        }
        return;
        catch (IOException ex) {
            this.logger.debug(ex);
            if (molRead == null) return;
            try {
                molRead.close();
                return;
            }
            catch (IOException ioe) {
                this.logger.warn("Couldn't close molReader: ", ioe.getMessage());
                this.logger.debug(ioe);
            }
            return;
        }
        catch (CDKException e2) {
            System.err.println(e2);
            if (molRead == null) return;
            {
                catch (Throwable throwable) {
                    if (molRead == null) throw throwable;
                    try {
                        molRead.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        this.logger.warn("Couldn't close molReader: ", ioe.getMessage());
                        this.logger.debug(ioe);
                    }
                    throw throwable;
                }
            }
            try {
                molRead.close();
                return;
            }
            catch (IOException ioe) {
                this.logger.warn("Couldn't close molReader: ", ioe.getMessage());
                this.logger.debug(ioe);
            }
            return;
        }
    }

    public MolHandler(IAtomContainer container2, boolean removeHydrogen, boolean cleanMolecule) {
        String molID = container2.getID();
        this.removeHydrogen = removeHydrogen;
        this.atomContainer = container2;
        if (removeHydrogen) {
            try {
                this.atomContainer = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(this.atomContainer);
            }
            catch (Exception ex) {
                this.logger.error(ex);
            }
        } else {
            this.atomContainer = container2.getBuilder().newInstance(IAtomContainer.class, this.atomContainer);
        }
        if (cleanMolecule) {
            try {
                if (!this.isPseudoAtoms()) {
                    this.atomContainer = this.canonLabeler.getCanonicalMolecule(this.atomContainer);
                }
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.atomContainer);
                CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance(this.atomContainer.getBuilder());
                adder.addImplicitHydrogens(this.atomContainer);
                Aromaticity.cdkLegacy().apply(this.atomContainer);
            }
            catch (CDKException ex) {
                this.logger.error(ex);
            }
        }
        this.atomContainer.setID(molID);
    }

    public IAtomContainer getMolecule() {
        return this.atomContainer;
    }

    public boolean getRemoveHydrogenFlag() {
        return this.removeHydrogen;
    }

    private boolean isPseudoAtoms() {
        for (IAtom atoms : this.atomContainer.atoms()) {
            if (!(atoms instanceof IPseudoAtom)) continue;
            return true;
        }
        return false;
    }
}

