/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.stereo.AbstractStereo;

public final class ExtendedCisTrans
extends AbstractStereo<IBond, IBond> {
    public ExtendedCisTrans(IBond focus, IBond[] peripherals, int config) {
        super((IChemObject)focus, (IChemObject[])peripherals, 0x2200 | 0xFF & config);
    }

    private static IAtom getOtherAtom(IAtomContainer mol, IAtom atom, IAtom other) {
        List<IBond> bonds = mol.getConnectedBondsList(atom);
        if (bonds.size() != 2) {
            return null;
        }
        if (bonds.get(0).contains(other)) {
            return bonds.get(1).getOrder() == IBond.Order.DOUBLE ? bonds.get(1).getOther(atom) : null;
        }
        return bonds.get(0).getOrder() == IBond.Order.DOUBLE ? bonds.get(0).getOther(atom) : null;
    }

    public static IAtom[] findTerminalAtoms(IAtomContainer container2, IBond focus) {
        IAtom a = focus.getBegin();
        IAtom b = focus.getEnd();
        IAtom aPrev = a;
        IAtom bPrev = b;
        IAtom aNext = ExtendedCisTrans.getOtherAtom(container2, a, b);
        IAtom bNext = ExtendedCisTrans.getOtherAtom(container2, b, a);
        while (aNext != null && bNext != null) {
            IAtom tmp = ExtendedCisTrans.getOtherAtom(container2, aNext, aPrev);
            aPrev = aNext;
            aNext = tmp;
            tmp = ExtendedCisTrans.getOtherAtom(container2, bNext, bPrev);
            bPrev = bNext;
            bNext = tmp;
        }
        if (aPrev != null && bPrev != null) {
            return new IAtom[]{aPrev, bPrev};
        }
        return null;
    }

    public static IBond findCentralBond(IAtomContainer mol, IAtom atom) {
        boolean found;
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        IAtom prevAtom = atom;
        IBond prevBond = null;
        block0: do {
            found = false;
            for (IBond bond : mol.getConnectedBondsList(prevAtom)) {
                if (prevBond == bond || bond.getOrder() != IBond.Order.DOUBLE) continue;
                bonds.add(bond);
                found = true;
                prevBond = bond;
                prevAtom = bond.getOther(prevAtom);
                continue block0;
            }
        } while (found);
        int nbonds = bonds.size();
        if ((nbonds & 1) == 0) {
            return null;
        }
        return (IBond)bonds.get(nbonds / 2);
    }

    @Override
    protected IStereoElement<IBond, IBond> create(IBond focus, List<IBond> carriers, int cfg) {
        return new ExtendedCisTrans(focus, carriers.toArray(new IBond[2]), cfg);
    }
}

