/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.maygen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.stream.IntStream;

class HydrogenDistributor {
    private int[] capacity;
    private int[] valences;
    private int totalHydrogen;
    private int[] totalAtom;
    private int hydrogens2distribute;

    HydrogenDistributor() {
    }

    public int[] addElement(int[] a, int e2) {
        a = Arrays.copyOf(a, a.length + 1);
        a[a.length - 1] = e2;
        return a;
    }

    public int sum(int[] list, int index) {
        int sum = 0;
        for (int i = 0; i <= index; ++i) {
            sum += list[i];
        }
        return sum;
    }

    public int[] setValues(int[] partition, int[] degrees) {
        int partitionSize = partition.length;
        int[] localCapacity = new int[partitionSize];
        int[] localValences = new int[partitionSize];
        int[] localTotalAtom = new int[partitionSize];
        int i = 0;
        for (int j = 0; j < partitionSize; ++j) {
            localTotalAtom[i] = partition[i];
            int sum = this.sum(partition, i);
            localValences[i] = degrees[sum - 1] - 1;
            localCapacity[i] = (degrees[sum - 1] - 1) * partition[i];
            ++i;
        }
        this.capacity = localCapacity;
        this.valences = localValences;
        this.totalAtom = localTotalAtom;
        return localCapacity;
    }

    public int sum(int[] array) {
        int sum = 0;
        for (int j : array) {
            sum += j;
        }
        return sum;
    }

    public int[] mergeArrays(List<int[]> arrays) {
        int size = 0;
        for (int[] array : arrays) {
            size += array.length;
        }
        int[] mergedArray = new int[size];
        int index = 0;
        for (int[] array : arrays) {
            for (int i : array) {
                mergedArray[index++] = i;
            }
        }
        return mergedArray;
    }

    public int[] arraySum(int[] a, int[] b) {
        ArrayList<int[]> arrays = new ArrayList<int[]>();
        arrays.add(a);
        arrays.add(b);
        return this.mergeArrays(arrays);
    }

    public List<int[]> combineArrays(Deque<List<int[]>> lists) {
        ArrayList<int[]> comb = new ArrayList<int[]>((Collection)lists.removeFirst());
        while (!lists.isEmpty()) {
            List<int[]> list = lists.removeFirst();
            ArrayList<int[]> newComb = new ArrayList<int[]>();
            for (int[] arr1 : comb) {
                for (int[] arr2 : list) {
                    newComb.add(this.arraySum(arr1, arr2));
                }
            }
            comb = newComb;
        }
        return comb;
    }

    public List<int[]> run(int[] partition, int[] degrees) {
        ArrayList<int[]> result;
        int partitionSize = partition.length;
        int hydrogen = partition[partitionSize - 1];
        int isotopes = partitionSize - 1;
        this.setValues(partition, degrees);
        this.totalHydrogen = hydrogen;
        if (isotopes == 1) {
            ArrayList<int[]> iarrays = new ArrayList<int[]>();
            int[] array = new int[]{};
            this.hydrogens2distribute = this.totalHydrogen;
            this.distribute(iarrays, this.totalHydrogen, array, this.valences[0], this.totalAtom[0]);
            result = iarrays;
        } else {
            ArrayList<int[]> distributions = new ArrayList<int[]>();
            for (int[] dene : this.partition(this.totalHydrogen, isotopes, 0)) {
                ArrayDeque<List<int[]>> lists = new ArrayDeque<List<int[]>>();
                for (int i = 0; i < dene.length; ++i) {
                    this.hydrogens2distribute = dene[i];
                    ArrayList<int[]> iarrays = new ArrayList<int[]>();
                    int[] array = new int[]{};
                    this.distribute(iarrays, dene[i], array, this.valences[i], this.totalAtom[i]);
                    lists.add(iarrays);
                }
                List<int[]> combined = this.combineArrays(lists);
                distributions.addAll(combined);
            }
            result = distributions;
        }
        return result;
    }

    public List<int[]> partition(int n, int d, int depth) {
        if (d == depth) {
            ArrayList<int[]> array = new ArrayList<int[]>();
            int[] take = new int[]{};
            array.add(take);
            return array;
        }
        return this.buildArray(n, d, depth);
    }

    public List<int[]> buildArray(int n, int d, int depth) {
        ArrayList<int[]> array = new ArrayList<int[]>();
        IntStream range = IntStream.rangeClosed(0, n);
        for (int i : range.toArray()) {
            for (int[] item : this.partition(n - i, d, depth + 1)) {
                this.buildArrayItem(d, array, i, item);
            }
        }
        return array;
    }

    public void buildArrayItem(int d, List<int[]> array, int i, int[] item) {
        if (i <= this.capacity[item.length]) {
            if ((item = this.addElement(item, i)).length == d) {
                if (this.sum(item) == this.totalHydrogen) {
                    array.add(item);
                }
            } else {
                array.add(item);
            }
        }
    }

    public int[] addZeros(int[] array, int zeros) {
        for (int i = 0; i < zeros; ++i) {
            array = this.addElement(array, 0);
        }
        return array;
    }

    public int[] descendingOrderArray(int[] arr) {
        return Arrays.stream(arr).boxed().sorted().mapToInt(Integer::intValue).toArray();
    }

    public void distribute(List<int[]> arrays, int hydrogen, int[] arr, int valence, int numAtom) {
        if (hydrogen == 0 && this.sum(arr) == this.hydrogens2distribute) {
            if (arr.length != numAtom) {
                arr = this.addZeros(arr, numAtom - arr.length);
            }
            arr = this.descendingOrderArray(arr);
            arrays.add(arr);
        } else if (numAtom - arr.length == 1) {
            this.numAtomMinusArrLengthEqualsOne(arrays, hydrogen, arr, valence, numAtom);
        } else {
            for (int i = Math.min(valence, hydrogen); i > 0; --i) {
                if (arr.length == 0) {
                    this.distribute(arrays, hydrogen - i, this.addElement(arr, i), valence, numAtom);
                }
                if (arr.length <= 0 || arr[arr.length - 1] > i) continue;
                this.distribute(arrays, hydrogen - i, this.addElement(arr, i), valence, numAtom);
            }
        }
    }

    public void numAtomMinusArrLengthEqualsOne(List<int[]> arrays, int hydrogen, int[] arr, int valence, int numAtom) {
        int add = Math.min(hydrogen, valence);
        if (arr.length == 0) {
            this.distribute(arrays, 0, this.addElement(arr, add), valence, numAtom);
        }
        if (arr.length > 0 && arr[arr.length - 1] <= add) {
            this.distribute(arrays, 0, this.addElement(arr, add), valence, numAtom);
        }
    }
}

