/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.invariant.CanonicalLabeler;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class HOSECodeGenerator
implements Serializable {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(HOSECodeGenerator.class);
    private static final long serialVersionUID = -4353471818831864513L;
    protected List<TreeNode> sphereNodes;
    private final List<IAtom> sphereNodesWithAtoms;
    private List<TreeNode> nextSphereNodes;
    protected int sphere = 0;
    private int maxSphere = 0;
    protected List<TreeNode>[] spheres = null;
    private List<IAtom>[] spheresWithAtoms = null;
    protected StringBuffer HOSECode;
    protected IAtomContainer atomContainer;
    private final String[] sphereDelimiters = new String[]{"(", "/", "/", ")", "/", "/", "/", "/", "/", "/", "/", "/"};
    protected String[] bondSymbols = new String[]{"", "", "=", "%", "*"};
    protected String centerCode = null;
    private TreeNode rootNode = null;
    boolean debug = false;
    private final IAtomContainer acold = null;
    private IRingSet soar = null;
    private static final String[] rankedSymbols = new String[]{"C", "O", "N", "S", "P", "Si", "B", "F", "Cl", "Br", ";", "I", "#", "&", ","};
    private static final int[] symbolRankings = new int[]{9000, 8900, 8800, 8700, 8600, 8500, 8400, 8300, 8200, 8100, 8000, 7900, 1200, 1100, 1000};
    private static final int[] bondRankings = new int[]{0, 0, 200000, 300000, 100000};
    private static final int DEFAULT_MODE = 0;
    public static final int LEGACY_MODE = 1;
    private final int flags;
    private IsotopeFactory isotopeFac = null;

    public HOSECodeGenerator(int flags) {
        this.flags = flags;
        this.sphereNodes = new ArrayList<TreeNode>();
        this.sphereNodesWithAtoms = new ArrayList<IAtom>();
        this.nextSphereNodes = new ArrayList<TreeNode>();
        this.HOSECode = new StringBuffer();
    }

    public HOSECodeGenerator() {
        this(0);
    }

    private void ensureIsotopeFactory() throws CDKException {
        if (this.isotopeFac == null) {
            try {
                this.isotopeFac = Isotopes.getInstance();
            }
            catch (IOException e2) {
                throw new CDKException("Could not instantiate the IsotopeFactory: " + e2.getMessage(), e2);
            }
        }
    }

    public List<IAtom>[] getSpheres(IAtomContainer ac, IAtom root2, int noOfSpheres, boolean ringsize) throws CDKException {
        this.ensureIsotopeFactory();
        this.centerCode = "";
        this.atomContainer = ac;
        this.maxSphere = noOfSpheres;
        this.spheres = new List[noOfSpheres + 1];
        this.spheresWithAtoms = new List[noOfSpheres + 1];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(16, false);
        }
        root2.setFlag(16, true);
        this.rootNode = new TreeNode(root2.getSymbol(), null, root2, 0.0, this.atomContainer.getConnectedBondsCount(root2), 0L);
        this.HOSECode = new StringBuffer();
        this.createCenterCode(root2, ac, ringsize);
        this.breadthFirstSearch(root2, false);
        this.createCode();
        this.fillUpSphereDelimiters();
        logger.debug("HOSECodeGenerator -> HOSECode: " + this.HOSECode.toString());
        return this.spheresWithAtoms;
    }

    public String getHOSECode(IAtomContainer ac, IAtom root2, int noOfSpheres) throws CDKException {
        return this.getHOSECode(ac, root2, noOfSpheres, false);
    }

    public String getHOSECode(IAtomContainer ac, IAtom root2, int noOfSpheres, boolean ringsize) throws CDKException {
        this.ensureIsotopeFactory();
        CanonicalLabeler canLabler = new CanonicalLabeler();
        canLabler.canonLabel(ac);
        this.centerCode = "";
        this.atomContainer = ac;
        this.maxSphere = noOfSpheres;
        this.spheres = new List[noOfSpheres + 1];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(16, false);
        }
        root2.setFlag(16, true);
        this.rootNode = new TreeNode(root2.getSymbol(), null, root2, 0.0, this.atomContainer.getConnectedBondsCount(root2), 0L);
        this.HOSECode = new StringBuffer();
        this.createCenterCode(root2, ac, ringsize);
        this.breadthFirstSearch(root2, true);
        this.createCode();
        this.fillUpSphereDelimiters();
        logger.debug("HOSECodeGenerator -> HOSECode: ", this.HOSECode);
        return this.HOSECode.toString();
    }

    private void createCenterCode(IAtom root2, IAtomContainer ac, boolean ringsize) {
        int partnerCount = this.atomContainer.getConnectedBondsCount(root2) + (root2.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : root2.getImplicitHydrogenCount());
        this.centerCode = root2.getSymbol() + "-" + partnerCount + this.createChargeCode(root2) + (ringsize ? this.getRingcode(root2, ac) : "") + ";";
    }

    private String getRingcode(IAtom root2, IAtomContainer ac) {
        int i;
        if (ac != this.acold) {
            this.soar = Cycles.sssr(ac).toRingSet();
        }
        boolean[] bool = new boolean[1000];
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.soar.getRings(root2).getAtomContainerCount(); ++i) {
            if (this.soar.getRings(root2).getAtomContainer(i).getAtomCount() >= bool.length) continue;
            bool[this.soar.getRings((IAtom)root2).getAtomContainer((int)i).getAtomCount()] = true;
        }
        for (i = 0; i < bool.length; ++i) {
            if (!bool[i]) continue;
            sb.append(i);
        }
        if (sb.toString().isEmpty()) {
            return "";
        }
        return "-" + sb;
    }

    private String createChargeCode(IAtom atom) {
        StringBuilder tempCode = new StringBuilder();
        if (atom != null) {
            Integer formalCharge = atom.getFormalCharge();
            if (formalCharge == CDKConstants.UNSET) {
                formalCharge = 0;
            }
            if (formalCharge != 0) {
                if (Math.abs(formalCharge) == 1) {
                    if (formalCharge < 0) {
                        tempCode.append('-');
                    } else {
                        tempCode.append('+');
                    }
                } else {
                    tempCode.append('\'');
                    if (formalCharge > 0) {
                        tempCode.append('+');
                    }
                    tempCode.append(formalCharge).append('\'');
                }
            }
        }
        return tempCode.toString();
    }

    private void breadthFirstSearch(IAtom root2, boolean addTreeNode) throws CDKException {
        this.sphere = 0;
        List<IAtom> conAtoms = this.atomContainer.getConnectedAtomsList(root2);
        this.sphereNodes.clear();
        this.sphereNodesWithAtoms.clear();
        for (IAtom conAtom : conAtoms) {
            try {
                IAtom atom = conAtom;
                if (atom.getSymbol().equals("H")) continue;
                IBond bond = this.atomContainer.getBond(root2, atom);
                TreeNode tempNode = bond.getFlag(32) ? new TreeNode(atom.getSymbol(), new TreeNode(root2.getSymbol(), null, root2, 0.0, 0, 0L), atom, 4.0, this.atomContainer.getConnectedBondsCount(atom), 0L) : new TreeNode(atom.getSymbol(), new TreeNode(root2.getSymbol(), null, root2, 0.0, 0, 0L), atom, bond.getOrder().numeric().intValue(), this.atomContainer.getConnectedBondsCount(atom), 0L);
                this.sphereNodes.add(tempNode);
                if (!addTreeNode) {
                    this.sphereNodesWithAtoms.add(atom);
                }
                atom.setFlag(16, true);
            }
            catch (Exception exc) {
                throw new CDKException("Error in HOSECodeGenerator->breadthFirstSearch.", exc);
            }
        }
        this.sphereNodes.sort(new TreeNodeComparator());
        this.nextSphere(this.sphereNodes);
    }

    private void nextSphere(List<TreeNode> sphereNodes) throws CDKException {
        this.spheres[this.sphere] = sphereNodes;
        if (this.spheresWithAtoms != null) {
            this.spheresWithAtoms[this.sphere] = this.sphereNodesWithAtoms;
        }
        this.nextSphereNodes = new ArrayList<TreeNode>();
        Iterator<TreeNode> iterator = sphereNodes.iterator();
        while (iterator.hasNext()) {
            IAtom node;
            TreeNode sphereNode;
            TreeNode treeNode = sphereNode = iterator.next();
            if ("&;#:,".contains(treeNode.symbol) || (node = treeNode.atom).getSymbol().equals("H")) continue;
            List<IAtom> conAtoms = this.atomContainer.getConnectedAtomsList(node);
            if (conAtoms.size() == 1) {
                this.nextSphereNodes.add(new TreeNode(",", treeNode, null, 0.0, 0, treeNode.score));
                continue;
            }
            for (IAtom conAtom : conAtoms) {
                IAtom toNode = conAtom;
                if (toNode.equals(treeNode.source.atom)) continue;
                IBond bond = this.atomContainer.getBond(node, toNode);
                if (bond.getFlag(32)) {
                    this.nextSphereNodes.add(new TreeNode(toNode.getSymbol(), treeNode, toNode, 4.0, this.atomContainer.getConnectedBondsCount(toNode), treeNode.score));
                    continue;
                }
                this.nextSphereNodes.add(new TreeNode(toNode.getSymbol(), treeNode, toNode, bond.getOrder().numeric().intValue(), this.atomContainer.getConnectedBondsCount(toNode), treeNode.score));
            }
        }
        this.nextSphereNodes.sort(new TreeNodeComparator());
        if (this.sphere < this.maxSphere) {
            ++this.sphere;
            this.nextSphere(this.nextSphereNodes);
        }
    }

    public String makeBremserCompliant(String code) {
        int sepIndex = code.indexOf(59);
        if (sepIndex >= 0) {
            code = code.substring(sepIndex + 1);
        }
        return code;
    }

    private void createCode() throws CDKException {
        int f;
        for (f = 0; f < this.atomContainer.getAtomCount(); ++f) {
            this.atomContainer.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < this.maxSphere; ++f) {
            for (TreeNode tn : this.spheres[this.maxSphere - f]) {
                if (tn.source == null) continue;
                tn.source.ranking += tn.degree;
            }
        }
        if ((this.flags & 1) != 0) {
            for (f = 0; f < this.maxSphere; ++f) {
                this.calculateNodeScores(this.spheres[f]);
            }
            for (f = 0; f < this.maxSphere; ++f) {
                for (TreeNode tn : this.spheres[f]) {
                    tn.score += (long)tn.ranking;
                }
            }
            for (f = 0; f < this.maxSphere; ++f) {
                for (TreeNode tn : this.spheres[f]) {
                    StringBuilder localscore = new StringBuilder(tn.score + "");
                    while (localscore.length() < 6) {
                        localscore.insert(0, "0");
                    }
                    tn.stringscore = tn.source.stringscore + "" + localscore;
                }
                this.sortNodesByScore(this.spheres[f]);
            }
        } else {
            for (f = 0; f < this.maxSphere; ++f) {
                this.calculateNodeScores(this.spheres[f]);
                for (TreeNode tn : this.spheres[f]) {
                    tn.score += (long)tn.ranking;
                }
                this.sortNodesByScore(this.spheres[f]);
            }
        }
        this.HOSECode.append(this.centerCode);
        for (f = 0; f < this.maxSphere; ++f) {
            this.sphere = f + 1;
            String s = this.getSphereCode(this.spheres[f]);
            this.HOSECode.append(s);
        }
    }

    private String getSphereCode(List<TreeNode> sphereNodes) throws CDKException {
        if (sphereNodes == null || sphereNodes.size() < 1) {
            return this.sphereDelimiters[this.sphere - 1];
        }
        StringBuilder code = new StringBuilder();
        IAtom branch = sphereNodes.get((int)0).source.atom;
        Iterator<TreeNode> iterator = sphereNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode sphereNode;
            TreeNode treeNode = sphereNode = iterator.next();
            StringBuilder tempCode = new StringBuilder();
            if (!treeNode.source.stopper && !treeNode.source.atom.equals(branch)) {
                branch = treeNode.source.atom;
                code.append(',');
            }
            if (!treeNode.source.stopper && treeNode.source.atom.equals(branch)) {
                if (!(treeNode.bondType <= 4.0)) {
                    throw new CDKException("Unknown bond type");
                }
                tempCode.append(this.bondSymbols[(int)treeNode.bondType]);
                if (treeNode.atom != null && !treeNode.atom.getFlag(16)) {
                    tempCode.append(this.getElementSymbol(treeNode.symbol));
                } else if (treeNode.atom != null && treeNode.atom.getFlag(16)) {
                    tempCode.append('&');
                    treeNode.stopper = true;
                }
                code.append((CharSequence)tempCode).append(this.createChargeCode(treeNode.atom));
                treeNode.hSymbol = tempCode.toString();
            }
            if (treeNode.atom != null) {
                treeNode.atom.setFlag(16, true);
            }
            if (!treeNode.source.stopper) continue;
            treeNode.stopper = true;
        }
        code.append(this.sphereDelimiters[this.sphere - 1]);
        return code.toString();
    }

    private double getElementRank(String symbol) {
        for (int f = 0; f < rankedSymbols.length; ++f) {
            if (!rankedSymbols[f].equals(symbol)) continue;
            return symbolRankings[f];
        }
        IIsotope isotope = this.isotopeFac.getMajorIsotope(symbol);
        if (isotope.getMassNumber() != null) {
            return 800000.0 - (double)isotope.getMassNumber().intValue();
        }
        return 800000.0;
    }

    private String getElementSymbol(String sym2) {
        if (sym2.equals("Si")) {
            return "Q";
        }
        if (sym2.equals("Cl")) {
            return "X";
        }
        if (sym2.equals("Br")) {
            return "Y";
        }
        if (sym2.equals(",")) {
            return "";
        }
        return sym2;
    }

    private void calculateNodeScores(List<TreeNode> sphereNodes) throws CDKException {
        Iterator<TreeNode> iterator = sphereNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode sphereNode;
            TreeNode treeNode = sphereNode = iterator.next();
            treeNode.score = (long)((double)treeNode.score + this.getElementRank(treeNode.symbol));
            if (treeNode.bondType <= 4.0) {
                treeNode.score += (long)bondRankings[(int)treeNode.bondType];
                continue;
            }
            throw new CDKException("Unknown bond type encountered in HOSECodeGenerator");
        }
    }

    private void sortNodesByScore(List<TreeNode> sphereNodes) {
        if ((this.flags & 1) != 0) {
            sphereNodes.sort((a, b) -> b.stringscore.compareTo(a.stringscore));
        } else {
            sphereNodes.sort((a, b) -> {
                int cmp = Integer.compare(b.source.sortOrder, a.source.sortOrder);
                if (cmp != 0) {
                    return cmp;
                }
                return Long.compare(b.score, a.score);
            });
        }
        for (int i = 0; i < sphereNodes.size(); ++i) {
            sphereNodes.get((int)i).sortOrder = sphereNodes.size() - i;
        }
    }

    private void fillUpSphereDelimiters() {
        logger.debug("Sphere: " + this.sphere);
        for (int f = this.sphere; f < 4; ++f) {
            this.HOSECode.append(this.sphereDelimiters[f]);
        }
    }

    public List<IAtom> getNodesInSphere(int sphereNumber) {
        this.sphereNodes = this.spheres[sphereNumber - 1];
        ArrayList<IAtom> atoms = new ArrayList<IAtom>();
        for (TreeNode sphereNode : this.sphereNodes) {
            atoms.add(sphereNode.atom);
        }
        return atoms;
    }

    class TreeNode {
        String symbol;
        TreeNode source;
        IAtom atom;
        double bondType;
        int degree;
        long score;
        int ranking;
        int sortOrder;
        List<TreeNode> childs;
        String hSymbol = null;
        boolean stopper = false;
        String stringscore = "";

        TreeNode(String symbol, TreeNode source, IAtom atom, double bondType, int degree, long score) {
            this.symbol = symbol;
            this.source = source;
            this.atom = atom;
            this.degree = degree;
            this.score = score;
            this.bondType = bondType;
            this.ranking = 0;
            this.sortOrder = 1;
            this.childs = new ArrayList<TreeNode>();
        }

        public IAtom getAtom() {
            return this.atom;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TreeNode)) {
                return false;
            }
            return this.atom.equals(((TreeNode)o).atom);
        }

        public int hashCode() {
            return Objects.hashCode(this.atom);
        }

        public String toString() {
            String s = "";
            try {
                s = s + (HOSECodeGenerator.this.atomContainer.indexOf(this.atom) + 1);
                s = s + " " + this.hSymbol;
                s = s + "; s=" + this.score;
                s = s + "; r=" + this.ranking;
                s = s + "; d = " + this.degree;
            }
            catch (Exception exc) {
                return exc.toString();
            }
            return s;
        }
    }

    class TreeNodeComparator
    implements Comparator<TreeNode> {
        TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode a, TreeNode b) {
            return this.label(a).compareTo(this.label(b));
        }

        private Long label(TreeNode node) {
            if (node == null) {
                return Long.MIN_VALUE;
            }
            IAtom atom = node.getAtom();
            if (atom == null) {
                return Long.MIN_VALUE;
            }
            Long label = (Long)atom.getProperty("CanonicalLabel");
            if (label == null) {
                return Long.MIN_VALUE;
            }
            return label;
        }
    }
}

