/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

public class ReactionSetManipulator {
    public static int getAtomCount(IReactionSet set) {
        int count = 0;
        for (IReaction iReaction : set.reactions()) {
            count += ReactionManipulator.getAtomCount(iReaction);
        }
        return count;
    }

    public static int getBondCount(IReactionSet set) {
        int count = 0;
        for (IReaction iReaction : set.reactions()) {
            count += ReactionManipulator.getBondCount(iReaction);
        }
        return count;
    }

    public static void removeAtomAndConnectedElectronContainers(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.removeAtomAndConnectedElectronContainers(reaction, atom);
        }
    }

    public static void removeElectronContainer(IReactionSet set, IElectronContainer electrons) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.removeElectronContainer(reaction, electrons);
        }
    }

    public static IAtomContainerSet getAllMolecules(IReactionSet set) {
        IAtomContainerSet moleculeSet = set.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (IReaction reaction : set.reactions()) {
            IAtomContainerSet molecules = ReactionManipulator.getAllMolecules(reaction);
            for (IAtomContainer ac : molecules.atomContainers()) {
                boolean contain = false;
                for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
                    if (!atomContainer.equals(ac)) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                moleculeSet.addAtomContainer(ac);
            }
        }
        return moleculeSet;
    }

    public static List<String> getAllIDs(IReactionSet set) {
        ArrayList<String> IDlist = new ArrayList<String>();
        if (set.getID() != null) {
            IDlist.add(set.getID());
        }
        for (IReaction reaction : set.reactions()) {
            IDlist.addAll(ReactionManipulator.getAllIDs(reaction));
        }
        return IDlist;
    }

    public static List<IAtomContainer> getAllAtomContainers(IReactionSet set) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionSetManipulator.getAllMolecules(set));
    }

    public static IReaction getRelevantReaction(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container2 = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container2 == null) continue;
            return reaction;
        }
        return null;
    }

    public static IReaction getRelevantReaction(IReactionSet set, IBond bond) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container2 = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container2 == null) continue;
            return reaction;
        }
        return null;
    }

    public static IReactionSet getRelevantReactions(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IReactionSet reactSetProd = ReactionSetManipulator.getRelevantReactionsAsProduct(reactSet, molecule);
        for (IReaction reaction : reactSetProd.reactions()) {
            newReactSet.addReaction(reaction);
        }
        IReactionSet reactSetReact = ReactionSetManipulator.getRelevantReactionsAsReactant(reactSet, molecule);
        for (IReaction reaction : reactSetReact.reactions()) {
            newReactSet.addReaction(reaction);
        }
        return newReactSet;
    }

    public static IReactionSet getRelevantReactionsAsReactant(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IReaction reaction : reactSet.reactions()) {
            for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
                if (!atomContainer.equals(molecule)) continue;
                newReactSet.addReaction(reaction);
            }
        }
        return newReactSet;
    }

    public static IReactionSet getRelevantReactionsAsProduct(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IReaction reaction : reactSet.reactions()) {
            for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
                if (!atomContainer.equals(molecule)) continue;
                newReactSet.addReaction(reaction);
            }
        }
        return newReactSet;
    }

    public static IAtomContainer getRelevantAtomContainer(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container2 = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container2 == null) continue;
            return container2;
        }
        return null;
    }

    public static IAtomContainer getRelevantAtomContainer(IReactionSet set, IBond bond) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container2 = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container2 == null) continue;
            return container2;
        }
        return null;
    }

    public static void setAtomProperties(IReactionSet set, Object propKey, Object propVal) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.setAtomProperties(reaction, propKey, propVal);
        }
    }

    public static List<IChemObject> getAllChemObjects(IReactionSet set) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add(set);
        for (IReaction reaction : set.reactions()) {
            list.addAll(ReactionManipulator.getAllChemObjects(reaction));
        }
        return list;
    }

    public static IReaction getReactionByAtomContainerID(IReactionSet reactionSet, String id) {
        for (IReaction reaction : reactionSet.reactions()) {
            if (!AtomContainerSetManipulator.containsByID(reaction.getProducts(), id)) continue;
            return reaction;
        }
        for (IReaction reaction : reactionSet.reactions()) {
            if (!AtomContainerSetManipulator.containsByID(reaction.getReactants(), id)) continue;
            return reaction;
        }
        return null;
    }

    public static IReaction getReactionByReactionID(IReactionSet reactionSet, String id) {
        Iterable<IReaction> reactionIter = reactionSet.reactions();
        for (IReaction reaction : reactionIter) {
            if (reaction.getID() == null || !reaction.getID().equals(id)) continue;
            return reaction;
        }
        return null;
    }
}

