/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.BooleanArraySTAttribute;
import org.xmlcml.cml.base.BooleanSTAttribute;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.DoubleArraySTAttribute;
import org.xmlcml.cml.base.DoubleSTAttribute;
import org.xmlcml.cml.base.IntArraySTAttribute;
import org.xmlcml.cml.base.IntSTAttribute;
import org.xmlcml.cml.base.SchemaManager;
import org.xmlcml.cml.base.StringArraySTAttribute;
import org.xmlcml.cml.base.StringSTAttribute;

public class AttributeFactory
implements CMLConstants {
    static final Logger LOG = Logger.getLogger(AttributeFactory.class);
    public static final AttributeFactory attributeFactory = new AttributeFactory();
    private Map<String, Element> attributeGroupElementMap;
    private Map<String, CMLAttribute> attributeGroupNameAttributeMap;
    private Map<String, Map<String, String>> elementSynonymMap;
    private SchemaManager schemaManager;

    private AttributeFactory() {
    }

    void init() {
        this.elementSynonymMap = new HashMap<String, Map<String, String>>();
        this.schemaManager = new SchemaManager();
        this.schemaManager.readAndCreateIndexesFromSchemaFiles();
        attributeFactory.setSchemaManager(this.schemaManager);
        this.makeSynonymMap();
    }

    public static AttributeFactory createAttributeFactory(String className) throws Exception {
        return (AttributeFactory)Class.forName(className).newInstance();
    }

    public CMLAttribute getAttribute(String name) {
        return this.attributeGroupNameAttributeMap.get(name);
    }

    private void makeSynonymMap() {
        this.attributeGroupElementMap = new HashMap<String, Element>();
        try {
            Map<String, CMLAttribute> attributeGroupMap = this.schemaManager.getAttributeGenerator().getAttributeGroupMap();
            for (String attributeGroupName : attributeGroupMap.keySet()) {
                CMLAttribute specialAttribute = AttributeFactory.createSpecialAttribute(attributeGroupName);
                if (specialAttribute == null) continue;
                attributeGroupMap.put(attributeGroupName, specialAttribute);
            }
            Element attributeTop = CMLUtil.getXMLResource("org/xmlcml/cml/base/attributes.xsd").getRootElement();
            List<Node> attributeGroups = CMLUtil.getQueryNodes(attributeTop, "./xsd:attributeGroup", XPATH_XSD);
            this.attributeGroupNameAttributeMap = new HashMap<String, CMLAttribute>();
            for (Node node : attributeGroups) {
                Element xsdAttribute = (Element)node;
                String attributeGroupName = xsdAttribute.getAttributeValue("name");
                this.attributeGroupElementMap.put(attributeGroupName, xsdAttribute);
                CMLAttribute att = this.schemaManager.getAttributeGenerator().createAttribute(attributeGroupName);
                this.attributeGroupNameAttributeMap.put(attributeGroupName, att);
            }
            Element elementTop = CMLUtil.getXMLResource("org/xmlcml/cml/base/elements.xsd").getRootElement();
            List<Node> elements = CMLUtil.getQueryNodes(elementTop, "./xsd:element", XPATH_XSD);
            for (Node node : elements) {
                Element xsdElement = (Element)node;
                String elementName = xsdElement.getAttributeValue("name");
                HashMap<String, String> synonymMap = new HashMap<String, String>();
                this.elementSynonymMap.put(elementName, synonymMap);
                List<Node> attributeGroupsx = CMLUtil.getQueryNodes(xsdElement, ".//xsd:attributeGroup", XPATH_XSD);
                for (Node nodex : attributeGroupsx) {
                    String ref = ((Element)nodex).getAttributeValue("ref");
                    Element attributeGroupx = this.attributeGroupElementMap.get(ref);
                    List<Node> attNodes = CMLUtil.getQueryNodes(attributeGroupx, "./xsd:attribute", XPATH_XSD);
                    String attributeName = ((Element)attNodes.get(0)).getAttributeValue("name");
                    synonymMap.put(attributeName, ref);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException("Cannot parse elements/attributes: " + e2);
        }
    }

    public static CMLAttribute createSpecialAttribute(String name) {
        CMLAttribute attribute = null;
        try {
            String attClassName = "org.xmlcml.cml.attribute." + CMLUtil.capitalize(name) + "Attribute";
            Class<?> attClass = Class.forName(attClassName);
            if (attClass != null) {
                attribute = (CMLAttribute)attClass.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attribute;
    }

    String getAttributeGroupName(String attributeName, String elementName) {
        String attributeGroupName = null;
        Map<String, String> attNameToAttGroupNameMap = this.elementSynonymMap.get(elementName);
        if (attNameToAttGroupNameMap != null) {
            attributeGroupName = attNameToAttGroupNameMap.get(attributeName);
        } else {
            System.err.println("Cannot find synonym for: " + elementName);
        }
        return attributeGroupName;
    }

    public CMLAttribute getAttribute(String attributeName, String elementName) {
        String attributeGroupName = this.getAttributeGroupName(attributeName, elementName);
        if (attributeGroupName == null) {
            throw new RuntimeException("Cannot find attribute group for " + elementName + "@" + attributeName);
        }
        return this.attributeGroupNameAttributeMap.get(attributeGroupName);
    }

    public CMLAttribute getAttributeByGroupName(String attributeGroupName) {
        Map<String, CMLAttribute> attributeGroupMap = this.schemaManager.getAttributeGenerator().getAttributeGroupMap();
        CMLAttribute attribute = attributeGroupMap.get(attributeGroupName);
        if (attribute == null) {
            throw new RuntimeException("Cannot find attributeGroup: " + attributeGroupName);
        }
        return attribute;
    }

    public CMLAttribute createCMLAttribute(String attributeName, CMLElement element) {
        if (attributeName.equals("_xmlContent")) {
            throw new RuntimeException("Cannot process _xmlContent");
        }
        return attributeFactory.getAttribute(attributeName, element.getLocalName());
    }

    public static CMLAttribute createCMLAttribute(String name, CMLType type) {
        CMLAttribute newAtt = AttributeFactory.createSpecialAttribute(name);
        String typeS = type.getJavaType();
        if (newAtt == null) {
            if ("xsd:boolean".equals(typeS) && !type.getIsList()) {
                newAtt = new BooleanSTAttribute(name);
            } else if ("xsd:boolean".equals(typeS) && type.getIsList()) {
                newAtt = new BooleanArraySTAttribute(name);
            } else if ("xsd:double".equals(typeS) && !type.getIsList()) {
                newAtt = new DoubleSTAttribute(name);
            } else if ("xsd:double".equals(typeS) && type.getIsList()) {
                newAtt = new DoubleArraySTAttribute(name);
            } else if ("xsd:integer".equals(typeS) && !type.getIsList()) {
                newAtt = new IntSTAttribute(name);
            } else if ("xsd:integer".equals(typeS) && type.getIsList()) {
                newAtt = new IntArraySTAttribute(name);
            } else if ("xsd:string".equals(typeS) && !type.getIsList()) {
                newAtt = new StringSTAttribute(name);
            } else if ("xsd:string".equals(typeS) && type.getIsList()) {
                newAtt = new StringArraySTAttribute(name);
            } else {
                LOG.error("unknown attribute type " + type);
            }
        }
        return newAtt;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public String getValue() {
        return null;
    }

    static {
        attributeFactory.init();
    }
}

