/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.ParentNode;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.DoubleArraySTAttribute;
import org.xmlcml.cml.base.StringArraySTAttribute;
import org.xmlcml.cml.element.AbstractAtomArray;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondArray;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Util;

public class CMLAtomArray
extends AbstractAtomArray {
    private static Logger LOG = Logger.getLogger(CMLAtomArray.class);
    static final Logger logger = Logger.getLogger(CMLAtomArray.class);
    public static final String NS = "cml:atomArray";
    Map<String, CMLAtom> atomMap;

    public CMLAtomArray() {
        this.init();
    }

    void init() {
        this.atomMap = new HashMap<String, CMLAtom>();
    }

    public CMLAtomArray(CMLAtomArray old) {
        super(old);
        this.init();
    }

    @Override
    public Element copy() {
        return new CMLAtomArray(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CMLElement makeElementInContext(Element parent) {
        if (parent == null) {
            throw new RuntimeException("atomArray must have parent");
        }
        if (parent.getLocalName().equals("molecule")) {
            if (parent.getChildElements("atomArray", "http://www.xml-cml.org/schema").size() <= 0) return new CMLAtomArray();
            throw new RuntimeException("molecule/atomArray must have no atomArray siblings");
        }
        if (!parent.getLocalName().equals("formula")) throw new RuntimeException("atomArray cannot have parent: " + parent.getLocalName());
        CMLFormula formula = (CMLFormula)parent;
        CMLElements<CMLAtomArray> atomArrays = formula.getAtomArrayElements();
        if (atomArrays.size() <= 0) return new CMLAtomArray();
        if (!formula.isProcessedConcise() || atomArrays.size() != 1) throw new RuntimeException("formula/atomArray must have no atomArray siblings");
        formula.removeChild(atomArrays.get(0));
        return new CMLAtomArray();
    }

    @Override
    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
        this.indexAtoms();
    }

    @Override
    public void setAtomID(String[] atomIDs) throws RuntimeException {
        if (atomIDs == null) {
            throw new RuntimeException("null atomIDs");
        }
        if (this.getAtoms().size() > 0) {
            throw new RuntimeException("Cannot use atomID with existing children");
        }
        for (String s : atomIDs) {
            CMLAtom atom = new CMLAtom(s);
            this.addAtom(atom);
        }
    }

    public CMLAtom appendChild(CMLAtom atom) {
        CMLAtom atom0 = this.addAtom(atom);
        return atom0;
    }

    public int size() {
        return this.getAtomElements().size();
    }

    public void sort(CMLFormula.Sort sort) {
        int i;
        String[] elems = this.getElementType();
        double[] counts = this.getCount();
        int nelem = elems.length;
        Object[] sortS = new String[elems.length];
        for (i = 0; i < nelem; ++i) {
            sortS[i] = elems[i] + " " + counts[i];
        }
        Arrays.sort(sortS);
        if (!sort.equals((Object)CMLFormula.Sort.ALPHABETIC_ELEMENTS) && sort.equals((Object)CMLFormula.Sort.CHFIRST)) {
            int i2;
            String[] temp = new String[nelem];
            int c = 0;
            for (i2 = 0; i2 < nelem; ++i2) {
                if (!((String)sortS[i2]).startsWith("C ")) continue;
                temp[c++] = sortS[i2];
            }
            for (i2 = 0; i2 < nelem; ++i2) {
                if (!((String)sortS[i2]).startsWith("H ")) continue;
                temp[c++] = sortS[i2];
            }
            for (i2 = 0; i2 < nelem; ++i2) {
                if (((String)sortS[i2]).startsWith("C ") || ((String)sortS[i2]).startsWith("H ")) continue;
                temp[c++] = sortS[i2];
            }
            System.arraycopy(temp, 0, sortS, 0, nelem);
        }
        for (i = 0; i < nelem; ++i) {
            String[] ss = ((String)sortS[i]).split(" ");
            elems[i] = ss[0];
            counts[i] = new Double(ss[1]);
        }
        this.setElementTypeAndCount(elems, counts);
    }

    public String generateConcise(int formalCharge) {
        String concise = null;
        String[] elems = this.getElementType();
        double[] counts = this.getCount();
        if (elems == null && counts == null) {
            elems = new String[]{};
            counts = new double[]{};
        } else {
            if (elems == null || counts == null) {
                throw new RuntimeException("atomArray has elements/counts " + elems + "/" + counts);
            }
            if (counts.length != elems.length) {
                throw new RuntimeException("atomArray has inconsistent counts/elems " + counts.length + "/" + elems.length);
            }
        }
        int nelem = elems.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nelem; ++i) {
            sb.append(" ");
            sb.append(elems[i]);
            sb.append(" ");
            sb.append(Util.trim(Util.format(counts[i], 4)));
        }
        if (formalCharge != 0) {
            sb.append(" ");
            sb.append(formalCharge);
        }
        concise = sb.length() == 0 ? "" : sb.substring(1);
        return concise;
    }

    public CMLAtom addAtom(CMLAtom atom) {
        int count = this.getChildCount();
        return this.insertAtom(atom, count);
    }

    public CMLAtom insertAtom(CMLAtom atom, int pos) {
        String id = atom.getId();
        if (id == null) {
            throw new RuntimeException("Atom must have id");
        }
        ParentNode parent = atom.getParent();
        if (parent != null && parent.equals(this)) {
            throw new RuntimeException("atom already added");
        }
        if (this.atomMap != null && this.atomMap.containsKey(id)) {
            throw new RuntimeException("atom already in array: " + id);
        }
        this.indexAtom(atom);
        this.insertChild(atom, pos);
        return atom;
    }

    void indexAtom(CMLAtom atom) {
        if (this.atomMap == null) {
            this.atomMap = new HashMap<String, CMLAtom>();
        }
        this.atomMap.put(atom.getId(), atom);
    }

    public CMLAtom removeChild(CMLAtom atom) {
        return this.removeAtom(atom);
    }

    public CMLAtom removeAtom(CMLAtom atom) {
        CMLAtom deletedAtom = null;
        if (this.equals(atom.getParent())) {
            super.removeChild(atom);
            if (this.atomMap != null) {
                this.atomMap.remove(atom.getId());
            }
            this.deleteLigandBonds(atom);
            deletedAtom = atom;
        }
        return deletedAtom;
    }

    List<CMLBond> deleteLigandBonds(CMLAtom atom) {
        CMLBondArray bondArray = this.getBondArray();
        List<CMLBond> ligandBonds = atom.getLigandBonds();
        ArrayList<CMLBond> ligandBonds1 = new ArrayList<CMLBond>();
        for (CMLBond bond : ligandBonds) {
            ligandBonds1.add(bond);
        }
        for (CMLBond bond : ligandBonds1) {
            bondArray.removeBond(bond);
        }
        return ligandBonds;
    }

    void deleteLigandBonds() {
        List<CMLAtom> atomList = this.getAtoms();
        for (CMLAtom atom : atomList) {
            this.deleteLigandBonds(atom);
        }
    }

    void clearLigandInfo() {
        List<CMLAtom> atomList = this.getAtoms();
        for (CMLAtom atom : atomList) {
            atom.clearLigandInfo();
        }
    }

    void debugLigands() {
        List<CMLAtom> atomList = this.getAtoms();
        for (CMLAtom atom : atomList) {
            Util.println("ATOM: " + atom.getString());
            for (CMLAtom ligand : atom.getLigandAtoms()) {
                Util.println("  LIG: " + ligand.getString());
            }
        }
    }

    CMLBondArray getBondArray() {
        CMLBondArray bondArray = null;
        CMLMolecule molecule = this.getMolecule();
        if (molecule != null) {
            CMLElements<CMLBondArray> bondArrays = molecule.getBondArrayElements();
            bondArray = bondArrays.size() == 0 ? null : bondArrays.get(0);
        }
        return bondArray;
    }

    public CMLMolecule getMolecule() {
        CMLMolecule molecule = null;
        ParentNode node = this.getParent();
        if (node != null && node instanceof CMLMolecule) {
            molecule = (CMLMolecule)node;
        }
        return molecule;
    }

    @Override
    public void detach() {
        ParentNode parent = this.getParent();
        if (parent != null) {
            if (parent instanceof CMLMolecule) {
                CMLMolecule molecule = (CMLMolecule)parent;
                molecule.removeAtomArray();
            } else {
                super.detach();
            }
        }
    }

    void indexAtoms() {
        List<CMLAtom> atoms = this.getAtoms();
        this.getAtomMap();
        this.atomMap.clear();
        for (CMLAtom atom : atoms) {
            String id = atom.getId();
            if (this.atomMap.containsKey(id)) {
                throw new RuntimeException("Index atom: duplicate atom: " + id);
            }
            this.atomMap.put(id, atom);
        }
    }

    public Map<String, CMLAtom> getAtomMap() {
        return this.atomMap;
    }

    public List<CMLAtom> getAtoms() {
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>();
        CMLElements<CMLAtom> atoms = this.getAtomElements();
        for (CMLAtom atom : atoms) {
            atomList.add(atom);
        }
        return atomList;
    }

    public CMLAtom getAtomById(String id) {
        return this.atomMap == null ? null : this.atomMap.get(id);
    }

    private List<CMLAtom> getAtoms(int length, String typeName) {
        ParentNode parent = this.getParent();
        if (parent == null) {
            throw new RuntimeException("null parent for atomArray");
        }
        if (parent instanceof CMLFormula) {
            throw new RuntimeException("don't use this for formula");
        }
        List<CMLAtom> atomList = this.getAtoms();
        if (atomList.size() != length) {
            throw new RuntimeException("inconsistent atom count (" + atomList.size() + ") and " + typeName + " (" + length + ")");
        }
        return atomList;
    }

    public void setElementTypeAndCount(String[] elem, double[] count) throws RuntimeException {
        if (elem.length > 0 && count.length > 0) {
            StringArraySTAttribute att = new StringArraySTAttribute("elementType");
            att.setCMLValue(elem);
            this.addAttribute(att);
            DoubleArraySTAttribute datt = new DoubleArraySTAttribute("count");
            datt.setCMLValue(count);
            this.addAttribute(datt);
        }
    }

    @Override
    public void setElementType(String[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null elementType");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "elementType");
        LOG.debug("ATOM " + this.getAtoms().size());
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setElementType(value[i++]);
        }
    }

    @Override
    public void setCount(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null count");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "count");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setCount(value[i++]);
        }
    }

    public void setFormalCharge(String[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null formalCharge");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "formalCharge");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setFormalCharge(Integer.parseInt(value[i++]));
        }
    }

    public void setHydrogenCount(String[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null hydrogenCount");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "hydrogenCount");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setHydrogenCount(Integer.parseInt(value[i++]));
        }
    }

    public void setOccupancy(String[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null occupancy");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "occupancy");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setOccupancy(new Double(value[i++]));
        }
    }

    @Override
    public void setX2(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null x2: " + this.getId());
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "x2");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setX2(value[i++]);
        }
    }

    @Override
    public void setY2(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null y2");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "y2");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setY2(value[i++]);
        }
    }

    @Override
    public void setX3(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null x3");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "x3");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setX3(value[i++]);
        }
    }

    @Override
    public void setY3(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null y3");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "y3");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setY3(value[i++]);
        }
    }

    @Override
    public void setZ3(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null z3");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "z3");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setZ3(value[i++]);
        }
    }

    @Override
    public void setXFract(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null xFract");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "xFract");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setXFract(value[i++]);
        }
    }

    @Override
    public void setYFract(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null yFract");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "yFract");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setYFract(value[i++]);
        }
    }

    @Override
    public void setZFract(double[] value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null zFract");
        }
        List<CMLAtom> atomList = this.getAtoms(value.length, "zFract");
        int i = 0;
        for (CMLAtom atom : atomList) {
            atom.setZFract(value[i++]);
        }
    }
}

