/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.testutils;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLAtomSet;
import org.xmlcml.cml.element.CMLBondSet;
import org.xmlcml.cml.element.CMLCellParameter;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLLatticeVector;
import org.xmlcml.cml.element.CMLLine3;
import org.xmlcml.cml.element.CMLMatrix;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLPlane3;
import org.xmlcml.cml.element.CMLPoint3;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.cml.testutils.CMLXOMTestUtils;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Vector3;

public class CMLAssert {
    private static final Logger LOG = Logger.getLogger(CMLAssert.class);
    public static final String TOOLS_RESOURCE = "org/xmlcml/cml/tools";
    public static final String TOOLS_EXAMPLES = "org/xmlcml/cml/tools/examples";
    public static final String CRYSTAL_EXAMPLES = "org/xmlcml/cml/tools/examples/cryst";

    public static void assertEquals(String message, String[] expectedAtomIds, CMLAtomSet atomSet) {
        String[] fss;
        Assert.assertEquals((String)(message + "; unequal sizes; expected " + expectedAtomIds.length + ", found: " + atomSet.size()), (long)expectedAtomIds.length, (long)atomSet.size());
        HashSet<String> expectedSet = new HashSet<String>();
        for (String es : expectedAtomIds) {
            expectedSet.add(es);
        }
        HashSet<String> foundSet = new HashSet<String>();
        for (String fs : fss = atomSet.getAtomIDs()) {
            foundSet.add(fs);
        }
        Assert.assertTrue((String)"compare atom sets", (boolean)expectedSet.equals(foundSet));
    }

    public static void alwaysFail(String message) {
        Assert.fail((String)("should always throw " + message));
    }

    public static void assertEquals(String msg, CMLArray test, CMLArray expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        if ((test.getDataType() == null || test.getDataType().equals("xsd:string")) && (expected.getDataType() == null || expected.getDataType().equals("xsd:string"))) {
            Assert.assertEquals((String)msg, (Object[])test.getStrings(), (Object[])expected.getStrings());
        } else if (test.getDataType().equals("xsd:double") && expected.getDataType().equals("xsd:double")) {
            CMLXOMTestUtils.assertEquals(msg, test.getDoubles(), expected.getDoubles(), epsilon);
        } else if (test.getDataType().equals("xsd:integer") && expected.getDataType().equals("xsd:integer")) {
            Assert.assertEquals((String)msg, (Object)test.getInts(), (Object)expected.getInts());
        } else {
            Assert.fail((String)("inconsistent dataTypes" + test.getDataType() + " / " + expected.getDataType()));
        }
    }

    public static void assertEquals(String msg, double[] test, CMLArray expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        if (!expected.getDataType().equals("xsd:double")) {
            Assert.fail((String)"expected should be double");
        }
        CMLXOMTestUtils.assertEquals(msg, test, expected.getDoubles(), epsilon);
    }

    public static void assertEquals(String msg, int[] test, CMLArray expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        if (!expected.getDataType().equals("xsd:integer")) {
            Assert.fail((String)"expected should be int");
        }
        Assert.assertEquals((String)msg, (Object)test, (Object)expected.getInts());
    }

    public static void assertEquals(String msg, String[] test, CMLArray expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        if (expected.getDataType() != null && !expected.getDataType().equals("xsd:string")) {
            Assert.fail((String)"expected should be String");
        }
        Assert.assertEquals((String)msg, (Object[])test, (Object[])expected.getStrings());
    }

    public static void assertEqualsConcise(String message, CMLFormula formula1, CMLFormula formula2, double eps) {
        if (formula1 == null) {
            Assert.fail((String)CMLXOMTestUtils.getAssertFormat(message, "formula", "null"));
        }
        if (formula2 == null) {
            Assert.fail((String)CMLXOMTestUtils.getAssertFormat(message, "formula", "null"));
        }
        Assert.assertEquals((String)"equal concise", (Object)true, (Object)formula1.equals(formula2, eps));
    }

    public static void assertEqualsCanonically(CMLMolecule mol, String filename) {
        CMLMolecule mol1 = null;
        try {
            mol1 = (CMLMolecule)new CMLBuilder().build(new File(filename)).getRootElement();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        CMLAssert.assertEqualsCanonically(mol, mol1);
    }

    public static void assertEqualsCanonically(CMLMolecule mol, CMLMolecule mol1) {
        mol = new CMLMolecule(mol);
        CMLUtil.removeWhitespaceNodes(mol);
        mol1 = new CMLMolecule(mol1);
        CMLUtil.removeWhitespaceNodes(mol1);
        String molS = mol.getCanonicalString();
        String mol1S = mol1.getCanonicalString();
        Assert.assertEquals((String)"MOLECUL equality: ", (Object)molS, (Object)mol1S);
        CMLXOMTestUtils.assertEqualsCanonically("molecule equality", mol, mol1);
    }

    public static void assertEquals(String message, String[] expectedBondIds, CMLBondSet bondSet) {
        Assert.assertEquals((String)(message + "; unequal sizes; expected " + expectedBondIds.length + ", found: " + bondSet.size()), (long)expectedBondIds.length, (long)bondSet.size());
        HashSet<String> expectedSet = new HashSet<String>();
        for (String es : expectedBondIds) {
            expectedSet.add(es);
        }
        HashSet<String> foundSet = new HashSet<String>();
        List<String> fss = bondSet.getBondIDs();
        for (String fs : fss) {
            foundSet.add(fs);
        }
        Assert.assertTrue((String)"compare atom sets", (boolean)expectedSet.equals(foundSet));
    }

    public static void assertEquals(String msg, CMLCellParameter test, CMLCellParameter expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getXMLContent(), expected.getXMLContent(), epsilon);
    }

    public static void assertEquals(String msg, String type, double[] test, CMLCellParameter expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("type should not be null (" + msg + ")"), (Object)type);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertNotNull((String)("expected should not have null type (" + msg + ")"), (Object)expected.getType());
        Assert.assertEquals((String)"types must be equal", (long)3L, (long)test.length);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getXMLContent(), epsilon);
    }

    public static void assertEquals(String msg, CMLLatticeVector test, CMLLatticeVector expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getXMLContent(), expected.getXMLContent(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, CMLLatticeVector expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getXMLContent(), epsilon);
    }

    public static void assertEquals(String msg, CMLLine3 test, CMLLine3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getEuclidLine3(), expected.getEuclidLine3(), epsilon);
    }

    public static void assertEquals(String msg, CMLPoint3 testPoint, CMLVector3 testVector, CMLLine3 expected, double epsilon) {
        Assert.assertNotNull((String)("testVector should not be null (" + msg + ")"), (Object)testVector);
        Assert.assertNotNull((String)("testPoint should not be null (" + msg + ")"), (Object)testPoint);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, testVector.getEuclidVector3(), new Vector3(expected.getVector3()), epsilon);
        CMLXOMTestUtils.assertEquals(msg, testPoint.getEuclidPoint3(), new Point3(expected.getPoint3()), epsilon);
    }

    public static void assertEquals(String msg, CMLMatrix test, CMLMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        if (test.getEuclidRealMatrix() != null) {
            CMLXOMTestUtils.assertEquals(msg, test.getEuclidRealMatrix(), expected.getEuclidRealMatrix(), epsilon);
        } else if (test.getEuclidIntMatrix() != null) {
            Assert.assertEquals((String)msg, (Object)test.getEuclidIntMatrix(), (Object)expected.getEuclidIntMatrix());
        } else {
            Assert.fail((String)("both matrices must be either real or int" + test));
        }
    }

    public static void assertEquals(String msg, int rows, int cols, double[] test, CMLMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"rows ", (long)rows, (long)expected.getRows());
        Assert.assertEquals((String)"columns ", (long)cols, (long)expected.getColumns());
        CMLXOMTestUtils.assertEquals(msg, rows, cols, test, expected.getEuclidRealMatrix(), epsilon);
    }

    public static void assertEquals(String msg, int rows, int cols, int[] test, CMLMatrix expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"rows ", (long)rows, (long)expected.getRows());
        Assert.assertEquals((String)"columns ", (long)cols, (long)expected.getColumns());
        CMLXOMTestUtils.assertEquals(msg, rows, cols, test, expected.getEuclidIntMatrix());
    }

    public static void assertEquals(String msg, CMLPlane3 test, CMLPlane3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, CMLPlane3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 4", (long)4L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, CMLPoint3 test, CMLPoint3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getXYZ3(), expected.getXYZ3(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, CMLPoint3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getXYZ3(), epsilon);
    }

    public static void assertEquals(String msg, CMLTransform3 test, CMLTransform3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getEuclidTransform3(), expected.getEuclidTransform3(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, CMLTransform3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 16", (long)16L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getEuclidTransform3(), epsilon);
    }

    public static void assertEquals(String msg, CMLVector3 test, CMLVector3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test.getXYZ3(), expected.getXYZ3(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, CMLVector3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        CMLXOMTestUtils.assertEquals(msg, test, expected.getXYZ3(), epsilon);
    }
}

