/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.Arrays;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Int2;
import org.xmlcml.euclid.Int2Range;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.Util;

class Int2Array {
    IntArray xarr;
    IntArray yarr;
    Int2[] xy;
    int nelem = 0;
    private boolean expanded = false;

    public Int2Array() {
    }

    public Int2Range getRange2() {
        Int2Range temp = new Int2Range();
        this.expand();
        for (int i = 0; i < this.nelem; ++i) {
            temp.add(this.elementAt(i));
        }
        return temp;
    }

    public Int2Array(IntArray x, IntArray y) throws EuclidRuntimeException {
        if (x.size() != y.size()) {
            throw new EuclidRuntimeException("arrays of different sizes");
        }
        this.nelem = x.size();
        this.xarr = (IntArray)x.clone();
        this.yarr = (IntArray)y.clone();
        this.expanded = false;
    }

    private void expand() {
        if (this.expanded) {
            return;
        }
        this.expanded = true;
        this.xy = new Int2[this.nelem];
        try {
            for (int i = 0; i < this.nelem; ++i) {
                this.xy[i] = new Int2(this.xarr.elementAt(i), this.yarr.elementAt(i));
            }
        }
        catch (Exception e2) {
            Util.BUG(e2);
        }
    }

    public int size() {
        return this.nelem;
    }

    public Int2 elementAt(int elem) {
        this.expand();
        return this.xy[elem];
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.xarr == null ? 0 : this.xarr.hashCode());
        result = 31 * result + Arrays.hashCode(this.xy);
        result = 31 * result + (this.yarr == null ? 0 : this.yarr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Int2Array other = (Int2Array)obj;
        if (this.xarr == null ? other.xarr != null : !this.xarr.equals(other.xarr)) {
            return false;
        }
        if (!Arrays.equals(this.xy, other.xy)) {
            return false;
        }
        return !(this.yarr == null ? other.yarr != null : !this.yarr.equals(other.yarr));
    }
}

