/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Int2;
import org.xmlcml.euclid.Int2Array;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.RealMatrix;

public class IntMatrix
implements EuclidConstants {
    static final Logger LOG = Logger.getLogger(IntMatrix.class);
    protected int rows = 0;
    protected int cols = 0;
    protected int[][] flmat = new int[0][0];
    DecimalFormat format = null;

    public IntMatrix() {
    }

    public IntMatrix(int r, int c) {
        if (r < 0) {
            r = 0;
        }
        if (c < 0) {
            c = 0;
        }
        this.rows = r;
        this.cols = c;
        this.flmat = new int[r][c];
    }

    public IntMatrix(int rows, int cols, int[] array) throws EuclidRuntimeException {
        this(rows, cols);
        this.check(rows, cols, array);
        this.rows = rows;
        this.cols = cols;
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.flmat[i][j] = array[count++];
            }
        }
    }

    public IntMatrix(int r, int c, int f) {
        this(r, c);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[i][j] = f;
            }
        }
    }

    public IntMatrix(IntMatrix m, int lowrow, int hirow, int lowcol, int hicol) throws EuclidRuntimeException {
        this(hirow - lowrow + 1, hicol - lowcol + 1);
        if (hirow >= m.getRows() || lowrow < 0) {
            throw new EuclidRuntimeException("bad row index: " + lowrow + "/" + hirow + " outside 0/" + m.getRows());
        }
        if (hicol >= m.getCols() || lowcol < 0) {
            throw new EuclidRuntimeException("bad col index: " + lowcol + "/" + hicol + " outside 0/" + m.getCols());
        }
        int i = 0;
        int mrow = lowrow;
        while (i < this.rows) {
            int j = 0;
            int mcol = lowcol;
            while (j < this.cols) {
                this.flmat[i][j] = m.flmat[mrow][mcol];
                ++j;
                ++mcol;
            }
            ++i;
            ++mrow;
        }
    }

    public IntMatrix(IntMatrix m) {
        this(m.rows, m.cols);
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(m.flmat[i], 0, this.flmat[i], 0, this.cols);
        }
    }

    public static IntMatrix createByRows(List<List<Integer>> intListList) {
        List<Integer> row0;
        int cols;
        int rows;
        IntMatrix intMatrix = null;
        if (intListList != null && (rows = intListList.size()) > 0 && (cols = (row0 = intListList.get(0)).size()) > 0) {
            intMatrix = new IntMatrix(rows, cols);
            for (int i = 0; i < rows; ++i) {
                List<Integer> rowi = intListList.get(i);
                if (rowi.size() == 0 || rowi.size() != cols) continue;
                for (int j = 0; j < cols; ++j) {
                    intMatrix.flmat[i][j] = rowi.get(j);
                }
            }
        }
        return intMatrix;
    }

    public void shallowCopy(IntMatrix m) {
        this.rows = m.rows;
        this.cols = m.cols;
        this.flmat = m.flmat;
    }

    public IntMatrix getIntMatrix() {
        IntMatrix im = new IntMatrix(this.rows, this.cols);
        int[][] matrix = im.getMatrix();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                matrix[i][j] = this.flmat[i][j];
            }
        }
        return im;
    }

    public IntMatrix(int[][] m) throws EuclidRuntimeException {
        this(m.length, m[0].length);
        for (int i = 0; i < this.rows; ++i) {
            if (m[i].length != this.cols) {
                throw new EuclidRuntimeException("non-rectangular matrix cols: " + this.cols + " row: " + i + " length: " + m[i].length);
            }
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[i][j] = m[i][j];
            }
        }
    }

    public IntMatrix(RealMatrix realMatrix) {
        this(realMatrix.getRows(), realMatrix.getCols());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[i][j] = (int)realMatrix.flmat[i][j];
            }
        }
    }

    public void setFormat(DecimalFormat f) {
        this.format = f;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int[][] getMatrix() {
        return this.flmat;
    }

    public int[] getMatrixAsArray() {
        int[] temp = new int[this.rows * this.cols];
        int count = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                temp[count++] = this.flmat[i][j];
            }
        }
        return temp;
    }

    public boolean isEqualTo(IntMatrix m) {
        boolean ok = true;
        try {
            this.checkConformable(m);
            block2: for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    if (this.flmat[i][j] == m.flmat[i][j]) continue;
                    ok = false;
                    continue block2;
                }
            }
        }
        catch (EuclidRuntimeException e2) {
            ok = false;
        }
        return ok;
    }

    private void checkConformable(IntMatrix m) throws EuclidRuntimeException {
        if (this.rows != m.rows || this.cols != m.cols) {
            throw new EuclidRuntimeException("unequal matrices");
        }
    }

    private void checkConformable2(IntMatrix m) throws EuclidRuntimeException {
        if (m.rows != this.cols) {
            throw new EuclidRuntimeException("unequal matrices (" + this.cols + ", " + m.rows + ")");
        }
    }

    private void check(int rows, int cols, int[] array) throws EuclidRuntimeException {
        if (array == null) {
            throw new EuclidRuntimeException("IntMatrix(null)");
        }
        if (array.length != rows * cols) {
            throw new EuclidRuntimeException("rows * cols (" + rows + "*" + cols + ") != array (" + array.length + ")");
        }
    }

    public IntMatrix plus(IntMatrix m2) throws EuclidRuntimeException {
        IntMatrix m = new IntMatrix(m2.rows, m2.cols);
        this.checkConformable(m2);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                m.flmat[i][j] = this.flmat[i][j] + m2.flmat[i][j];
            }
        }
        return m;
    }

    public IntMatrix subtract(IntMatrix m2) throws EuclidRuntimeException {
        IntMatrix m = new IntMatrix(m2.rows, m2.cols);
        this.checkConformable(m2);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                m.flmat[i][j] = this.flmat[i][j] - m2.flmat[i][j];
            }
        }
        return m;
    }

    public void negative() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[i][j] = -this.flmat[i][j];
            }
        }
    }

    public IntMatrix multiply(IntMatrix m) throws EuclidRuntimeException {
        this.checkConformable2(m);
        IntMatrix m1 = new IntMatrix(this.rows, m.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < m.cols; ++j) {
                m1.flmat[i][j] = 0;
                for (int k = 0; k < this.cols; ++k) {
                    int[] nArray = m1.flmat[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.flmat[i][k] * m.flmat[k][j];
                }
            }
        }
        return m1;
    }

    public void multiplyBy(int f) {
        for (int i = 0; i < this.rows; ++i) {
            int j = 0;
            while (j < this.cols) {
                int[] nArray = this.flmat[i];
                int n = j++;
                nArray[n] = nArray[n] * f;
            }
        }
    }

    public void multiplyEquals(IntMatrix m) throws EuclidRuntimeException {
        IntMatrix mm = this.multiply(m);
        this.rows = mm.rows;
        this.cols = mm.cols;
        this.flmat = new int[this.rows][];
        for (int i = 0; i < this.rows; ++i) {
            this.flmat[i] = new int[this.cols];
            System.arraycopy(mm.flmat[i], 0, this.flmat[i], 0, this.cols);
        }
    }

    void checkColumns(int[] d) throws EuclidRuntimeException {
        if (d.length != this.cols) {
            throw new EuclidRuntimeException("array size " + d.length + "!= cols length " + this.cols);
        }
    }

    private void checkRows(int[] d) throws EuclidRuntimeException {
        if (d.length != this.rows) {
            throw new EuclidRuntimeException("array size " + d.length + "!= rows length " + this.rows);
        }
    }

    public void translateByColumn(int[] d) throws EuclidRuntimeException {
        this.checkRows(d);
        for (int i = this.cols - 1; i >= 0; --i) {
            for (int j = this.rows - 1; j >= 0; --j) {
                int[] nArray = this.flmat[j];
                int n = i;
                nArray[n] = nArray[n] - d[j];
            }
        }
    }

    public IntArray multiply(IntArray f) throws EuclidRuntimeException {
        if (f.size() != this.cols) {
            throw new EuclidRuntimeException("unequal matrices");
        }
        int[] temp = new int[this.rows];
        int[] farray = f.getArray();
        for (int i = 0; i < this.rows; ++i) {
            temp[i] = 0;
            for (int j = 0; j < this.cols; ++j) {
                int n = i;
                temp[n] = temp[n] + this.flmat[i][j] * farray[j];
            }
        }
        IntArray ff = new IntArray(temp);
        return ff;
    }

    public void columnwiseDivide(IntArray f) throws EuclidRuntimeException {
        if (this.cols != f.size()) {
            throw new EuclidRuntimeException("unequal matrices " + this.cols + "/" + f.size());
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                int[] nArray = this.flmat[i];
                int n = j;
                nArray[n] = nArray[n] / f.elementAt(j);
            }
        }
    }

    public int elementAt(int row, int col) throws EuclidRuntimeException {
        this.checkRow(row);
        this.checkColumn(col);
        return this.flmat[row][col];
    }

    private void checkRow(int row) throws EuclidRuntimeException {
        if (row < 0 || row >= this.rows) {
            throw new EuclidRuntimeException("Bad value of row: " + row + "/" + this.rows);
        }
    }

    private void checkColumn(int col) throws EuclidRuntimeException {
        if (col < 0 || col >= this.cols) {
            throw new EuclidRuntimeException("Bad value of col: " + col + "/" + this.cols);
        }
    }

    public int elementAt(Int2 rowcol) throws EuclidRuntimeException {
        return this.elementAt(rowcol.elementAt(0), rowcol.elementAt(1));
    }

    public void setElementAt(int row, int col, int f) throws EuclidRuntimeException {
        this.checkRow(row);
        this.checkColumn(col);
        this.flmat[row][col] = f;
    }

    public int largestElement() {
        Int2 temp = this.indexOfLargestElement();
        if (temp == null) {
            throw new EuclidRuntimeException("bug; null index for largest element");
        }
        int d = this.elementAt(temp);
        return d;
    }

    public Int2 indexOfLargestElement() {
        Int2 int2 = null;
        if (this.cols != 0 && this.rows != 0) {
            int f = Integer.MIN_VALUE;
            int im = 0;
            int jm = 0;
            for (int irow = 0; irow < this.rows; ++irow) {
                for (int jcol = 0; jcol < this.cols; ++jcol) {
                    if (f >= this.flmat[irow][jcol]) continue;
                    f = this.flmat[irow][jcol];
                    im = irow;
                    jm = jcol;
                }
            }
            int2 = new Int2(im, jm);
        }
        return int2;
    }

    public int largestElementInColumn(int jcol) throws EuclidRuntimeException {
        return this.elementAt(this.indexOfLargestElementInColumn(jcol), jcol);
    }

    public int indexOfLargestElementInColumn(int jcol) throws EuclidRuntimeException {
        this.checkColumn(jcol);
        int imax = -1;
        int max2 = Integer.MIN_VALUE;
        for (int irow = 0; irow < this.rows; ++irow) {
            if (max2 >= this.flmat[irow][jcol]) continue;
            max2 = this.flmat[irow][jcol];
            imax = irow;
        }
        return imax;
    }

    public int indexOfLargestElementInRow(int irow) throws EuclidRuntimeException {
        this.checkRow(irow);
        int imax = -1;
        int max2 = Integer.MIN_VALUE;
        for (int jcol = 0; jcol < this.cols; ++jcol) {
            if (max2 >= this.flmat[irow][jcol]) continue;
            max2 = this.flmat[irow][jcol];
            imax = jcol;
        }
        return imax;
    }

    public int indexOfSmallestElementInColumn(int jcol) throws EuclidRuntimeException {
        this.checkColumn(jcol);
        int imin = -1;
        int min2 = Integer.MAX_VALUE;
        for (int irow = 0; irow < this.rows; ++irow) {
            if (min2 <= this.flmat[irow][jcol]) continue;
            min2 = this.flmat[irow][jcol];
            imin = irow;
        }
        return imin;
    }

    protected boolean checkNonEmptyMatrix() {
        return this.cols > 0 && this.rows > 0;
    }

    public int largestElementInRow(int irow) throws EuclidRuntimeException {
        int idx = this.indexOfLargestElementInRow(irow);
        if (idx < 0) {
            throw new EuclidRuntimeException("empty matrix");
        }
        return this.elementAt(irow, idx);
    }

    public int indexOfSmallestElementInRow(int irow) throws EuclidRuntimeException {
        this.checkRow(irow);
        int imin = -1;
        int min2 = Integer.MAX_VALUE;
        for (int jcol = 0; jcol < this.cols; ++jcol) {
            if (min2 <= this.flmat[irow][jcol]) continue;
            min2 = this.flmat[irow][jcol];
            imin = jcol;
        }
        return imin;
    }

    public int smallestElement() throws EuclidRuntimeException {
        Int2 temp = this.indexOfSmallestElement();
        return this.elementAt(temp);
    }

    public Int2 indexOfSmallestElement() {
        int f = Integer.MAX_VALUE;
        int im = -1;
        int jm = -1;
        for (int irow = 0; irow < this.rows; ++irow) {
            for (int jcol = 0; jcol < this.cols; ++jcol) {
                if (f <= this.flmat[irow][jcol]) continue;
                f = this.flmat[irow][jcol];
                im = irow;
                jm = jcol;
            }
        }
        return im >= 0 ? new Int2(im, jm) : null;
    }

    public int smallestElementInColumn(int jcol) throws EuclidRuntimeException {
        int idx = this.indexOfSmallestElementInColumn(jcol);
        if (idx < 0) {
            throw new EuclidRuntimeException("empty matrix");
        }
        return this.elementAt(idx, jcol);
    }

    public int smallestElementInRow(int irow) throws EuclidRuntimeException {
        int idx = this.indexOfSmallestElementInRow(irow);
        if (idx < 0) {
            throw new EuclidRuntimeException("empty matrix");
        }
        return this.elementAt(irow, idx);
    }

    public boolean isOrthogonal() {
        for (int i = 1; i < this.rows; ++i) {
            IntArray rowi = this.extractRowData(i);
            int dot = 0;
            for (int j = i + 1; j < this.rows; ++j) {
                IntArray rowj = this.extractRowData(j);
                dot = rowi.dotProduct(rowj);
                if (dot == 0) continue;
                return false;
            }
        }
        return true;
    }

    public IntArray extractColumnData(int col) throws EuclidRuntimeException {
        this.checkColumn(col);
        IntArray fa = new IntArray(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            fa.setElementAt(i, this.flmat[i][col]);
        }
        return fa;
    }

    public IntArray extractRowData(int row) {
        return new IntArray(this.flmat[row]);
    }

    public void clearMatrix() {
        for (int irow = 0; irow < this.rows; ++irow) {
            for (int jcol = 0; jcol < this.cols; ++jcol) {
                this.flmat[irow][jcol] = 0;
            }
        }
    }

    public void setAllElements(int f) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[i][j] = f;
            }
        }
    }

    public IntMatrix getTranspose() {
        int[][] m = new int[this.cols][this.rows];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                m[j][i] = this.flmat[i][j];
            }
        }
        return new IntMatrix(m);
    }

    public boolean isSquare() {
        return this.cols == this.rows && this.cols > 0;
    }

    public void deleteColumn(int col) {
        if (col >= 0 && col < this.cols) {
            int[][] temp = new int[this.rows][this.cols - 1];
            for (int i = 0; i < this.rows; ++i) {
                int j;
                for (j = 0; j < col; ++j) {
                    temp[i][j] = this.flmat[i][j];
                }
                for (j = col + 1; j < this.cols; ++j) {
                    temp[i][j - 1] = this.flmat[i][j];
                }
            }
            --this.cols;
            this.flmat = temp;
        }
    }

    public void deleteColumns(int low, int high) {
        high = high > this.cols - 1 ? this.cols - 1 : high;
        low = low < 0 ? 0 : low;
        for (int i = 0; i < this.rows; ++i) {
            this.flmat[i] = IntArray.deleteElements(this.flmat[i], low, high);
        }
        this.cols -= high - low + 1;
    }

    public void deleteRow(int row) {
        this.deleteRows(row, row);
    }

    public void deleteRows(int low, int high) {
        high = high >= this.rows ? this.rows - 1 : high;
        int n = low = low < 0 ? 0 : low;
        if (low > high) {
            return;
        }
        int newrows = this.rows + high - low - 1;
        int[][] temp = new int[newrows][this.cols];
        int newrow = 0;
        for (int oldrow = 0; oldrow < this.rows; ++oldrow) {
            if (oldrow >= low && oldrow <= high) continue;
            temp[newrow++] = this.flmat[oldrow];
        }
        this.rows = newrows;
        this.flmat = temp;
    }

    public void replaceColumnData(int column, IntArray f) throws EuclidRuntimeException {
        this.checkRows(f);
        this.checkColumn(column);
        int[] temp = f.getArray();
        for (int i = 0; i < this.rows; ++i) {
            this.flmat[i][column] = temp[i];
        }
    }

    private void checkRows(IntArray f) throws EuclidRuntimeException {
        if (f == null || f.size() != this.rows) {
            throw new EuclidRuntimeException("incompatible value of array size: " + f.size() + "/" + this.rows);
        }
    }

    private void checkColumns(IntArray f) throws EuclidRuntimeException {
        if (f == null || f.size() != this.cols) {
            throw new EuclidRuntimeException("incompatible value of array size: " + f.size() + "/" + this.cols);
        }
    }

    private void checkColumns(IntSet is) throws EuclidRuntimeException {
        if (is == null || is.size() != this.cols) {
            throw new EuclidRuntimeException("incompatible value of IntSet size: " + is.size() + "/" + this.cols);
        }
    }

    private void checkColumns(IntMatrix m) throws EuclidRuntimeException {
        if (m == null || m.getCols() != this.cols) {
            throw new EuclidRuntimeException("incompatible value of matrix size: " + m.getCols() + "/" + this.cols);
        }
    }

    private void checkRows(IntMatrix m) throws EuclidRuntimeException {
        if (m == null || m.getRows() != this.rows) {
            throw new EuclidRuntimeException("incompatible value of matrix size: " + m.getRows() + "/" + this.rows);
        }
    }

    public void replaceColumnData(int starting_col, int[] f) throws EuclidRuntimeException {
        this.replaceColumnData(starting_col, new IntArray(this.rows, f));
    }

    public void replaceColumnData(int start_column, IntMatrix m) throws EuclidRuntimeException {
        if (this == m) {
            return;
        }
        this.cols = this.getCols();
        int mcols = m.getCols();
        this.checkRows(m);
        if (start_column < 0) {
            throw new EuclidRuntimeException("cannot start at negative column: " + start_column);
        }
        int end_column = start_column + mcols;
        if (end_column > this.cols) {
            throw new EuclidRuntimeException("too many columns to copy: " + start_column + "|" + mcols + "/" + this.cols);
        }
        this.copyColumns(m.flmat, start_column, mcols);
    }

    private void copyColumns(int[][] mat, int start_column, int nToCopy) {
        for (int j = 0; j < nToCopy; ++j) {
            for (int i = 0; i < this.rows; ++i) {
                this.flmat[i][start_column + j] = mat[i][j];
            }
        }
    }

    public void makeSpaceForNewColumns(int after_col, int delta_cols) {
        if (after_col >= 0 && after_col <= this.cols && delta_cols > 0) {
            int newcols = delta_cols + this.cols;
            IntMatrix temp = new IntMatrix(this.rows, newcols);
            for (int irow = 0; irow < this.rows; ++irow) {
                int jcol;
                for (jcol = 0; jcol < after_col; ++jcol) {
                    temp.flmat[irow][jcol] = this.flmat[irow][jcol];
                }
                for (jcol = after_col; jcol < this.cols; ++jcol) {
                    temp.flmat[irow][jcol + delta_cols] = this.flmat[irow][jcol];
                }
            }
            this.shallowCopy(temp);
        }
    }

    public void insertColumnData(int after_col, IntArray f) throws EuclidRuntimeException {
        this.checkRows(f);
        if (this.cols == 0) {
            this.rows = f.size();
            this.flmat = new int[this.rows][1];
            int[] arr = f.getArray();
            this.cols = 1;
            for (int i = 0; i < this.rows; ++i) {
                this.flmat[i][0] = arr[i];
            }
        } else if (f.size() == this.rows) {
            this.makeSpaceForNewColumns(after_col + 1, 1);
            this.replaceColumnData(after_col + 1, f);
        }
    }

    public void insertColumnData(int afterCol, IntMatrix m) throws EuclidRuntimeException {
        if (this == m) {
            return;
        }
        this.checkRows(m);
        int mcols = m.getCols();
        this.cols = this.getCols();
        if (afterCol < -1 || afterCol >= this.cols) {
            throw new EuclidRuntimeException("afterCol must be >= -1 or < cols: " + afterCol);
        }
        this.makeSpaceForNewColumns(afterCol + 1, mcols);
        this.replaceColumnData(afterCol + 1, m);
    }

    public void insertRows(int after_row, int delta_rows) {
        if (after_row >= 0 && after_row <= this.cols && delta_rows > 0) {
            int newrows = delta_rows + this.rows;
            IntMatrix temp = new IntMatrix(newrows, this.cols);
            for (int jcol = 0; jcol < this.cols; ++jcol) {
                int irow;
                for (irow = 0; irow < after_row; ++irow) {
                    temp.flmat[irow][jcol] = this.flmat[irow][jcol];
                }
                for (irow = after_row; irow < this.rows; ++irow) {
                    temp.flmat[irow + delta_rows][jcol] = this.flmat[irow][jcol];
                }
            }
            this.shallowCopy(temp);
        }
    }

    public void replaceRowData(int row, IntArray f) throws EuclidRuntimeException {
        this.checkColumns(f);
        int mcols = f.size();
        System.arraycopy(f.getArray(), 0, this.flmat[row], 0, mcols);
    }

    public void replaceRowData(int row, int[] f) throws EuclidRuntimeException {
        IntArray temp = new IntArray(this.cols, f);
        this.replaceRowData(row, temp);
    }

    public void replaceRowData(int afterRow, IntMatrix m) throws EuclidRuntimeException {
        if (this == m) {
            return;
        }
        this.checkColumns(m);
        if (afterRow < -1) {
            throw new EuclidRuntimeException("afterRow must be >= -1 :" + afterRow);
        }
        if (afterRow > this.rows - m.rows) {
            throw new EuclidRuntimeException("afterRow (" + afterRow + ")must be <= rows (" + this.rows + ") - m.rows (" + m.rows + ")");
        }
        this.copyRowData(m.flmat, afterRow + 1, m.rows);
    }

    public void insertRowData(int afterRow, IntMatrix m) throws EuclidRuntimeException {
        if (this == m) {
            return;
        }
        this.rows = this.getRows();
        int mrows = m.getRows();
        this.checkColumns(m);
        if (afterRow < -1) {
            throw new EuclidRuntimeException("must insert after -1 or higher");
        }
        if (afterRow >= this.rows) {
            throw new EuclidRuntimeException("must insert after nrows-1 or lower");
        }
        this.insertRows(afterRow + 1, mrows);
        this.copyRowData(m.flmat, afterRow + 1, mrows);
    }

    private void copyRowData(int[][] mat, int afterRow, int nrows) {
        for (int i = 0; i < nrows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.flmat[afterRow + i][j] = mat[i][j];
            }
        }
    }

    public void insertRowData(int after_row, IntArray f) throws EuclidRuntimeException {
        this.checkColumns(f);
        int mcols = f.size();
        if (after_row < -1 || after_row > this.rows || mcols != this.cols) {
            throw new EuclidRuntimeException("Cannot add array after  row" + after_row + "/" + this.rows + "==" + mcols + "/" + this.cols);
        }
        this.insertRows(after_row + 1, 1);
        this.replaceRowData(after_row + 1, f);
    }

    public void appendColumnData(IntArray f) throws EuclidRuntimeException {
        if (this.cols == 0) {
            this.rows = f.size();
        }
        this.insertColumnData(this.cols - 1, f);
    }

    public void appendColumnData(IntMatrix m) throws EuclidRuntimeException {
        if (this.cols == 0) {
            this.rows = m.getRows();
        }
        this.insertColumnData(this.cols - 1, m);
    }

    public void appendRowData(IntArray f) throws EuclidRuntimeException {
        if (this.rows == 0) {
            this.cols = f.size();
        }
        this.insertRowData(this.rows - 1, f);
    }

    public void appendRowData(IntMatrix m) throws EuclidRuntimeException {
        if (this.rows == 0) {
            this.cols = m.getCols();
        }
        this.insertRowData(this.rows - 1, m);
    }

    public void replaceSubMatrixData(int low_row, int low_col, IntMatrix m) {
        if (this == m) {
            return;
        }
        if (low_row > 0 && low_col > 0) {
            int mrows = m.getRows();
            int mcols = m.getCols();
            if (low_row + mrows - 1 < this.rows && low_col + mcols - 1 < this.cols) {
                for (int i = 0; i < mrows; ++i) {
                    for (int j = 0; j < mcols; ++j) {
                        this.flmat[i + low_row - 1][j] = m.flmat[i][j];
                    }
                }
            }
        }
    }

    public IntMatrix reorderColumnsBy(IntSet is) throws EuclidRuntimeException {
        this.checkColumns(is);
        IntMatrix temp = new IntMatrix(this.rows, is.size());
        for (int i = 0; i < is.size(); ++i) {
            int icol = is.elementAt(i);
            if (icol >= this.cols || icol < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            IntArray coldat = this.extractColumnData(icol);
            temp.replaceColumnData(i, coldat);
        }
        return temp;
    }

    public IntMatrix reorderRowsBy(IntSet is) throws EuclidRuntimeException {
        if (is.size() != this.rows) {
            throw new EuclidRuntimeException("unequal matrices");
        }
        IntMatrix temp = new IntMatrix(is.size(), this.cols);
        for (int i = 0; i < is.size(); ++i) {
            int irow = is.elementAt(i);
            if (irow >= this.rows || irow < 0) {
                throw new EuclidRuntimeException("irow: " + irow);
            }
            IntArray rowdat = this.extractRowData(irow);
            temp.replaceRowData(i, rowdat);
        }
        return temp;
    }

    public IntMatrix extractSubMatrixData(int low_row, int high_row, int low_col, int high_col) throws EuclidRuntimeException {
        return new IntMatrix(this, low_row, high_row, low_col, high_col);
    }

    public Int2Array extractColumns(int col1, int col2) throws EuclidRuntimeException {
        IntArray x = this.extractColumnData(col1);
        IntArray y = this.extractColumnData(col2);
        return new Int2Array(x, y);
    }

    public Int2Array extractRows(int row1, int row2) throws EuclidRuntimeException {
        IntArray x = this.extractRowData(row1);
        IntArray y = this.extractRowData(row2);
        return new Int2Array(x, y);
    }

    public IntMatrix elementsInRange(IntRange r) throws EuclidRuntimeException {
        IntMatrix m = new IntMatrix(this.rows, this.cols);
        for (int irow = 0; irow < this.rows; ++irow) {
            for (int jcol = 0; jcol < this.cols; ++jcol) {
                int elem = 0;
                if (r.includes(this.elementAt(irow, jcol))) {
                    elem = 1;
                }
                m.setElementAt(irow, jcol, elem);
            }
        }
        return m;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.rows > 0 && this.cols > 0) {
            sb.append("{");
            sb.append(this.rows);
            sb.append(",");
            sb.append(this.cols);
            sb.append("}");
        } else {
            sb.append("(");
        }
        for (int i = 0; i < this.rows; ++i) {
            sb.append("\n");
            sb.append("(");
            for (int j = 0; j < this.cols; ++j) {
                if (j > 0) {
                    sb.append(",");
                }
                if (this.format == null) {
                    sb.append(this.flmat[i][j]);
                    continue;
                }
                sb.append(this.format.format(this.flmat[i][j]));
            }
            sb.append(")");
        }
        if (this.rows == 0 || this.cols == 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public void writeXML(Writer w) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<matrix rows='" + this.rows + "' columns='" + this.cols + "'>");
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (i != 0 || j != 0) {
                    sb.append(" ");
                }
                if (this.format == null) {
                    sb.append(this.flmat[i][j]);
                    continue;
                }
                sb.append(this.format.format(this.flmat[i][j]));
            }
        }
        sb.append("</matrix>");
        w.write(sb.toString());
    }

    public static List<Integer> findLargestUniqueElementsInRowColumn(IntMatrix intMatrix) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        int max2 = intMatrix.getCols();
        for (int jcol = 0; jcol < max2; ++jcol) {
            int irow = intMatrix.indexOfLargestElementInColumn(jcol);
            int maxval = intMatrix.elementAt(irow, jcol);
            if (maxval == -1) {
                irow = -1;
            } else {
                int maxrow = intMatrix.getRows();
                for (int ii = irow + 1; ii < maxrow; ++ii) {
                    int val = intMatrix.elementAt(ii, jcol);
                    if (val < maxval) continue;
                    irow = -1;
                    break;
                }
            }
            intList.add(irow);
        }
        return intList;
    }
}

