/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Iterator;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;

public class Real2Array
implements EuclidConstants,
Iterable<Real2> {
    private static Logger LOG = Logger.getLogger(Real2Array.class);
    RealArray xarr;
    RealArray yarr;
    int nelem = 0;

    public Real2Array() {
    }

    public Real2Range getRange2() {
        Real2Range range = new Real2Range();
        for (int i = 0; i < this.nelem; ++i) {
            Real2 r2 = new Real2(this.xarr.elementAt(i), this.yarr.elementAt(i));
            range.add(r2);
        }
        return range;
    }

    public Real2Array(Real2Array r2a) {
        if (r2a != null && !r2a.equals(this)) {
            this.xarr = new RealArray(r2a.getXArray());
            this.yarr = new RealArray(r2a.getYArray());
            this.nelem = r2a.nelem;
        }
    }

    public Real2Array(RealArray x, RealArray y) throws EuclidRuntimeException {
        if (x.size() != y.size()) {
            throw new EuclidRuntimeException("incompatible array sizes " + x.size() + "/" + y.size());
        }
        this.nelem = x.size();
        this.xarr = (RealArray)x.clone();
        this.yarr = (RealArray)y.clone();
    }

    public Real2Array(int size) {
        this(new RealArray(size), new RealArray(size));
    }

    public Real2Array(List<Real2> points) {
        for (Real2 point : points) {
            this.add(point);
        }
    }

    public boolean isEqualTo(Real2Array r2b, double epsilon) {
        if (r2b == null || this.size() != r2b.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Real2 rb;
            Real2 ra = this.get(i);
            if (ra.isEqualTo(rb = r2b.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public void add(Real2 r2) {
        if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
            this.xarr = new RealArray();
            this.yarr = new RealArray();
        }
        this.xarr.addElement(r2.getX());
        this.yarr.addElement(r2.getY());
        ++this.nelem;
    }

    public void add(Real2Array real2Array) {
        if (real2Array != null) {
            if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
                this.xarr = new RealArray();
                this.yarr = new RealArray();
            }
            this.xarr.addArray(real2Array.xarr);
            this.yarr.addArray(real2Array.yarr);
            this.nelem += real2Array.size();
        }
    }

    public static Real2Array createFromPairs(String sss, String delimiter) {
        String[] ss;
        Real2Array real2Array = null;
        if (sss != null && (ss = sss.trim().split(delimiter)).length % 2 == 0) {
            RealArray realArray = new RealArray(ss);
            real2Array = Real2Array.createFromPairs(realArray);
        }
        return real2Array;
    }

    public static Real2Array createFromPairs(RealArray ra) {
        if (ra == null) {
            throw new RuntimeException("Null RealArray");
        }
        if (ra.size() % 2 != 0) {
            throw new RuntimeException("Must have even number of points");
        }
        Real2Array real2Array = new Real2Array();
        real2Array.xarr = new RealArray();
        real2Array.yarr = new RealArray();
        int i = 0;
        while (i < ra.size()) {
            real2Array.xarr.addElement(ra.elementAt(i++));
            real2Array.yarr.addElement(ra.elementAt(i++));
            ++real2Array.nelem;
        }
        return real2Array;
    }

    public RealArray getXArray() {
        return this.xarr;
    }

    public RealArray getYArray() {
        return this.yarr;
    }

    public int size() {
        return this.nelem;
    }

    public Real2 elementAt(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public Real2 get(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public void setElement(int elem, Real2 r2) {
        this.xarr.setElementAt(elem, r2.getX());
        this.yarr.setElementAt(elem, r2.getY());
    }

    public void deleteElement(int i) {
        if (i >= 0 && i < this.nelem) {
            this.xarr.deleteElement(i);
            this.yarr.deleteElement(i);
            --this.nelem;
        } else {
            throw new EuclidRuntimeException("Cannt delete element at: " + i);
        }
    }

    public void transformBy(Transform2 t2) {
        for (int i = 0; i < this.nelem; ++i) {
            Real2 xy = this.get(i);
            xy.transformBy(t2);
            this.setElement(i, xy);
        }
    }

    public Real2Array format(int places) {
        double[] xarray = this.xarr.getArray();
        double[] yarray = this.yarr.getArray();
        for (int i = 0; i < this.nelem; ++i) {
            xarray[i] = Util.format(xarray[i], places);
            yarray[i] = Util.format(yarray[i], places);
        }
        return this;
    }

    public String getStringArray() {
        StringBuffer s = new StringBuffer();
        double[] xarray = this.xarr == null ? null : this.xarr.getArray();
        double[] yarray = this.yarr == null ? null : this.yarr.getArray();
        for (int i = 0; i < this.nelem; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(xarray[i]);
            s.append(" ");
            s.append(yarray[i]);
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        double[] xarray = this.xarr == null ? null : this.xarr.getArray();
        double[] yarray = this.yarr == null ? null : this.yarr.getArray();
        s.append("(");
        for (int i = 0; i < this.nelem; ++i) {
            s.append("(");
            s.append(xarray[i]);
            s.append(",");
            s.append(yarray[i]);
            s.append(")");
        }
        s.append(")");
        return s.toString();
    }

    public Real2 getLastElement() {
        Real2 xy = null;
        if (this.nelem > 0) {
            xy = this.get(this.nelem - 1);
        }
        return xy;
    }

    public void reverse() {
        this.xarr.reverse();
        this.yarr.reverse();
    }

    public void sortAscending(int xy) {
        IntSet is = null;
        if (xy == 0) {
            is = this.xarr.indexSortAscending();
        } else if (xy == 1) {
            is = this.yarr.indexSortAscending();
        }
        this.xarr = this.xarr.createReorderedArray(is);
        this.yarr = this.yarr.createReorderedArray(is);
    }

    public void sortDescending(int xy) {
        IntSet is = null;
        if (xy == 0) {
            is = this.xarr.indexSortDescending();
        } else if (xy == 1) {
            is = this.yarr.indexSortDescending();
        }
        this.xarr = this.xarr.createReorderedArray(is);
        this.yarr = this.yarr.createReorderedArray(is);
    }

    public Real2Array createSubArray(int start) {
        return this.createSubArray(start, this.xarr.size() - 1);
    }

    public Real2Array createSubArray(int start, int end) {
        RealArray xarr = this.xarr.getSubArray(start, end);
        RealArray yarr = this.yarr.getSubArray(start, end);
        return new Real2Array(xarr, yarr);
    }

    public static Real2Array createFromCoords(String coords) {
        Real2Array real2Array = null;
        if (coords != null && (coords = coords.trim()).startsWith("(") && coords.endsWith(")")) {
            real2Array = new Real2Array();
            coords = coords.substring(1, coords.length() - 1);
            Pattern COORD_PATTERN = Pattern.compile("\\(([0-9\\.\\-\\+]+)\\,([0-9\\.\\-\\+]+)\\)");
            Matcher matcher = COORD_PATTERN.matcher(coords);
            while (matcher.find()) {
                try {
                    double[] dd = new double[]{Util.parseFlexibleDouble(matcher.group(1)), Util.parseFlexibleDouble(matcher.group(2))};
                    Real2 coord = new Real2(dd);
                    real2Array.add(coord);
                }
                catch (Exception e2) {
                    LOG.trace("bad coord " + e2);
                    real2Array = null;
                    break;
                }
            }
        }
        return real2Array;
    }

    public Real2 getPointWithMinimumX() {
        int idx = this.getIndexOfPointWithMinimumX();
        return idx == -1 ? null : this.get(idx);
    }

    private int getIndexOfPointWithMinimumX() {
        RealArray xArray = this.getXArray();
        return xArray == null || xArray.size() == 0 ? -1 : xArray.indexOfSmallestElement();
    }

    public Real2 getPointWithMaximumX() {
        int idx = this.getIndexOfPointWithMaximumX();
        return idx == -1 ? null : this.get(idx);
    }

    private int getIndexOfPointWithMaximumX() {
        RealArray xArray = this.getXArray();
        return xArray == null || xArray.size() == 0 ? -1 : xArray.indexOfSmallestElement();
    }

    public Real2 getPointWithMinimumY() {
        int idx = this.getIndexOfPointWithMinimumY();
        return idx == -1 ? null : this.get(idx);
    }

    private int getIndexOfPointWithMinimumY() {
        RealArray yArray = this.getYArray();
        return yArray == null || yArray.size() == 0 ? -1 : yArray.indexOfSmallestElement();
    }

    public Real2 getPointWithMaximumY() {
        int idx = this.getIndexOfPointWithMaximumY();
        return idx == -1 ? null : this.get(idx);
    }

    private int getIndexOfPointWithMaximumY() {
        RealArray yArray = this.getYArray();
        return yArray == null || yArray.size() == 0 ? -1 : yArray.indexOfSmallestElement();
    }

    public Real2Array getMidPointArray(Real2Array real2Array) {
        Real2Array new2Array = null;
        if (real2Array != null && this.nelem == real2Array.nelem) {
            RealArray newXArray = this.xarr.plus(real2Array.xarr).multiplyBy(0.5);
            RealArray newYArray = this.yarr.plus(real2Array.yarr).multiplyBy(0.5);
            new2Array = new Real2Array(newXArray, newYArray);
        }
        return new2Array;
    }

    public Real2 getMean() {
        Real2 mean = null;
        if (this.xarr != null && this.nelem > 0) {
            double xMean = this.xarr.getMean();
            double yMean = this.yarr.getMean();
            mean = new Real2(xMean, yMean);
        }
        return mean;
    }

    @Override
    public Iterator<Real2> iterator() {
        Real2Iterator iterator = this.xarr == null || this.yarr == null || this.xarr.size() != this.yarr.size() ? null : new Real2Iterator(this);
        return iterator;
    }

    public Double sumProductOfAllElements() {
        return this.xarr == null || this.yarr == null ? null : Double.valueOf(this.xarr.sumProductOfAllElements(this.yarr));
    }

    public Real2 getLastPoint() {
        return this.nelem == 0 ? null : new Real2(this.xarr.elementAt(this.nelem - 1), this.yarr.elementAt(this.nelem - 1));
    }

    public List<Real2> getList() {
        ArrayList<Real2> points = new ArrayList<Real2>();
        for (int i = 0; i < this.nelem; ++i) {
            points.add(new Real2(this.xarr.elementAt(i), this.yarr.elementAt(i)));
        }
        return points;
    }
}

