/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.euclid.Util;
import org.xmlcml.xml.XMLConstants;
import org.xmlcml.xml.XMLUtil;

public class STMLType
implements XMLConstants {
    public static final String NO_BASE = "Cannot find base: ";
    protected String summary = "";
    protected String description = "";
    protected String base = null;
    protected String name = null;
    protected String id = null;
    protected boolean isList = false;
    protected String pattern = null;
    protected int listLength = Integer.MIN_VALUE;
    protected int iMinInclusive = Integer.MIN_VALUE;
    protected int iMinExclusive = Integer.MIN_VALUE;
    protected int iMaxInclusive = Integer.MAX_VALUE;
    protected int iMaxExclusive = Integer.MAX_VALUE;
    protected double dMinInclusive = Double.NaN;
    protected double dMinExclusive = Double.NaN;
    protected double dMaxInclusive = Double.NaN;
    protected double dMaxExclusive = Double.NaN;
    protected STMLType[] subTypes = new STMLType[0];
    protected String[] sEnumerationValues = new String[0];
    protected int[] iEnumerationValues = new int[0];
    protected double[] dEnumerationValues = new double[0];
    protected String javaType;
    protected Element restriction;
    protected Element union;
    protected Element list;
    private Element simpleType;

    public STMLType() {
        this.init();
    }

    private void init() {
        this.summary = "";
        this.description = "";
        this.base = null;
        this.name = null;
        this.id = null;
        this.isList = false;
        this.pattern = null;
        this.listLength = Integer.MIN_VALUE;
        this.iMinInclusive = Integer.MIN_VALUE;
        this.iMinExclusive = Integer.MIN_VALUE;
        this.iMaxInclusive = Integer.MAX_VALUE;
        this.iMaxExclusive = Integer.MAX_VALUE;
        this.dMinInclusive = Double.NaN;
        this.dMinExclusive = Double.NaN;
        this.dMaxInclusive = Double.NaN;
        this.dMaxExclusive = Double.NaN;
        this.subTypes = new STMLType[0];
        this.sEnumerationValues = new String[0];
        this.iEnumerationValues = new int[0];
        this.dEnumerationValues = new double[0];
        this.javaType = null;
    }

    public STMLType(STMLType st) {
    }

    public STMLType(Element simpleType) {
        this.init();
        if (!simpleType.getLocalName().equals("simpleType")) {
            throw new RuntimeException("element is not a simpleType, found: " + simpleType.getLocalName());
        }
        this.name = simpleType.getAttributeValue("name");
        this.id = simpleType.getAttributeValue("id");
        this.simpleType = simpleType;
        this.createUnion();
        if (this.union != null) {
            // empty if block
        }
        this.createRestriction();
        this.createList();
        this.createBase();
        this.createDocumentation();
        this.createPattern();
        this.createLength();
        this.createJavaType();
    }

    public void createMinMaxAndEnumerations() {
        this.createMinMax();
        this.createEnumerations();
    }

    Element createUnion() {
        List<Node> unions = XMLUtil.getQueryNodes(this.simpleType, ".//xsd:union", XPATH_XSD);
        this.union = null;
        if (unions.size() == 1) {
            this.union = (Element)unions.get(0);
        } else if (unions.size() > 1) {
            throw new RuntimeException("More than one union");
        }
        if (this.union != null) {
            List<Node> nodes = XMLUtil.getQueryNodes(this.union, "./xsd:simpleType", XPATH_XSD);
            if (nodes.size() != 2) {
                throw new RuntimeException("Union can only have two simpleTypes, found " + nodes.size());
            }
            this.subTypes = new STMLType[nodes.size()];
            int i = 0;
            for (Node node : nodes) {
                this.subTypes[i++] = new STMLType((Element)node);
            }
            this.simpleType = this.subTypes[0].getSimpleType();
        }
        return this.union;
    }

    Element createRestriction() {
        List<Node> restrictions = XMLUtil.getQueryNodes(this.simpleType, ".//xsd:restriction", XPATH_XSD);
        this.restriction = null;
        if (restrictions.size() == 1) {
            this.restriction = (Element)restrictions.get(0);
        } else if (restrictions.size() > 1) {
            System.err.println("More than one restriction");
            XMLUtil.debug(this.simpleType, "CMLTYPE");
        }
        return this.restriction;
    }

    Element createList() {
        List<Node> lists = null;
        this.isList = false;
        if (this.restriction != null) {
            lists = XMLUtil.getQueryNodes(this.restriction, "./xsd:simpleType/xsd:list", XPATH_XSD);
            List<Node> lengths = XMLUtil.getQueryNodes(this.restriction, "./xsd:length", XPATH_XSD);
            if (lengths.size() == 1) {
                Element length = (Element)lengths.get(0);
                try {
                    this.listLength = Integer.parseInt(length.getAttributeValue("value"));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("bad length: " + nfe);
                }
            }
        } else {
            lists = XMLUtil.getQueryNodes(this.simpleType, ".//xsd:list", XPATH_XSD);
        }
        if (lists.size() == 1) {
            this.list = (Element)lists.get(0);
            this.isList = true;
            String baseS = this.list.getAttributeValue("itemType");
            if (baseS == null) {
                XMLUtil.debug(this.simpleType, "SIMPLE1");
                throw new RuntimeException("no base for " + this.name);
            }
            this.base = baseS;
        } else if (lists.size() > 1) {
            System.err.println("More than one list");
            XMLUtil.debug(this.simpleType, "SIMPLE2");
        }
        return this.list;
    }

    String createBase() {
        if (this.base == null) {
            String baseS = this.simpleType.getAttributeValue("base");
            String string = this.base = this.restriction == null ? null : this.restriction.getAttributeValue("base");
            if (baseS == null && this.base == null) {
                throw new RuntimeException("No base or restriction given");
            }
            if (baseS != null) {
                if (this.base != null) {
                    throw new RuntimeException("Cannot give both base attribute and restriction");
                }
                this.base = baseS;
            }
        }
        return this.base;
    }

    String createJavaType() {
        if (this.javaType == null) {
            if ("xsd:integer".equals(this.base)) {
                this.javaType = "xsd:integer";
            } else if ("xsd:nonNegativeInteger".equals(this.base)) {
                this.javaType = "xsd:integer";
                this.iMinInclusive = 0;
            } else if ("xsd:double".equals(this.base) || "xsd:float".equals(this.base)) {
                this.javaType = "xsd:double";
            } else if ("xsd:string".equals(this.base)) {
                this.javaType = "xsd:string";
            } else if ("xsd:boolean".equals(this.base)) {
                this.javaType = "xsd:boolean";
            }
        }
        return this.javaType;
    }

    void createDocumentation() {
        List<Node> docs = XMLUtil.getQueryNodes(this.simpleType, "./xsd:annotation/xsd:documentation", XPATH_XSD);
        if (docs.size() != 0 && docs.size() == 1) {
            Element documentation = (Element)docs.get(0);
            List<Node> summarys = XMLUtil.getQueryNodes(documentation, ".//*[@class='summary']");
            this.summary = summarys.size() == 0 ? null : summarys.get(0).getValue();
            List<Node> descriptions = XMLUtil.getQueryNodes(documentation, ".//*[@class='description']");
            this.description = descriptions.size() == 0 ? null : descriptions.get(0).getValue();
        }
    }

    void createPattern() {
        List<Node> patterns = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:pattern", XPATH_XSD);
        if (patterns.size() > 0) {
            this.pattern = ((Element)patterns.get(0)).getAttributeValue("value");
        }
    }

    void createLength() {
        List<Node> lengths = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:length", XPATH_XSD);
        if (lengths.size() > 0) {
            try {
                this.listLength = Integer.parseInt(((Element)lengths.get(0)).getAttributeValue("value"));
            }
            catch (NumberFormatException e2) {
                XMLUtil.debug(this.simpleType, "SIMPLE3");
                throw new RuntimeException("Bad length " + e2);
            }
        }
    }

    void createMinMax() {
        List<Node> maxInc;
        List<Node> minInc;
        List<Node> maxEx;
        List<Node> minEx = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:minExclusive", XPATH_XSD);
        if (minEx.size() > 0) {
            Element elem = (Element)minEx.get(0);
            String value = elem.getAttributeValue("value");
            if (this.iMinExclusive == Integer.MIN_VALUE && "xsd:integer".equals(this.javaType)) {
                try {
                    this.iMinExclusive = Integer.parseInt(value);
                }
                catch (NumberFormatException e2) {
                    throw new RuntimeException("Bad length " + e2);
                }
            }
            if (Double.isNaN(this.dMinExclusive) && "xsd:double".equals(this.javaType)) {
                try {
                    this.dMinExclusive = Util.parseFlexibleDouble(value);
                }
                catch (NumberFormatException e3) {
                    throw new RuntimeException("Bad length " + e3);
                }
                catch (ParseException e4) {
                    throw new RuntimeException("Bad value for a double: " + value, e4);
                }
            }
        }
        if ((maxEx = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:maxExclusive", XPATH_XSD)).size() > 0) {
            Element elem = (Element)maxEx.get(0);
            String value = elem.getAttributeValue("value");
            if (this.iMaxExclusive == Integer.MAX_VALUE && "xsd:integer".equals(this.javaType)) {
                try {
                    this.iMaxExclusive = Integer.parseInt(value);
                }
                catch (NumberFormatException e5) {
                    throw new RuntimeException("Bad length " + e5);
                }
            }
            if (Double.isNaN(this.dMaxExclusive) && "xsd:double".equals(this.javaType)) {
                try {
                    this.dMaxExclusive = Util.parseFlexibleDouble(value);
                }
                catch (NumberFormatException e6) {
                    throw new RuntimeException("Bad length " + e6);
                }
                catch (ParseException e7) {
                    throw new RuntimeException("Bad value for a double: " + value, e7);
                }
            }
        }
        if ((minInc = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:minInclusive", XPATH_XSD)).size() > 0) {
            Element elem = (Element)minInc.get(0);
            String value = elem.getAttributeValue("value");
            if (this.iMinInclusive == Integer.MIN_VALUE && "xsd:integer".equals(this.javaType)) {
                try {
                    this.iMinInclusive = Integer.parseInt(value);
                }
                catch (NumberFormatException e8) {
                    throw new RuntimeException("Bad length " + e8);
                }
            }
            if (Double.isNaN(this.dMinInclusive) && "xsd:double".equals(this.javaType)) {
                try {
                    this.dMinInclusive = Util.parseFlexibleDouble(value);
                }
                catch (NumberFormatException e9) {
                    throw new RuntimeException("Bad length " + e9);
                }
                catch (ParseException e10) {
                    throw new RuntimeException("Bad value for a double: " + value, e10);
                }
            }
        }
        if ((maxInc = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:maxInclusive", XPATH_XSD)).size() > 0) {
            Element elem = (Element)maxInc.get(0);
            String value = elem.getAttributeValue("value");
            if (this.iMaxInclusive == Integer.MAX_VALUE && "xsd:integer".equals(this.javaType)) {
                try {
                    this.iMaxInclusive = Integer.parseInt(value);
                }
                catch (NumberFormatException e11) {
                    throw new RuntimeException("Bad length " + e11);
                }
            }
            if (Double.isNaN(this.dMaxInclusive) && "xsd:double".equals(this.javaType)) {
                try {
                    this.dMaxInclusive = Util.parseFlexibleDouble(value);
                }
                catch (NumberFormatException e12) {
                    throw new RuntimeException("Bad length " + e12);
                }
                catch (ParseException e13) {
                    throw new RuntimeException("Bad value for a double: " + value, e13);
                }
            }
        }
    }

    void createEnumerations() {
        block8: {
            int size;
            List<Node> restrictions;
            block10: {
                block9: {
                    restrictions = XMLUtil.getQueryNodes(this.simpleType, "./xsd:restriction/xsd:enumeration", XPATH_XSD);
                    size = restrictions.size();
                    if (size <= 0) break block8;
                    int i = 0;
                    if (!"xsd:integer".equals(this.javaType)) break block9;
                    this.iEnumerationValues = new int[size];
                    for (Node node : restrictions) {
                        Element restriction = (Element)node;
                        try {
                            this.iEnumerationValues[i++] = Integer.parseInt(restriction.getAttributeValue("value"));
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("Cannot parse enumeration as integer: " + nfe);
                        }
                    }
                    break block8;
                }
                if (!"xsd:double".equals(this.javaType)) break block10;
                this.dEnumerationValues = new double[size];
                for (Node node : restrictions) {
                    Element restriction = (Element)node;
                    try {
                        this.dEnumerationValues[i++] = NumberFormat.getNumberInstance().parse(restriction.getAttributeValue("value")).doubleValue();
                    }
                    catch (NumberFormatException nfe) {
                        throw new RuntimeException("Cannot parse enumeration as double: " + nfe);
                    }
                    catch (ParseException e2) {
                        throw new RuntimeException("Bad value for a double: " + restriction.getAttributeValue("value"), e2);
                    }
                }
                break block8;
            }
            if (!"xsd:string".equals(this.javaType)) break block8;
            this.sEnumerationValues = new String[size];
            for (Node node : restrictions) {
                Element restriction = (Element)node;
                this.sEnumerationValues[i++] = restriction.getAttributeValue("value");
            }
        }
    }

    public void checkValue(String s) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(s);
            }
        } else {
            if (!this.base.equals("xsd:string")) {
                throw new RuntimeException("Cannot accept String for type: " + this.base);
            }
            if (this.isList) {
                throw new RuntimeException("cannot accept single String for String[] list");
            }
            this.checkPattern(s);
            this.checkEnumeration(s);
        }
    }

    public void checkValue(String[] ss) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(ss);
            }
        } else {
            int i;
            if (!this.base.equals("xsd:string")) {
                throw new RuntimeException("Cannot accept String for type: " + this.base);
            }
            if (!this.isList) {
                throw new RuntimeException("cannot accept a list String[] for single String");
            }
            this.checkListLength(ss.length);
            try {
                for (i = 0; i < ss.length; ++i) {
                    this.checkPattern(ss[i]);
                    this.checkEnumeration(ss[i]);
                }
            }
            catch (RuntimeException e2) {
                throw new RuntimeException("String (" + i + ")(" + ss[i] + ") fails: " + e2);
            }
        }
    }

    private void checkListLength(int l) throws RuntimeException {
        if (this.listLength > 0 && this.listLength != l) {
            throw new RuntimeException("listLength required (" + this.listLength + ") incompatible with: " + l);
        }
    }

    public void checkValue(int i) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(i);
            }
        } else {
            if (!this.base.equals("xsd:integer")) {
                throw new RuntimeException("Cannot accept int for type: " + this.base);
            }
            if (this.isList) {
                throw new RuntimeException("cannot accept single int for int[] list");
            }
            this.checkMinMax(i);
            this.checkEnumeration(i);
        }
    }

    public void checkValue(int[] ii) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(ii);
            }
        } else {
            int i;
            if (!this.base.equals("xsd:integer")) {
                throw new RuntimeException("Cannot accept int for type: " + this.base);
            }
            if (!this.isList) {
                throw new RuntimeException("cannot accept a list int[] for single int");
            }
            this.checkListLength(ii.length);
            try {
                for (i = 0; i < ii.length; ++i) {
                    this.checkMinMax(ii[i]);
                    this.checkEnumeration(ii[i]);
                }
            }
            catch (RuntimeException e2) {
                throw new RuntimeException("int[] (" + i + ")(" + ii[i] + ") fails: " + e2);
            }
        }
    }

    public void checkValue(double d) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(d);
            }
        } else {
            if (!this.base.equals("xsd:double")) {
                throw new RuntimeException("Cannot accept double for type: " + this.base);
            }
            if (this.isList) {
                throw new RuntimeException("cannot accept single double for double[] list");
            }
            this.checkMinMax(d);
            this.checkEnumeration(d);
        }
    }

    public void checkValue(double[] dd) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(dd);
            }
        } else {
            int i;
            if (!this.base.equals("xsd:double")) {
                throw new RuntimeException("Cannot accept String for type: " + this.base);
            }
            if (!this.isList) {
                throw new RuntimeException("cannot accept a list double[] for single double");
            }
            this.checkListLength(dd.length);
            try {
                for (i = 0; i < dd.length; ++i) {
                    this.checkMinMax(dd[i]);
                    this.checkEnumeration(dd[i]);
                }
            }
            catch (RuntimeException e2) {
                throw new RuntimeException("double[] (" + i + ")(" + dd[i] + ") fails: " + e2);
            }
        }
    }

    public void checkValue(boolean b) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(b);
            }
        } else {
            if (!this.base.equals("xsd:boolean")) {
                throw new RuntimeException("Cannot accept boolean for type: " + this.base);
            }
            if (this.isList) {
                throw new RuntimeException("cannot accept single boolean for boolean[] list");
            }
        }
    }

    public void checkValue(boolean[] bb) throws RuntimeException {
        if (this.subTypes.length > 0) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                this.subTypes[j].checkValue(bb);
            }
        } else {
            if (!this.base.equals("xsd:boolean")) {
                throw new RuntimeException("Cannot accept boolean for type: " + this.base);
            }
            if (!this.isList) {
                throw new RuntimeException("cannot accept a list boolean[] for single boolean");
            }
            this.checkListLength(bb.length);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getIsList() {
        return this.isList;
    }

    public void setIsList(boolean b) {
        this.isList = b;
    }

    public void setPattern(String p) {
        this.pattern = p;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getListLength() {
        return this.listLength;
    }

    public void setListLength(int l) {
        this.listLength = l;
    }

    public void setMinInclusive(int i) {
        this.iMinInclusive = i;
    }

    public void setMinExclusive(int i) {
        this.iMinExclusive = i;
    }

    public void setMaxInclusive(int i) {
        this.iMaxInclusive = i;
    }

    public void setMaxExclusive(int i) {
        this.iMaxExclusive = i;
    }

    public void setMinInclusive(double d) {
        this.dMinInclusive = d;
    }

    public void setMinExclusive(double d) {
        this.dMinExclusive = d;
    }

    public void setMaxInclusive(double d) {
        this.dMaxInclusive = d;
    }

    public void setMaxExclusive(double d) {
        this.dMaxExclusive = d;
    }

    public int getIntMinInclusive() {
        return this.iMinInclusive;
    }

    public int getIntMinExclusive() {
        return this.iMinExclusive;
    }

    public int getIntMaxInclusive() {
        return this.iMaxInclusive;
    }

    public int getIntMaxExclusive() {
        return this.iMaxExclusive;
    }

    public double getDoubleMinInclusive() {
        return this.dMinInclusive;
    }

    public double getDoubleMinExclusive() {
        return this.dMinExclusive;
    }

    public double getDoubleMaxInclusive() {
        return this.dMaxInclusive;
    }

    public double getDoubleMaxExclusive() {
        return this.dMaxExclusive;
    }

    public void setSubTypes(STMLType[] st) {
        this.subTypes = new STMLType[st.length];
        for (int i = 0; i < st.length; ++i) {
            this.subTypes[i] = st[i];
        }
    }

    public void setEnumeration(String[] ss) {
        this.sEnumerationValues = ss;
    }

    public void setEnumeration(int[] ii) {
        this.iEnumerationValues = ii;
    }

    public void setEnumeration(double[] dd) {
        this.dEnumerationValues = dd;
    }

    public String[] getStringEnumeration() {
        return this.sEnumerationValues;
    }

    public int[] getIntEnumeration() {
        return this.iEnumerationValues;
    }

    public double[] getDoubleEnumeration() {
        return this.dEnumerationValues;
    }

    private void checkPattern(String s) throws RuntimeException {
        if (s == null) {
            throw new RuntimeException("Null strings not allowed");
        }
        if (this.pattern != null && !s.matches(this.pattern)) {
            throw new RuntimeException("String (" + s + ") does not match pattern (" + this.pattern + ") for " + this.name);
        }
    }

    private void checkMinMax(int i) throws RuntimeException {
        if (this.iMinInclusive > Integer.MIN_VALUE && i < this.iMinInclusive) {
            throw new RuntimeException("int (" + i + ") less than " + this.iMinInclusive);
        }
        if (this.iMaxInclusive < Integer.MAX_VALUE && i > this.iMaxInclusive) {
            throw new RuntimeException("int (" + i + ") greater than " + this.iMaxInclusive);
        }
        if (this.iMinExclusive > Integer.MIN_VALUE && i <= this.iMinExclusive) {
            throw new RuntimeException("int (" + i + ") less than equals " + this.iMinExclusive);
        }
        if (this.iMaxExclusive < Integer.MAX_VALUE && i >= this.iMaxExclusive) {
            throw new RuntimeException("int (" + i + ") greater than equals " + this.iMaxExclusive);
        }
    }

    private void checkMinMax(double d) throws RuntimeException {
        if (!Double.isNaN(this.dMinInclusive) && d < this.dMinInclusive) {
            throw new RuntimeException("double (" + d + ") less than " + this.dMinInclusive);
        }
        if (!Double.isNaN(this.dMaxInclusive) && d > this.dMaxInclusive) {
            throw new RuntimeException("double (" + d + ") greater than " + this.dMaxInclusive);
        }
        if (!Double.isNaN(this.dMinExclusive) && d <= this.dMinExclusive) {
            throw new RuntimeException("double (" + d + ") less than equals " + this.dMinExclusive);
        }
        if (!Double.isNaN(this.dMaxExclusive) && d >= this.dMaxExclusive) {
            throw new RuntimeException("double (" + d + ") greater than equals " + this.dMaxExclusive);
        }
    }

    private void checkEnumeration(int i) throws RuntimeException {
        if (this.iEnumerationValues.length != 0) {
            boolean ok = false;
            for (int j = 0; j < this.iEnumerationValues.length; ++j) {
                if (i != this.iEnumerationValues[j]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new RuntimeException("int (" + i + ") not contained in enumeration");
            }
        }
    }

    private void checkEnumeration(double d) throws RuntimeException {
        if (this.dEnumerationValues.length != 0) {
            boolean ok = false;
            for (int j = 0; j < this.dEnumerationValues.length; ++j) {
                if (d != this.dEnumerationValues[j]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new RuntimeException("double (" + d + ") not contained in enumeration");
            }
        }
    }

    private void checkEnumeration(String s) throws RuntimeException {
        if (s == null) {
            throw new RuntimeException("Null String cannot be checked against enumeration");
        }
        if (this.dEnumerationValues.length != 0) {
            boolean ok = false;
            for (int j = 0; j < this.sEnumerationValues.length; ++j) {
                if (!s.equals(this.sEnumerationValues[j])) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new RuntimeException("String (" + s + ") not contained in enumeration");
            }
        }
    }

    public int compareTo(STMLType type) {
        return this.name.compareTo(type.name);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String s) {
        this.summary = s.trim();
        if (this.summary.length() != 0 && !this.summary.endsWith(".")) {
            this.summary = this.summary + ".";
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getFullDescription() {
        String desc;
        block19: {
            int i;
            block18: {
                desc = "";
                if (this.subTypes.length <= 0) break block18;
                for (STMLType subType : this.subTypes) {
                    desc = desc + "********SUBTYPE*********\n";
                    desc = desc + subType.getFullDescription();
                }
                break block19;
            }
            if (this.summary != null && !this.summary.trim().equals("")) {
                desc = desc + "\n....  " + this.summary;
            }
            if (this.description != null && !this.description.equals("")) {
                desc = desc + "\n_______________________________________\n" + this.description + "\n__________________________________________\n";
            }
            if (this.pattern != null) {
                desc = desc + "\n Pattern: " + this.pattern;
            }
            if (this.listLength != Integer.MIN_VALUE) {
                desc = desc + "\nLength: " + this.listLength;
            }
            boolean min2 = false;
            if (this.iMinInclusive != Integer.MIN_VALUE) {
                desc = desc + "\nMinInclusive: " + this.iMinInclusive;
                min2 = true;
            }
            if (this.iMinExclusive != Integer.MIN_VALUE) {
                desc = desc + "\nMinExclusive: " + this.iMinExclusive;
                min2 = true;
            }
            if (!Double.isNaN(this.dMinInclusive)) {
                desc = desc + "\nMinInclusive: " + this.dMinInclusive;
                min2 = true;
            }
            if (!Double.isNaN(this.dMinExclusive)) {
                desc = desc + "\nMinExclusive: " + this.dMinExclusive;
                min2 = true;
            }
            if (this.iMaxInclusive != Integer.MAX_VALUE) {
                desc = desc + (min2 ? "" : "\n") + " MaxInclusive: " + this.iMaxInclusive;
            }
            if (this.iMaxExclusive != Integer.MAX_VALUE) {
                desc = desc + (min2 ? "" : "\n") + " MaxExclusive: " + this.iMaxExclusive;
            }
            if (!Double.isNaN(this.dMaxInclusive)) {
                desc = desc + (min2 ? "" : "\n") + " MaxInclusive: " + this.dMaxInclusive;
            }
            if (!Double.isNaN(this.dMaxExclusive)) {
                desc = desc + (min2 ? "" : "\n") + " MaxExclusive: " + this.dMaxExclusive;
            }
            if (this.sEnumerationValues.length > 0) {
                desc = desc + "\nPermitted String values:";
                for (i = 0; i < this.sEnumerationValues.length; ++i) {
                    desc = desc + "\n  " + this.sEnumerationValues[i];
                }
            }
            if (this.iEnumerationValues.length > 0) {
                desc = desc + "\nPermitted integer values:";
                for (i = 0; i < this.iEnumerationValues.length; ++i) {
                    desc = desc + "\n  " + this.iEnumerationValues[i];
                }
            }
            if (this.dEnumerationValues.length <= 0) break block19;
            desc = desc + "\nPermitted double values:";
            for (i = 0; i < this.dEnumerationValues.length; ++i) {
                desc = desc + "\n  " + this.dEnumerationValues[i];
            }
        }
        return desc;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String toString() {
        String s = "Name: " + this.name + "\n";
        if (this.union != null) {
            s = s + ".....UNION: " + this.subTypes.length;
        } else {
            s = s + this.getFullDescription();
            s = s + "\n";
        }
        return s;
    }

    public double[] getDEnumerationValues() {
        return this.dEnumerationValues;
    }

    public void setDEnumerationValues(double[] enumerationValues) {
        this.dEnumerationValues = enumerationValues;
    }

    public double getDMaxExclusive() {
        return this.dMaxExclusive;
    }

    public void setDMaxExclusive(double maxExclusive) {
        this.dMaxExclusive = maxExclusive;
    }

    public double getDMaxInclusive() {
        return this.dMaxInclusive;
    }

    public void setDMaxInclusive(double maxInclusive) {
        this.dMaxInclusive = maxInclusive;
    }

    public double getDMinExclusive() {
        return this.dMinExclusive;
    }

    public void setDMinExclusive(double minExclusive) {
        this.dMinExclusive = minExclusive;
    }

    public double getDMinInclusive() {
        return this.dMinInclusive;
    }

    public void setDMinInclusive(double minInclusive) {
        this.dMinInclusive = minInclusive;
    }

    public int[] getIEnumerationValues() {
        return this.iEnumerationValues;
    }

    public void setIEnumerationValues(int[] enumerationValues) {
        this.iEnumerationValues = enumerationValues;
    }

    public int getIMaxExclusive() {
        return this.iMaxExclusive;
    }

    public void setIMaxExclusive(int maxExclusive) {
        this.iMaxExclusive = maxExclusive;
    }

    public int getIMaxInclusive() {
        return this.iMaxInclusive;
    }

    public void setIMaxInclusive(int maxInclusive) {
        this.iMaxInclusive = maxInclusive;
    }

    public int getIMinExclusive() {
        return this.iMinExclusive;
    }

    public void setIMinExclusive(int minExclusive) {
        this.iMinExclusive = minExclusive;
    }

    public int getIMinInclusive() {
        return this.iMinInclusive;
    }

    public void setIMinInclusive(int minInclusive) {
        this.iMinInclusive = minInclusive;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public Element getList() {
        return this.list;
    }

    public void setList(Element list) {
        this.list = list;
    }

    public Element getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Element restriction) {
        this.restriction = restriction;
    }

    public String[] getSEnumerationValues() {
        return this.sEnumerationValues;
    }

    public void setSEnumerationValues(String[] enumerationValues) {
        this.sEnumerationValues = enumerationValues;
    }

    public Element getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(Element simpleType) {
        this.simpleType = simpleType;
    }

    public Element getUnion() {
        return this.union;
    }

    public void setUnion(Element union) {
        this.union = union;
    }

    public String getId() {
        return this.id;
    }

    public STMLType[] getSubTypes() {
        return this.subTypes;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public String listDataType() {
        String s = " ... base " + this.base;
        s = s + " (java: " + this.javaType + ") ";
        if (this.isList) {
            s = s + " [" + (this.listLength >= 0 ? Integer.valueOf(this.listLength) : "*") + "]";
        }
        return s;
    }

    public static String getNormalizedValue(String value) {
        String dataType = null;
        if (value == null || value.trim().equals("") || value.equals("xsd:string")) {
            dataType = "xsd:string";
        } else if ((value = value.trim()).equals("xsd:integer")) {
            dataType = "xsd:integer";
        } else if (value.equals("xsd:float") || value.equals("fpx:real") || value.equals("xsd:double")) {
            dataType = "xsd:double";
        } else if (value.equals("xsd:date")) {
            dataType = "xsd:date";
        } else {
            throw new RuntimeException("Unknown data type: " + value);
        }
        return dataType;
    }
}

