/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.Canonicalizer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Util;
import org.xmlcml.xml.XMLConstants;

public abstract class XMLUtil
implements XMLConstants {
    private static Logger LOG = Logger.getLogger(XMLUtil.class);
    private static final String DOCTYPE = "\\<\\!DOCTYPE[^\\>]*\\>";
    public static final String DTD = ".dtd\">";
    private static final String DUMMY = "dummy";
    private static final String TEXT = "#text";

    public static final void checkPrefixedName(String name) {
        if (name == null || name.indexOf(":") < 1) {
            throw new RuntimeException("Unprefixed name (" + name + ")");
        }
    }

    public static String getPrefix(String s) {
        int idx = s.indexOf(":");
        return idx == -1 ? "" : s.substring(0, idx);
    }

    public static String getLocalName(String s) {
        String ss = null;
        if (s != null) {
            int idx = s.indexOf(":");
            ss = idx == -1 ? s : s.substring(idx + 1);
        }
        return ss;
    }

    public static String getSingleValue(Element element, String xpath, XPathContext xPathContext) {
        String s = null;
        if (element == null) {
            LOG.warn("Null element");
        } else {
            Nodes nodes = element.query(xpath, xPathContext);
            s = nodes.size() == 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static String getSingleValue(Element element, String xpath) {
        String s = null;
        if (element == null) {
            LOG.warn("Null element");
        } else {
            Nodes nodes = element.query(xpath);
            s = nodes.size() == 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static String getFirstValue(Element element, String xpath, XPathContext xPathContext) {
        String s = null;
        if (element == null) {
            LOG.warn("Null element");
        } else {
            Nodes nodes = element.query(xpath, xPathContext);
            s = nodes.size() >= 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static Element getSingleElement(Element element, String xpath, XPathContext xPathContext) {
        Nodes nodes = element.query(xpath, xPathContext);
        return nodes.size() == 1 ? (Element)nodes.get(0) : null;
    }

    public static final Object[] toArray(Elements elements, Object[] obj) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < elements.size(); ++i) {
            list.add(elements.get(i));
        }
        return list.toArray(obj);
    }

    public static void debug(Element el) {
        try {
            XMLUtil.debug(el, System.out, 2);
        }
        catch (IOException e2) {
            throw new RuntimeException("BUG " + e2);
        }
    }

    public static void debugToErr(Element el) {
        try {
            XMLUtil.debug(el, System.err, 2);
        }
        catch (IOException e2) {
            throw new RuntimeException("BUG " + e2);
        }
    }

    public static void debug(Element el, String message) {
        Util.println(">>>>" + message + ">>>>");
        XMLUtil.debug(el);
        Util.println("<<<<" + message + "<<<<");
    }

    public static void debug(Element el, OutputStream os, int indent) throws IOException {
        if (el != null) {
            Document document;
            ParentNode parent = el.getParent();
            if (parent instanceof Document) {
                document = (Document)parent;
            } else {
                Element copyElem = new Element(el);
                document = new Document(copyElem);
            }
            Serializer serializer = new Serializer(os, "UTF-8");
            if (indent >= 0) {
                serializer.setIndent(indent);
            }
            serializer.write(document);
        }
    }

    public static void debug(Element el, File file, int indent) throws IOException {
        if (file == null) {
            throw new RuntimeException("null file");
        }
        if (file.isDirectory()) {
            file.mkdirs();
        } else {
            file.getParentFile().mkdirs();
        }
        XMLUtil.debug(el, new FileOutputStream(file), indent);
    }

    public static void outputQuietly(Element elem, File file, int indent) {
        try {
            XMLUtil.debug(elem, new FileOutputStream(file), indent);
        }
        catch (Exception e2) {
            throw new RuntimeException("cannot write file:  " + file, e2);
        }
    }

    public static Document getXMLResource(String filename) throws IOException {
        Document document = null;
        InputStream in = null;
        try {
            in = Util.getInputStreamFromResource(filename);
            document = new Builder().build(in);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new RuntimeException("" + e3 + " in " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        return document;
    }

    public static List<Node> getChildNodes(Element el) {
        ArrayList<Node> childs = new ArrayList<Node>();
        if (el != null) {
            for (int i = 0; i < el.getChildCount(); ++i) {
                childs.add(el.getChild(i));
            }
        }
        return childs;
    }

    public static Element parseXML(String xmlString) throws RuntimeException {
        Element root2 = null;
        try {
            Document doc = new Builder().build(new StringReader(xmlString));
            root2 = doc.getRootElement();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return root2;
    }

    public static List<Node> getQueryNodes(Node node, String xpath, XPathContext context2) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (node != null) {
            Nodes nodes = node.query(xpath, context2);
            for (int i = 0; i < nodes.size(); ++i) {
                nodeList.add(nodes.get(i));
            }
        }
        return nodeList;
    }

    public static List<Node> getQueryNodes(Node node, String xpath) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (node != null && xpath != null) {
            try {
                Nodes nodes = node.query(xpath);
                for (int i = 0; i < nodes.size(); ++i) {
                    nodeList.add(nodes.get(i));
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("Bad xpath: " + xpath, e2);
            }
        }
        return nodeList;
    }

    public static List<Element> getQueryElements(Node node, String xpath) {
        List<Node> nodes = XMLUtil.getQueryNodes(node, xpath);
        return XMLUtil.castNodesToElements(nodes);
    }

    public static List<Element> getQueryElements(Node node, String xpath, XPathContext context2) {
        List<Node> nodes = XMLUtil.getQueryNodes(node, xpath, context2);
        return XMLUtil.castNodesToElements(nodes);
    }

    private static List<Element> castNodesToElements(List<Node> nodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node n : nodes) {
            if (!(n instanceof Element)) {
                return new ArrayList<Element>();
            }
            elements.add((Element)n);
        }
        return elements;
    }

    public static Node getFollowingSibling(Node current) {
        int index;
        ParentNode parent;
        Node node = null;
        if (current != null && (parent = current.getParent()) != null && (index = parent.indexOf(current)) + 1 < parent.getChildCount()) {
            node = parent.getChild(index + 1);
        }
        return node;
    }

    public static Node getPrecedingSibling(Node current) {
        int index;
        ParentNode parent;
        Node node = null;
        if (current != null && (parent = current.getParent()) != null && (index = parent.indexOf(current)) > 0) {
            node = parent.getChild(index - 1);
        }
        return node;
    }

    public static Text getLastTextDescendant(Node node) {
        List<Node> l = XMLUtil.getQueryNodes(node, ".//text() | self::text()");
        return l.size() == 0 ? null : (Text)l.get(l.size() - 1);
    }

    public static Text getFirstTextDescendant(Node node) {
        List<Node> l = XMLUtil.getQueryNodes(node, ".//text() | self::text()");
        return l.size() == 0 ? null : (Text)l.get(0);
    }

    public static void transferChildren(Element from, Element to) {
        int nc = from.getChildCount();
        int tc = to.getChildCount();
        for (int i = nc - 1; i >= 0; --i) {
            Node child = from.getChild(i);
            child.detach();
            to.insertChild(child, tc);
        }
    }

    public static void copyAttributes(Element from, Element to) throws IllegalArgumentException {
        if (to == null || from == null) {
            throw new IllegalArgumentException("cannot copy null elements");
        }
        int natt = from.getAttributeCount();
        for (int i = 0; i < natt; ++i) {
            Attribute newAtt = new Attribute(from.getAttribute(i));
            to.addAttribute(newAtt);
        }
    }

    public static String getCanonicalString(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Canonicalizer canon = new Canonicalizer(baos);
        try {
            canon.write(node);
        }
        catch (IOException e2) {
            throw new RuntimeException("should never throw " + e2);
        }
        return baos.toString();
    }

    public static void removeWhitespaceNodes(Element element) {
        int nChild = element.getChildCount();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < nChild; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if (node.getValue().trim().length() != 0) continue;
                nodeList.add(node);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            XMLUtil.removeWhitespaceNodes(childElement);
        }
        for (Node node : nodeList) {
            node.detach();
        }
    }

    public static void setXMLContent(Element element, String s) {
        List<Node> elements = XMLUtil.getQueryNodes(element, "*");
        if (elements.size() > 0) {
            throw new RuntimeException("Cannot set text with element children");
        }
        Text text = XMLUtil.getFirstTextDescendant(element);
        if (text == null) {
            text = new Text(s);
            element.appendChild(text);
        } else {
            text.setValue(s);
        }
    }

    public static String getXMLContent(Element element) {
        List<Node> elements = XMLUtil.getQueryNodes(element, "*");
        if (elements.size() > 0) {
            throw new RuntimeException("Cannot get text with element children");
        }
        return element.getValue();
    }

    public static String toXMLString(Element element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLUtil.debug(element, baos, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(baos.toByteArray());
    }

    public static void BUG(String message) {
        Util.BUG(message);
    }

    public static String makeId(String s) {
        String id = null;
        if (s != null) {
            id = s.toLowerCase();
            id = id.replace(" ", "_");
        }
        return id;
    }

    public static String makeAbstractName(String name) {
        return "Abstract" + XMLUtil.capitalize(name);
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String equalsCanonically(String refNodeXML, Element testElement, boolean stripWhite) {
        Element refElement = null;
        try {
            refElement = new Builder().build(new StringReader(refNodeXML)).getRootElement();
        }
        catch (Exception e2) {
            throw new RuntimeException("Parsing failed: " + refNodeXML);
        }
        String message = XMLUtil.equalsCanonically(refElement, testElement, stripWhite, "/");
        LOG.trace("EQCAN " + message);
        return message;
    }

    public static String equalsCanonically(Element refElement, Element testElement, boolean stripWhite) {
        return XMLUtil.equalsCanonically(refElement, testElement, stripWhite, "./");
    }

    public static String equalsCanonically(Element refElement, Element testElement, boolean stripWhite, String xpath) {
        String message = null;
        if (refElement != testElement) {
            if (stripWhite) {
                refElement = new Element(refElement);
                XMLUtil.removeWhitespaceNodes(refElement);
                testElement = new Element(testElement);
                XMLUtil.removeWhitespaceNodes(testElement);
            }
            xpath = xpath + "*[local-name()='" + refElement.getLocalName() + "']/";
            message = XMLUtil.equalsCanonically(refElement, testElement, xpath);
        }
        return message;
    }

    private static String equalsCanonically(Element refElement, Element testElement, String xpath) {
        String message = null;
        String refName = refElement.getLocalName();
        String testName = testElement.getLocalName();
        if (message == null && !refName.equals(testName)) {
            message = "element names differ at " + xpath + ": " + refName + " != " + testName;
        }
        String refNamespace = refElement.getNamespaceURI();
        String testNamespace = testElement.getNamespaceURI();
        if (message == null && !refNamespace.equals(testNamespace)) {
            message = "element namespaces differ at " + xpath + ": " + refNamespace + " != " + testNamespace;
        }
        if (message == null) {
            message = XMLUtil.compareAttributesCanonically(refElement, testElement, xpath);
        }
        if (message == null) {
            message = XMLUtil.compareChildNodesCanonically(refElement, testElement, xpath);
        }
        return message;
    }

    public static String equalsCanonically(File refFile, File testFile, boolean stripWhite) {
        String message = XMLUtil.isXMLFile(refFile);
        String string = message = message != null ? message : XMLUtil.isXMLFile(testFile);
        if (message == null) {
            try {
                Element refElement = XMLUtil.parseQuietlyToDocument(refFile).getRootElement();
                Element testElement = XMLUtil.parseQuietlyToDocument(testFile).getRootElement();
                message = XMLUtil.equalsCanonically(refElement, testElement, stripWhite);
            }
            catch (Exception e2) {
                message = e2.getMessage();
            }
        }
        return message;
    }

    public static String equalsCanonically(File refFile, Element testElement, boolean stripWhite) {
        String message = XMLUtil.isXMLFile(refFile);
        if (message == null) {
            try {
                Element refElement = XMLUtil.parseQuietlyToDocument(refFile).getRootElement();
                message = XMLUtil.equalsCanonically(refElement, testElement, stripWhite);
            }
            catch (Exception e2) {
                message = e2.getMessage();
            }
        }
        return message;
    }

    public static String isXMLFile(File file) {
        String message = null;
        if (file == null) {
            message = "null ref file";
        } else if (!file.exists()) {
            message = "non-existent ref file " + file;
        } else if (file.isDirectory()) {
            message = "ref file is directory " + file;
        }
        return message;
    }

    public static String getCommonLeadingString(String s1, String s2) {
        int i;
        int l = Math.min(s1.length(), s2.length());
        for (i = 0; i < l && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return s1.substring(0, i);
    }

    public static String compareNamespacesCanonically(Element refNode, Element testNode, String xpath) {
        String message = null;
        List<String> refNamespaceURIList = XMLUtil.getNamespaceURIList(refNode);
        List<String> testNamespaceURIList = XMLUtil.getNamespaceURIList(testNode);
        if (refNamespaceURIList.size() != testNamespaceURIList.size()) {
            message = "unequal namespace count; ref " + refNamespaceURIList.size() + "; " + refNamespaceURIList + "; testCount " + testNamespaceURIList.size() + "; " + testNamespaceURIList;
        } else {
            for (String refNamespaceURI : refNamespaceURIList) {
                if (testNamespaceURIList.contains(refNamespaceURI)) continue;
                message = "Cannot find " + refNamespaceURI + " in test namespaces ";
                break;
            }
        }
        return message;
    }

    private static List<String> getNamespaceURIList(Element node) {
        ArrayList<String> namespaceURIList = new ArrayList<String>();
        for (int i = 0; i < node.getNamespaceDeclarationCount(); ++i) {
            String prefix = node.getNamespacePrefix(i);
            String refNamespaceURI = node.getNamespaceURI(prefix);
            namespaceURIList.add(refNamespaceURI);
        }
        return namespaceURIList;
    }

    public static String compareAttributesCanonically(Element refNode, Element testNode, String xpath) {
        int testCount;
        String message = null;
        int refCount = refNode.getAttributeCount();
        if (refCount != (testCount = testNode.getAttributeCount())) {
            message = "unequal attribute count at " + xpath + " (" + refCount + " != " + testCount + ")";
        }
        if (message == null) {
            for (int i = 0; i < refCount; ++i) {
                String testValue;
                Attribute testAttribute;
                Attribute attribute = refNode.getAttribute(i);
                String name = attribute.getLocalName();
                String namespace2 = attribute.getNamespaceURI();
                String value = attribute.getValue();
                Attribute attribute2 = testAttribute = namespace2 == null ? testNode.getAttribute(name) : testNode.getAttribute(name, namespace2);
                if (testAttribute == null) {
                    message = "no attribute in test (" + xpath + ") for " + XMLUtil.printName(name, namespace2);
                    break;
                }
                String refValue = XMLUtil.normalizeSpace(value);
                if (refValue.equals(testValue = XMLUtil.normalizeSpace(testAttribute.getValue()))) continue;
                message = "normalized attribute values for (" + xpath + "@" + XMLUtil.printName(name, namespace2) + ") " + refValue + " != " + testValue;
                break;
            }
        }
        LOG.trace("ATT MS " + message);
        return message;
    }

    private static String printName(String name, String namespace2) {
        return name + (namespace2 == null || namespace2.equals("") ? "" : "[" + namespace2 + "]");
    }

    public static String normalizeSpace(String value) {
        return value.replaceAll("\\s+", " ").trim();
    }

    public static String compareChildNodesCanonically(Element refNode, Element testNode, String xpath) {
        int testCount;
        String message = null;
        int refCount = refNode.getChildCount();
        if (refCount != (testCount = testNode.getChildCount())) {
            message = "unequal child node count at " + xpath + " (" + refCount + " != " + testCount + ")";
        }
        if (message == null) {
            for (int i = 0; i < refCount; ++i) {
                Class<?> testClass;
                String xpathChild = xpath + "node()[position()=" + (i + 1) + "]";
                Node refChildNode = refNode.getChild(i);
                Node testChildNode = testNode.getChild(i);
                Class<?> refClass = refChildNode.getClass();
                if (!refClass.equals(testClass = testChildNode.getClass())) {
                    message = "child node classes differ at " + xpathChild + " " + refClass + "/" + testClass;
                    break;
                }
                if (refChildNode instanceof Element) {
                    message = XMLUtil.equalsCanonically((Element)refChildNode, (Element)testChildNode, xpathChild);
                    continue;
                }
                message = XMLUtil.compareNonElementNodesCanonically(refChildNode, testChildNode, xpath);
                if (message != null) break;
            }
        }
        return message;
    }

    public static String compareNonElementNodesCanonically(Node refNode, Node testNode, String xpath) {
        String message = null;
        String refValue = refNode.getValue();
        String testValue = testNode.getValue();
        if (refNode instanceof Comment) {
            if (!refValue.equals(testValue)) {
                message = "comments at (" + xpath + ") differ: " + refValue + " != " + testValue;
            }
        } else if (refNode instanceof Text) {
            if (!refValue.equals(testValue)) {
                message = "text contents at (" + xpath + ") differ: [" + refValue + "] != [" + testValue + "]";
            }
        } else if (refNode instanceof ProcessingInstruction) {
            String testTarget;
            String refTarget = ((ProcessingInstruction)refNode).getTarget();
            if (!refTarget.equals(testTarget = ((ProcessingInstruction)testNode).getTarget())) {
                message = "PI targets at (" + xpath + ") differ: " + refTarget + " != " + testTarget;
            }
        } else {
            LOG.warn("Unknown XML element in comparison: " + refNode.getClass());
        }
        return message;
    }

    public static void stripTrailingWhitespaceinTexts(Element element) {
        Nodes texts = element.query("//text()");
        for (int i = 0; i < texts.size(); ++i) {
            Text text = (Text)texts.get(i);
            String value = text.getValue();
            value = Util.rightTrim(value);
            text.setValue(value);
        }
    }

    public static Element getSingleElement(Element element, String xpath) {
        Nodes nodes = element.query(xpath);
        return nodes.size() == 1 ? (Element)nodes.get(0) : null;
    }

    public static void detach(Element element) {
        ParentNode parent;
        ParentNode parentNode = parent = element == null ? null : element.getParent();
        if (parent != null) {
            if (parent instanceof Document) {
                parent.replaceChild(element, new Element(DUMMY));
            } else {
                element.detach();
            }
        }
    }

    public static Document ensureDocument(Element element) {
        Document doc = null;
        if (element != null && (doc = element.getDocument()) == null) {
            Element parent = null;
            Element root2 = element;
            while ((parent = (Element)root2.getParent()) != null) {
                root2 = parent;
            }
            doc = new Document(root2);
        }
        return doc;
    }

    public static Document parseQuietlyToDocument(InputStream is) {
        Document document = null;
        try {
            document = new Builder().build(is);
        }
        catch (Exception e2) {
            throw new RuntimeException("cannot parse/read stream: ", e2);
        }
        return document;
    }

    public static Document parseResourceQuietlyToDocument(String resource) {
        Document document = null;
        try {
            document = new Builder().build(Util.getInputStreamFromResource(resource));
        }
        catch (Exception e2) {
            throw new RuntimeException("cannot parse/read resource: " + resource, e2);
        }
        return document;
    }

    public static Document parseQuietlyToDocument(File xmlFile) {
        Document document = null;
        try {
            document = new Builder().build(xmlFile);
        }
        catch (Exception e2) {
            throw new RuntimeException("cannot parse/read file: " + xmlFile.getAbsolutePath(), e2);
        }
        return document;
    }

    @Deprecated
    public static Document stripDTDAndOtherProblematicXMLHeadings(String s) throws IOException {
        Document document;
        if (s == null || s.length() == 0) {
            throw new RuntimeException("zero length document");
        }
        int idx = s.indexOf(DTD);
        String baosS = s;
        if (idx != -1) {
            int ld = idx + DTD.length() + 1;
            if (ld < 0) {
                throw new RuntimeException("BUG in stripping DTD");
            }
            try {
                baosS = s.substring(ld);
            }
            catch (Exception e2) {
                throw new RuntimeException("cannot parse string: (" + s.length() + "/" + ld + "/" + idx + ") " + s.substring(0, Math.min(500, s.length())), e2);
            }
        }
        baosS = baosS.replace(" xmlns=\"http://www.w3.org/1999/xhtml\"", "");
        baosS = baosS.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        baosS = XMLUtil.removeScripts(baosS);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baosS.getBytes());
            document = new Builder().build(bais);
        }
        catch (Exception e3) {
            throw new RuntimeException("BUG: DTD stripper failed to create valid XML", e3);
        }
        return document;
    }

    public static String stripDTD(String s) {
        if (s != null) {
            s = s.replaceAll(DOCTYPE, "");
        }
        return s;
    }

    public static Element stripDTDAndParse(String s) {
        Element root2 = null;
        if (s != null) {
            s = XMLUtil.stripDTD(s);
            root2 = XMLUtil.parseXML(s);
        }
        return root2;
    }

    public static String addMissingEndTags(String s, String tag) {
        s = s.replaceAll(">\\s*</" + tag + ">", "/>");
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        boolean inTag = false;
        String start = "<" + tag;
        int stl = start.length();
        while (i < sb.length()) {
            if (i < sb.length() - stl && start.equals(sb.substring(i, i + stl))) {
                inTag = true;
                i += stl;
                continue;
            }
            if (inTag && sb.charAt(i) == '>') {
                if (sb.charAt(i - 1) != '/') {
                    sb.insert(i, '/');
                    ++i;
                }
                ++i;
                inTag = false;
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeScripts(String s) {
        return XMLUtil.removeTags("script", s);
    }

    public static String removeTags(String tag, String ss) {
        int current = 0;
        StringBuilder sb = new StringBuilder();
        String startTag = "<" + tag;
        String endTag = "</" + tag + ">";
        while (true) {
            int i;
            if ((i = ss.indexOf(startTag, current)) == -1) break;
            sb.append(ss.substring(current, i));
            i = ss.indexOf(endTag, current);
            if (i == -1) {
                throw new RuntimeException("missing endTag: " + endTag);
            }
            current = i + endTag.length();
        }
        sb.append(ss.substring(current));
        return sb.toString();
    }

    public static void debugPreserveWhitespace(Element element) {
        try {
            XMLUtil.debug(element, System.out, 0);
        }
        catch (Exception e2) {
            throw new RuntimeException("BUG", e2);
        }
    }

    public static Element normalizeWhitespaceInTextNodes(Element element) {
        Nodes texts = element.query(".//text()");
        for (int i = 0; i < texts.size(); ++i) {
            Text text = (Text)texts.get(i);
            text.setValue(XMLUtil.normalizeSpace(text.getValue()));
        }
        return element;
    }

    public static void copyAttributesFromTo(Element from, Element to) {
        int natt = from.getAttributeCount();
        for (int i = 0; i < natt; ++i) {
            Attribute newAtt = new Attribute(from.getAttribute(i));
            to.addAttribute(newAtt);
        }
    }

    public static void deleteAttribute(Element element, String attName) {
        Attribute att = element.getAttribute(attName);
        if (att != null) {
            att.detach();
        }
    }

    public static Document parseQuietlyToDocumentWithoutDTD(File file) {
        Document doc = null;
        try {
            String s = IOUtils.toString(new FileInputStream(file));
            doc = XMLUtil.stripDTDAndOtherProblematicXMLHeadings(s);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return doc;
    }

    public static void checkAttributeNames(Element element, List<String> allowedAttributeNames) {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            String attributeName = element.getAttribute(i).getLocalName();
            if (allowedAttributeNames.contains(attributeName)) continue;
            throw new RuntimeException("Unknown attribute: " + attributeName + " in element: " + element.getLocalName());
        }
    }

    public static void checkChildElementNames(Element element, List<String> allowedChildNodeNames) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            String elementName;
            Node childNode = element.getChild(i);
            if (childNode instanceof Text) {
                if (childNode.getValue().trim().length() <= 0 || allowedChildNodeNames.contains(TEXT)) continue;
                continue;
            }
            if (!(childNode instanceof Element) || allowedChildNodeNames.contains(elementName = element.getAttribute(i).getLocalName())) continue;
            throw new RuntimeException("Unknown element: " + elementName + " in element: " + element.getLocalName());
        }
    }
}

