/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.xml;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class XPathGenerator {
    private static final Logger LOG = Logger.getLogger(XPathGenerator.class);
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String TAGX = "tagx";
    private static final String[] TAGS;
    private Element xmlElement;
    private boolean shortFlag = false;

    public XPathGenerator(Element xmlElement) {
        this.xmlElement = xmlElement;
    }

    public void setShort(boolean shortFlag) {
        this.shortFlag = shortFlag;
    }

    public String getXPath() {
        StringBuilder sb = new StringBuilder();
        this.addAncestors(sb, this.xmlElement);
        return sb.toString();
    }

    private void addAncestors(StringBuilder sb, Element element) {
        if (element == null) {
            return;
        }
        String name = element.getLocalName();
        String el = element.toXML();
        StringBuilder sb1 = new StringBuilder();
        sb1.append(this.shortFlag ? "/" + name : "/*[local-name()='" + name + "']");
        Attribute attribute = this.getFirstUsefulAttribute(element);
        attribute = null;
        if (attribute != null) {
            sb1.append("[@" + attribute.getLocalName() + "='" + attribute.getValue() + "']");
        } else {
            int ordinal = this.getOrdinalOfChildWithName(element, name);
            sb1.append("[" + ordinal + "]");
        }
        String ss = sb1.toString();
        sb.insert(0, ss);
        ParentNode parent = element.getParent();
        if (parent != null && parent instanceof Element) {
            this.addAncestors(sb, (Element)parent);
        }
    }

    private int getOrdinalOfChildWithName(Element element, String name) {
        int ordinal = 1;
        ParentNode parent = element.getParent();
        if (parent != null) {
            int position = parent.indexOf(element);
            for (int i = 0; i < position; ++i) {
                Node sibling = parent.getChild(i);
                if (!(sibling instanceof Element) || !name.equals(((Element)sibling).getLocalName())) continue;
                ++ordinal;
            }
        }
        return ordinal;
    }

    private Attribute getFirstUsefulAttribute(Element element) {
        for (String tag : TAGS) {
            Attribute attribute = element.getAttribute(tag);
            if (attribute == null || attribute.getValue().trim().length() <= 0) continue;
            return attribute;
        }
        return null;
    }

    static {
        LOG.setLevel(Level.DEBUG);
        TAGS = new String[]{ID, NAME, TAGX};
    }
}

