/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Element;

public final class AtomBuilder {
    private final Element element;
    private int isotope = -1;
    private int hCount = 0;
    private int charge = 0;
    private int atomClass = 0;
    private boolean aromatic;

    private AtomBuilder(Element element, boolean aromatic) {
        this.element = element;
        this.aromatic = aromatic;
    }

    public static AtomBuilder fromExisting(Atom a) {
        if (a == null) {
            throw new NullPointerException("no atom provided");
        }
        return new AtomBuilder(a.element(), a.aromatic()).charge(a.charge()).hydrogens(a.hydrogens()).isotope(a.isotope()).atomClass(a.atomClass());
    }

    public static AtomBuilder aliphatic(Element e2) {
        if (e2 == null) {
            throw new NullPointerException("no element provided");
        }
        return new AtomBuilder(e2, false);
    }

    public static AtomBuilder aromatic(Element e2) {
        if (e2 == null) {
            throw new NullPointerException("no element provided");
        }
        if (e2 == Element.Unknown) {
            return new AtomBuilder(e2, false);
        }
        if (!e2.aromatic(Element.AromaticSpecification.General)) {
            throw new IllegalArgumentException("The element '" + (Object)((Object)e2) + "' cannot be aromatic by the Daylight specification.");
        }
        return new AtomBuilder(e2, true);
    }

    public static AtomBuilder aliphatic(String symbol) {
        if (symbol == null) {
            throw new NullPointerException("no symbol provided");
        }
        return AtomBuilder.aliphatic(AtomBuilder.ofSymbolOrUnknown(symbol));
    }

    public static AtomBuilder aromatic(String symbol) {
        if (symbol == null) {
            throw new NullPointerException("no symbol provided");
        }
        return AtomBuilder.aromatic(AtomBuilder.ofSymbolOrUnknown(symbol));
    }

    public static AtomBuilder create(String symbol) {
        Element e2 = AtomBuilder.ofSymbolOrUnknown(symbol);
        if (symbol != null && !symbol.isEmpty() && Character.isLowerCase(symbol.charAt(0))) {
            if (!e2.aromatic()) {
                throw new IllegalArgumentException("Attempting to create an aromatic atom for an element which cannot be aromatic");
            }
            return new AtomBuilder(e2, true);
        }
        return new AtomBuilder(e2, false);
    }

    private static Element ofSymbolOrUnknown(String symbol) {
        Element e2 = Element.ofSymbol(symbol);
        return e2 != null ? e2 : Element.Unknown;
    }

    public AtomBuilder hydrogens(int hCount) {
        if (hCount < 0) {
            throw new IllegalArgumentException("the number of hydrogens must be positive");
        }
        this.hCount = hCount;
        return this;
    }

    public AtomBuilder charge(int charge) {
        this.charge = charge;
        return this;
    }

    public AtomBuilder anion() {
        return this.charge(-1);
    }

    public AtomBuilder cation() {
        return this.charge(1);
    }

    public AtomBuilder isotope(int isotope) {
        this.isotope = isotope;
        return this;
    }

    public AtomBuilder atomClass(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("atom class must be positive");
        }
        this.atomClass = c;
        return this;
    }

    public Atom build() {
        return new AtomImpl.BracketAtom(this.isotope, this.element, this.hCount, this.charge, this.atomClass, this.aromatic);
    }

    public static Atom explicitHydrogen() {
        return AtomImpl.EXPLICIT_HYDROGEN;
    }
}

