/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class ImplicitToExplicit
extends AbstractFunction<Graph, Graph> {
    ImplicitToExplicit() {
    }

    @Override
    public Graph apply(Graph g) {
        int u;
        Graph h = new Graph(g.order());
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            for (Edge e2 : g.edges(u)) {
                if (e2.other(u) <= u) continue;
                h.addEdge(ImplicitToExplicit.toExplicitEdge(g, e2));
            }
        }
        return h;
    }

    static Edge toExplicitEdge(Graph g, Edge e2) {
        int u = e2.either();
        int v = e2.other(u);
        if (e2.bond() == Bond.IMPLICIT) {
            return new Edge(u, v, ImplicitToExplicit.type(g.atom(u), g.atom(v)));
        }
        return e2;
    }

    static Bond type(Atom u, Atom v) {
        return u.aromatic() && v.aromatic() ? Bond.AROMATIC : Bond.SINGLE;
    }
}

