/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class NormaliseDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    NormaliseDirectionalLabels() {
    }

    @Override
    public Graph apply(Graph g) {
        int u;
        Traversal traversal = new Traversal(g);
        Graph h = new Graph(g.order());
        h.addFlags(g.getFlags(-1));
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e2 = g.edgeAt(u, j);
                if (e2.other(u) <= u) continue;
                if (traversal.acc.containsKey(e2)) {
                    h.addEdge((Edge)traversal.acc.get(e2));
                    continue;
                }
                h.addEdge(e2);
            }
        }
        return h.sort(new Graph.CanOrderFirst());
    }

    private static final class Traversal {
        private final Graph g;
        private final boolean[] visited;
        private final int[] ordering;
        private int i;
        private Map<Edge, Edge> acc = new HashMap<Edge, Edge>();
        private List<Edge> doubleBonds = new ArrayList<Edge>();
        private Set<Integer> adj = new HashSet<Integer>();

        private Traversal(Graph g) {
            this.g = g;
            this.visited = new boolean[g.order()];
            this.ordering = new int[g.order()];
            BitSet dbAtoms = new BitSet();
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u]) continue;
                dbAtoms.or(this.visit(u, u));
            }
            Collections.sort(this.doubleBonds, new Comparator<Edge>(){

                @Override
                public int compare(Edge e2, Edge f) {
                    int min2;
                    int u1 = e2.either();
                    int v1 = e2.other(u1);
                    int u2 = f.either();
                    int v2 = f.other(u2);
                    int min1 = Math.min(Traversal.this.ordering[u1], Traversal.this.ordering[v1]);
                    int cmp = min1 - (min2 = Math.min(Traversal.this.ordering[u2], Traversal.this.ordering[v2]));
                    if (cmp != 0) {
                        return cmp;
                    }
                    int max1 = Math.max(Traversal.this.ordering[u1], Traversal.this.ordering[v1]);
                    int max2 = Math.max(Traversal.this.ordering[u2], Traversal.this.ordering[v2]);
                    return max1 - max2;
                }
            });
            for (Edge e2 : this.doubleBonds) {
                if (this.acc.containsKey(e2)) continue;
                this.flip(g, e2, dbAtoms);
            }
        }

        private BitSet visit(int p, int u) {
            this.visited[u] = true;
            ++this.i;
            BitSet dbAtoms = new BitSet();
            int d = this.g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e2 = this.g.edgeAt(u, j);
                int v = e2.other(u);
                if (v == p) continue;
                if (e2.bond().order() == 2 && this.hasAdjDirectionalLabels(this.g, e2)) {
                    dbAtoms.set(u);
                    dbAtoms.set(v);
                    boolean newSystem = !this.adj.contains(u) && !this.adj.contains(v);
                    int d2 = this.g.degree(u);
                    for (int j2 = 0; j2 < d2; ++j2) {
                        this.adj.add(this.g.edgeAt(u, j2).other(u));
                    }
                    int d3 = this.g.degree(v);
                    for (int j2 = 0; j2 < d3; ++j2) {
                        this.adj.add(this.g.edgeAt(v, j2).other(v));
                    }
                    this.doubleBonds.add(e2);
                }
                if (this.visited[v]) continue;
                dbAtoms.or(this.visit(u, v));
            }
            return dbAtoms;
        }

        private boolean hasAdjDirectionalLabels(Graph g, Edge e2) {
            int u = e2.either();
            int v = e2.other(u);
            return this.hasAdjDirectionalLabels(g, u) && this.hasAdjDirectionalLabels(g, v);
        }

        private boolean hasAdjDirectionalLabels(Graph g, int u) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f = g.edgeAt(u, j);
                if (!f.bond().directional()) continue;
                return true;
            }
            return false;
        }

        private void flip(Graph g, Edge e2, BitSet dbAtoms) {
            int v;
            int u = e2.either();
            if (this.ordering[u] < this.ordering[v = e2.other(u)]) {
                Edge first = this.firstDirectionalLabel(g, u);
                if (first != null) {
                    this.flip(first, u, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, v);
                    this.flip(first, v, dbAtoms);
                }
            } else {
                Edge first = this.firstDirectionalLabel(g, v);
                if (first != null) {
                    this.flip(first, v, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, u);
                    this.flip(first, u, dbAtoms);
                }
            }
        }

        private void flip(Edge first, int u, BitSet dbAtoms) {
            if (this.ordering[first.other(u)] < this.ordering[u]) {
                if (first.bond(u) == Bond.UP) {
                    this.invertExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
                } else {
                    this.markExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
                }
            } else if (first.bond(u) == Bond.DOWN) {
                this.invertExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
            } else {
                this.markExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
            }
        }

        Edge firstDirectionalLabel(Graph g, int u) {
            Edge first = null;
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f = g.edgeAt(u, j);
                if (f.bond() != Bond.UP && f.bond() != Bond.DOWN || first != null && this.ordering[f.other(u)] >= this.ordering[first.other(u)]) continue;
                first = f;
            }
            return first;
        }

        private void invertExistingDirectionalLabels(Graph g, int prev, BitSet visited, Map<Edge, Edge> replacement, BitSet dbAtoms, int u) {
            visited.set(u);
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f;
                Edge e2 = g.edgeAt(u, j);
                int v = e2.other(u);
                if (v == prev || (f = replacement.get(e2)) != null) continue;
                replacement.put(e2, e2.inverse());
                if (visited.get(v) || !dbAtoms.get(v)) continue;
                this.invertExistingDirectionalLabels(g, u, visited, replacement, dbAtoms, v);
            }
        }

        private void markExistingDirectionalLabels(Graph g, int prev, BitSet visited, Map<Edge, Edge> replacement, BitSet dbAtoms, int u) {
            visited.set(u);
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f;
                Edge e2 = g.edgeAt(u, j);
                int v = e2.other(u);
                if (v == prev || (f = replacement.get(e2)) != null) continue;
                replacement.put(e2, e2);
                if (visited.get(v) || !dbAtoms.get(v)) continue;
                this.markExistingDirectionalLabels(g, u, visited, replacement, dbAtoms, v);
            }
        }
    }
}

