/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class RemoveUpDownBonds
extends AbstractFunction<Graph, Graph> {
    RemoveUpDownBonds() {
    }

    @Override
    public Graph apply(Graph g) throws InvalidSmilesException {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        int[] ordering = new DepthFirstOrder(g).visited;
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        TreeSet<Integer> dbCentres = new TreeSet<Integer>();
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e2 : g.edges(u)) {
                if (e2.other(u) <= u || e2.bond() != Bond.DOUBLE) continue;
                this.removeRedundant(g, e2, ordering, replacements);
                dbCentres.add(u);
                dbCentres.add(e2.other(u));
            }
        }
        for (Edge e3 : new HashSet(replacements.keySet())) {
            if (!dbCentres.contains(e3.either()) || !dbCentres.contains(e3.other(e3.either()))) continue;
            replacements.remove(e3);
        }
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e2 : g.edges(u)) {
                if (e2.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e2);
                if (replacement != null) {
                    e2 = replacement;
                }
                h.addEdge(e2);
            }
        }
        return h;
    }

    private void removeRedundant(Graph g, Edge e2, int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int u = e2.either();
        int v = e2.other(u);
        this.replaceImplWithExpl(g, e2, u, ordering, acc);
        this.replaceImplWithExpl(g, e2, v, ordering, acc);
    }

    private void replaceImplWithExpl(Graph g, Edge e2, final int u, final int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        TreeSet<Edge> edges = new TreeSet<Edge>(Collections.reverseOrder(new Comparator<Edge>(){

            @Override
            public int compare(Edge e2, Edge f) {
                int w;
                int v = ordering[e2.other(u)];
                if (v > (w = ordering[f.other(u)])) {
                    return 1;
                }
                if (v < w) {
                    return -1;
                }
                return 0;
            }
        }));
        for (Edge f : g.edges(u)) {
            switch (f.bond()) {
                case DOUBLE: {
                    if (f.equals(e2)) break;
                    return;
                }
                case UP: 
                case DOWN: {
                    edges.add(f);
                }
            }
        }
        if (edges.size() == 2) {
            Iterator it = edges.iterator();
            Edge explicit = (Edge)it.next();
            int v = explicit.either();
            int w = explicit.other(v);
            acc.put(explicit, new Edge(v, w, Bond.IMPLICIT));
        } else if (edges.size() > 2) {
            throw new InvalidSmilesException("Too many up/down bonds on double bonded atom");
        }
    }

    private static final class DepthFirstOrder {
        private final Graph g;
        private final int[] visited;
        private int i;

        private DepthFirstOrder(Graph g) {
            this.g = g;
            this.visited = new int[g.order()];
            Arrays.fill(this.visited, -1);
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u] >= 0) continue;
                this.visit(u);
            }
        }

        private void visit(int u) {
            ++this.i;
            for (Edge e2 : this.g.edges(u)) {
                int v = e2.other(u);
                if (this.visited[v] >= 0) continue;
                this.visit(v);
            }
        }
    }
}

