/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

abstract class Topology {
    private static Topology UNKNOWN = new Topology(){

        @Override
        int atom() {
            throw new IllegalArgumentException("unknown topology");
        }

        @Override
        Configuration configuration() {
            return Configuration.UNKNOWN;
        }

        @Override
        Topology orderBy(int[] rank) {
            return this;
        }

        @Override
        Topology transform(int[] mapping) {
            return this;
        }

        @Override
        void copy(int[] dest) {
        }
    };
    private static final int A = 0;
    private static final int B = 1;
    private static final int C = 2;
    private static final int D = 3;
    private static final int E = 4;
    private static final int F = 5;

    Topology() {
    }

    abstract int atom();

    abstract Configuration configuration();

    Configuration configurationOf(int[] rank) {
        Topology topology = this.orderBy(rank);
        return topology != null ? topology.configuration() : Configuration.UNKNOWN;
    }

    Configuration.Type type() {
        return this.configuration().type();
    }

    abstract Topology orderBy(int[] var1);

    abstract Topology transform(int[] var1);

    abstract void copy(int[] var1);

    static int parity(int[] vs, int[] rank) {
        int count = 0;
        for (int i = 0; i < vs.length; ++i) {
            for (int j = i + 1; j < vs.length; ++j) {
                if (rank[vs[i]] <= rank[vs[j]]) continue;
                ++count;
            }
        }
        return count & true ? -1 : 1;
    }

    static int parity4(int[] vs, int[] rank) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            int prev = rank[vs[i]];
            for (int j = i + 1; j < 4; ++j) {
                if (prev <= rank[vs[j]]) continue;
                ++count;
            }
        }
        return count & true ? -1 : 1;
    }

    static int[] sort(int[] vs, int[] rank) {
        int i;
        int[] ws = Arrays.copyOf(vs, vs.length);
        int j = i = 0;
        while (i < vs.length - 1) {
            int v = ws[i + 1];
            while (rank[v] < rank[ws[j]]) {
                ws[j + 1] = ws[j];
                if (--j >= 0) continue;
            }
            ws[j + 1] = v;
            j = ++i;
        }
        return ws;
    }

    static Topology unknown() {
        return UNKNOWN;
    }

    static Topology tetrahedral(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.Tetrahedral) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new Tetrahedral(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Topology extendedTetrahedral(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.ExtendedTetrahedral) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid extended tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new ExtendedTetrahedral(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Topology trigonal(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.DoubleBond) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new Trigonal(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Topology squarePlanar(int u, int[] vs, Configuration configuration) {
        switch (configuration) {
            case SP1: {
                return new SquarePlanar(u, Arrays.copyOf(vs, vs.length), 1);
            }
            case SP2: {
                return new SquarePlanar(u, Arrays.copyOf(vs, vs.length), 2);
            }
            case SP3: {
                return new SquarePlanar(u, Arrays.copyOf(vs, vs.length), 3);
            }
        }
        return null;
    }

    private static Topology trigonalBipyramidal(int u, int[] vs, Configuration c) {
        if (Configuration.TB1.ordinal() <= c.ordinal() && Configuration.TB20.ordinal() >= c.ordinal()) {
            int order = 1 + c.ordinal() - Configuration.TB1.ordinal();
            return new TrigonalBipyramidal(u, vs, order);
        }
        return null;
    }

    private static Topology octahedral(int u, int[] vs, Configuration c) {
        if (Configuration.OH1.ordinal() <= c.ordinal() && Configuration.OH30.ordinal() >= c.ordinal()) {
            int order = 1 + c.ordinal() - Configuration.OH1.ordinal();
            return new Octahedral(u, vs, order);
        }
        return null;
    }

    static Configuration toExplicit(Graph g, int u, Configuration c) {
        if (c.type() != Configuration.Type.Implicit) {
            return c;
        }
        int deg = g.degree(u);
        int valence = deg + g.atom(u).hydrogens();
        if (valence == 4) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
        }
        if (valence == 3) {
            if (g.atom(u).element() == Element.Sulfur || g.atom(u).element() == Element.Selenium) {
                int sb = 0;
                int db = 0;
                int d = g.degree(u);
                for (int j = 0; j < d; ++j) {
                    Edge e2 = g.edgeAt(u, j);
                    if (e2.bond().order() == 1) {
                        ++sb;
                        continue;
                    }
                    if (e2.bond().order() == 2) {
                        ++db;
                        continue;
                    }
                    return Configuration.UNKNOWN;
                }
                int q = g.atom(u).charge();
                if (q == 0 && sb == 2 && db == 1 || q == 1 && sb == 3) {
                    return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
                }
                return Configuration.UNKNOWN;
            }
            if ((g.atom(u).element() == Element.Phosphorus || g.atom(u).element() == Element.Nitrogen) && g.bondedValence(u) == 3 && g.implHCount(u) == 0 && g.atom(u).charge() == 0) {
                return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
            }
            int nDoubleBonds = 0;
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e3 = g.edgeAt(u, j);
                if (e3.bond() != Bond.DOUBLE) continue;
                ++nDoubleBonds;
            }
            if (nDoubleBonds == 1) {
                return c == Configuration.ANTI_CLOCKWISE ? Configuration.DB1 : Configuration.DB2;
            }
            return Configuration.UNKNOWN;
        }
        if (deg == 2) {
            int nDoubleBonds = 0;
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e4 = g.edgeAt(u, j);
                if (e4.bond() == Bond.DOUBLE) continue;
                ++nDoubleBonds;
            }
            if (nDoubleBonds == 1) {
                return c == Configuration.ANTI_CLOCKWISE ? Configuration.DB1 : Configuration.DB2;
            }
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.AL1 : Configuration.AL2;
        }
        if (valence == 5) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.TB1 : Configuration.TB2;
        }
        if (valence == 6) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.OH1 : Configuration.OH2;
        }
        return Configuration.UNKNOWN;
    }

    static Topology create(int u, int[] vs, List<Edge> es, Configuration c) {
        if (c.type() == Configuration.Type.Implicit) {
            throw new IllegalArgumentException("configuration must be explicit, @TH1/@TH2 instead of @/@@");
        }
        if (c.type() == Configuration.Type.Tetrahedral) {
            return Topology.tetrahedral(u, vs, c);
        }
        if (c.type() == Configuration.Type.DoubleBond) {
            return Topology.trigonal(u, vs, c);
        }
        if (c.type() == Configuration.Type.ExtendedTetrahedral) {
            return Topology.extendedTetrahedral(u, vs, c);
        }
        if (c.type() == Configuration.Type.SquarePlanar) {
            return Topology.squarePlanar(u, vs, c);
        }
        if (c.type() == Configuration.Type.TrigonalBipyramidal) {
            return Topology.trigonalBipyramidal(u, vs, c);
        }
        if (c.type() == Configuration.Type.Octahedral) {
            return Topology.octahedral(u, vs, c);
        }
        return Topology.unknown();
    }

    private static boolean check(int[] dest, int[] src, int[] perm, int step, int skip) {
        int i = 0;
        while (i < perm.length) {
            int j;
            for (j = 0; j < step && dest[perm[i + j]] == src[j]; ++j) {
            }
            if (j == 0) {
                i += skip * step;
                continue;
            }
            if (j == step) {
                return true;
            }
            i += step;
        }
        return false;
    }

    private static void swap(int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private static void indirectSort(int[] dst, int[] rank) {
        for (int i = 0; i < dst.length; ++i) {
            for (int j = i; j > 0 && rank[dst[j - 1]] > rank[dst[j]]; --j) {
                Topology.swap(dst, j, j - 1);
            }
        }
    }

    private static int[] applyInv(int[] src, int[] perm) {
        int[] res = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[perm[i]];
        }
        return res;
    }

    private static Integer[] toObjArray(int[] arr) {
        Integer[] res = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    private static int[] toIntArray(Integer[] arr) {
        int[] res = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    private static final class Trigonal
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private Trigonal(int u, int[] vs, int p) {
            if (vs.length != 3) {
                throw new IllegalArgumentException("Trigonal topology requires 3 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.DB1 : Configuration.DB2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new Trigonal(this.u, Trigonal.sort(this.vs, rank), this.p * Trigonal.parity(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new Trigonal(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 3);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }

    private static final class Octahedral
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int order;
        private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 4, 5, 0, 2, 3, 4, 1, 5, 0, 3, 4, 1, 2, 5, 0, 4, 1, 2, 3, 5, 1, 0, 4, 5, 2, 3, 1, 2, 0, 4, 5, 3, 1, 4, 5, 2, 0, 3, 1, 5, 2, 0, 4, 3, 2, 0, 1, 5, 3, 4, 2, 1, 5, 3, 0, 4, 2, 3, 0, 1, 5, 4, 2, 5, 3, 0, 1, 4, 3, 0, 2, 5, 4, 1, 3, 2, 5, 4, 0, 1, 3, 4, 0, 2, 5, 1, 3, 5, 4, 0, 2, 1, 4, 0, 3, 5, 1, 2, 4, 1, 0, 3, 5, 2, 4, 3, 5, 1, 0, 2, 4, 5, 1, 0, 3, 2, 5, 1, 4, 3, 2, 0, 5, 2, 1, 4, 3, 0, 5, 3, 2, 1, 4, 0, 5, 4, 3, 2, 1, 0}, {0, 1, 4, 3, 2, 5, 0, 2, 1, 4, 3, 5, 0, 3, 2, 1, 4, 5, 0, 4, 3, 2, 1, 5, 1, 0, 2, 5, 4, 3, 1, 2, 5, 4, 0, 3, 1, 4, 0, 2, 5, 3, 1, 5, 4, 0, 2, 3, 2, 0, 3, 5, 1, 4, 2, 1, 0, 3, 5, 4, 2, 3, 5, 1, 0, 4, 2, 5, 1, 0, 3, 4, 3, 0, 4, 5, 2, 1, 3, 2, 0, 4, 5, 1, 3, 4, 5, 2, 0, 1, 3, 5, 2, 0, 4, 1, 4, 0, 1, 5, 3, 2, 4, 1, 5, 3, 0, 2, 4, 3, 0, 1, 5, 2, 4, 5, 3, 0, 1, 2, 5, 1, 2, 3, 4, 0, 5, 2, 3, 4, 1, 0, 5, 3, 4, 1, 2, 0, 5, 4, 1, 2, 3, 0}, {0, 1, 2, 3, 5, 4, 0, 2, 3, 5, 1, 4, 0, 3, 5, 1, 2, 4, 0, 5, 1, 2, 3, 4, 1, 0, 5, 4, 2, 3, 1, 2, 0, 5, 4, 3, 1, 4, 2, 0, 5, 3, 1, 5, 4, 2, 0, 3, 2, 0, 1, 4, 3, 5, 2, 1, 4, 3, 0, 5, 2, 3, 0, 1, 4, 5, 2, 4, 3, 0, 1, 5, 3, 0, 2, 4, 5, 1, 3, 2, 4, 5, 0, 1, 3, 4, 5, 0, 2, 1, 3, 5, 0, 2, 4, 1, 4, 1, 5, 3, 2, 0, 4, 2, 1, 5, 3, 0, 4, 3, 2, 1, 5, 0, 4, 5, 3, 2, 1, 0, 5, 0, 3, 4, 1, 2, 5, 1, 0, 3, 4, 2, 5, 3, 4, 1, 0, 2, 5, 4, 1, 0, 3, 2}, {0, 1, 2, 4, 3, 5, 0, 2, 4, 3, 1, 5, 0, 3, 1, 2, 4, 5, 0, 4, 3, 1, 2, 5, 1, 0, 3, 5, 2, 4, 1, 2, 0, 3, 5, 4, 1, 3, 5, 2, 0, 4, 1, 5, 2, 0, 3, 4, 2, 0, 1, 5, 4, 3, 2, 1, 5, 4, 0, 3, 2, 4, 0, 1, 5, 3, 2, 5, 4, 0, 1, 3, 3, 0, 4, 5, 1, 2, 3, 1, 0, 4, 5, 2, 3, 4, 5, 1, 0, 2, 3, 5, 1, 0, 4, 2, 4, 0, 2, 5, 3, 1, 4, 2, 5, 3, 0, 1, 4, 3, 0, 2, 5, 1, 4, 5, 3, 0, 2, 1, 5, 1, 3, 4, 2, 0, 5, 2, 1, 3, 4, 0, 5, 3, 4, 2, 1, 0, 5, 4, 2, 1, 3, 0}, {0, 1, 2, 5, 3, 4, 0, 2, 5, 3, 1, 4, 0, 3, 1, 2, 5, 4, 0, 5, 3, 1, 2, 4, 1, 0, 3, 4, 2, 5, 1, 2, 0, 3, 4, 5, 1, 3, 4, 2, 0, 5, 1, 4, 2, 0, 3, 5, 2, 0, 1, 4, 5, 3, 2, 1, 4, 5, 0, 3, 2, 4, 5, 0, 1, 3, 2, 5, 0, 1, 4, 3, 3, 0, 5, 4, 1, 2, 3, 1, 0, 5, 4, 2, 3, 4, 1, 0, 5, 2, 3, 5, 4, 1, 0, 2, 4, 1, 3, 5, 2, 0, 4, 2, 1, 3, 5, 0, 4, 3, 5, 2, 1, 0, 4, 5, 2, 1, 3, 0, 5, 0, 2, 4, 3, 1, 5, 2, 4, 3, 0, 1, 5, 3, 0, 2, 4, 1, 5, 4, 3, 0, 2, 1}, {0, 1, 2, 4, 5, 3, 0, 2, 4, 5, 1, 3, 0, 4, 5, 1, 2, 3, 0, 5, 1, 2, 4, 3, 1, 0, 5, 3, 2, 4, 1, 2, 0, 5, 3, 4, 1, 3, 2, 0, 5, 4, 1, 5, 3, 2, 0, 4, 2, 0, 1, 3, 4, 5, 2, 1, 3, 4, 0, 5, 2, 3, 4, 0, 1, 5, 2, 4, 0, 1, 3, 5, 3, 1, 5, 4, 2, 0, 3, 2, 1, 5, 4, 0, 3, 4, 2, 1, 5, 0, 3, 5, 4, 2, 1, 0, 4, 0, 2, 3, 5, 1, 4, 2, 3, 5, 0, 1, 4, 3, 5, 0, 2, 1, 4, 5, 0, 2, 3, 1, 5, 0, 4, 3, 1, 2, 5, 1, 0, 4, 3, 2, 5, 3, 1, 0, 4, 2, 5, 4, 3, 1, 0, 2}, {0, 1, 2, 5, 4, 3, 0, 2, 5, 4, 1, 3, 0, 4, 1, 2, 5, 3, 0, 5, 4, 1, 2, 3, 1, 0, 4, 3, 2, 5, 1, 2, 0, 4, 3, 5, 1, 3, 2, 0, 4, 5, 1, 4, 3, 2, 0, 5, 2, 0, 1, 3, 5, 4, 2, 1, 3, 5, 0, 4, 2, 3, 5, 0, 1, 4, 2, 5, 0, 1, 3, 4, 3, 1, 4, 5, 2, 0, 3, 2, 1, 4, 5, 0, 3, 4, 5, 2, 1, 0, 3, 5, 2, 1, 4, 0, 4, 0, 5, 3, 1, 2, 4, 1, 0, 5, 3, 2, 4, 3, 1, 0, 5, 2, 4, 5, 3, 1, 0, 2, 5, 0, 2, 3, 4, 1, 5, 2, 3, 4, 0, 1, 5, 3, 4, 0, 2, 1, 5, 4, 0, 2, 3, 1}, {0, 1, 3, 2, 4, 5, 0, 2, 4, 1, 3, 5, 0, 3, 2, 4, 1, 5, 0, 4, 1, 3, 2, 5, 1, 0, 4, 5, 3, 2, 1, 3, 0, 4, 5, 2, 1, 4, 5, 3, 0, 2, 1, 5, 3, 0, 4, 2, 2, 0, 3, 5, 4, 1, 2, 3, 5, 4, 0, 1, 2, 4, 0, 3, 5, 1, 2, 5, 4, 0, 3, 1, 3, 0, 1, 5, 2, 4, 3, 1, 5, 2, 0, 4, 3, 2, 0, 1, 5, 4, 3, 5, 2, 0, 1, 4, 4, 0, 2, 5, 1, 3, 4, 1, 0, 2, 5, 3, 4, 2, 5, 1, 0, 3, 4, 5, 1, 0, 2, 3, 5, 1, 4, 2, 3, 0, 5, 2, 3, 1, 4, 0, 5, 3, 1, 4, 2, 0, 5, 4, 2, 3, 1, 0}, {0, 1, 3, 2, 5, 4, 0, 2, 5, 1, 3, 4, 0, 3, 2, 5, 1, 4, 0, 5, 1, 3, 2, 4, 1, 0, 5, 4, 3, 2, 1, 3, 0, 5, 4, 2, 1, 4, 3, 0, 5, 2, 1, 5, 4, 3, 0, 2, 2, 0, 3, 4, 5, 1, 2, 3, 4, 5, 0, 1, 2, 4, 5, 0, 3, 1, 2, 5, 0, 3, 4, 1, 3, 0, 1, 4, 2, 5, 3, 1, 4, 2, 0, 5, 3, 2, 0, 1, 4, 5, 3, 4, 2, 0, 1, 5, 4, 1, 5, 2, 3, 0, 4, 2, 3, 1, 5, 0, 4, 3, 1, 5, 2, 0, 4, 5, 2, 3, 1, 0, 5, 0, 2, 4, 1, 3, 5, 1, 0, 2, 4, 3, 5, 2, 4, 1, 0, 3, 5, 4, 1, 0, 2, 3}, {0, 1, 4, 2, 3, 5, 0, 2, 3, 1, 4, 5, 0, 3, 1, 4, 2, 5, 0, 4, 2, 3, 1, 5, 1, 0, 3, 5, 4, 2, 1, 3, 5, 4, 0, 2, 1, 4, 0, 3, 5, 2, 1, 5, 4, 0, 3, 2, 2, 0, 4, 5, 3, 1, 2, 3, 0, 4, 5, 1, 2, 4, 5, 3, 0, 1, 2, 5, 3, 0, 4, 1, 3, 0, 2, 5, 1, 4, 3, 1, 0, 2, 5, 4, 3, 2, 5, 1, 0, 4, 3, 5, 1, 0, 2, 4, 4, 0, 1, 5, 2, 3, 4, 1, 5, 2, 0, 3, 4, 2, 0, 1, 5, 3, 4, 5, 2, 0, 1, 3, 5, 1, 3, 2, 4, 0, 5, 2, 4, 1, 3, 0, 5, 3, 2, 4, 1, 0, 5, 4, 1, 3, 2, 0}, {0, 1, 5, 2, 3, 4, 0, 2, 3, 1, 5, 4, 0, 3, 1, 5, 2, 4, 0, 5, 2, 3, 1, 4, 1, 0, 3, 4, 5, 2, 1, 3, 4, 5, 0, 2, 1, 4, 5, 0, 3, 2, 1, 5, 0, 3, 4, 2, 2, 0, 5, 4, 3, 1, 2, 3, 0, 5, 4, 1, 2, 4, 3, 0, 5, 1, 2, 5, 4, 3, 0, 1, 3, 0, 2, 4, 1, 5, 3, 1, 0, 2, 4, 5, 3, 2, 4, 1, 0, 5, 3, 4, 1, 0, 2, 5, 4, 1, 3, 2, 5, 0, 4, 2, 5, 1, 3, 0, 4, 3, 2, 5, 1, 0, 4, 5, 1, 3, 2, 0, 5, 0, 1, 4, 2, 3, 5, 1, 4, 2, 0, 3, 5, 2, 0, 1, 4, 3, 5, 4, 2, 0, 1, 3}, {0, 1, 4, 2, 5, 3, 0, 2, 5, 1, 4, 3, 0, 4, 2, 5, 1, 3, 0, 5, 1, 4, 2, 3, 1, 0, 5, 3, 4, 2, 1, 3, 4, 0, 5, 2, 1, 4, 0, 5, 3, 2, 1, 5, 3, 4, 0, 2, 2, 0, 4, 3, 5, 1, 2, 3, 5, 0, 4, 1, 2, 4, 3, 5, 0, 1, 2, 5, 0, 4, 3, 1, 3, 1, 5, 2, 4, 0, 3, 2, 4, 1, 5, 0, 3, 4, 1, 5, 2, 0, 3, 5, 2, 4, 1, 0, 4, 0, 1, 3, 2, 5, 4, 1, 3, 2, 0, 5, 4, 2, 0, 1, 3, 5, 4, 3, 2, 0, 1, 5, 5, 0, 2, 3, 1, 4, 5, 1, 0, 2, 3, 4, 5, 2, 3, 1, 0, 4, 5, 3, 1, 0, 2, 4}, {0, 1, 5, 2, 4, 3, 0, 2, 4, 1, 5, 3, 0, 4, 1, 5, 2, 3, 0, 5, 2, 4, 1, 3, 1, 0, 4, 3, 5, 2, 1, 3, 5, 0, 4, 2, 1, 4, 3, 5, 0, 2, 1, 5, 0, 4, 3, 2, 2, 0, 5, 3, 4, 1, 2, 3, 4, 0, 5, 1, 2, 4, 0, 5, 3, 1, 2, 5, 3, 4, 0, 1, 3, 1, 4, 2, 5, 0, 3, 2, 5, 1, 4, 0, 3, 4, 2, 5, 1, 0, 3, 5, 1, 4, 2, 0, 4, 0, 2, 3, 1, 5, 4, 1, 0, 2, 3, 5, 4, 2, 3, 1, 0, 5, 4, 3, 1, 0, 2, 5, 5, 0, 1, 3, 2, 4, 5, 1, 3, 2, 0, 4, 5, 2, 0, 1, 3, 4, 5, 3, 2, 0, 1, 4}, {0, 1, 3, 4, 2, 5, 0, 2, 1, 3, 4, 5, 0, 3, 4, 2, 1, 5, 0, 4, 2, 1, 3, 5, 1, 0, 2, 5, 3, 4, 1, 2, 5, 3, 0, 4, 1, 3, 0, 2, 5, 4, 1, 5, 3, 0, 2, 4, 2, 0, 4, 5, 1, 3, 2, 1, 0, 4, 5, 3, 2, 4, 5, 1, 0, 3, 2, 5, 1, 0, 4, 3, 3, 0, 1, 5, 4, 2, 3, 1, 5, 4, 0, 2, 3, 4, 0, 1, 5, 2, 3, 5, 4, 0, 1, 2, 4, 0, 3, 5, 2, 1, 4, 2, 0, 3, 5, 1, 4, 3, 5, 2, 0, 1, 4, 5, 2, 0, 3, 1, 5, 1, 2, 4, 3, 0, 5, 2, 4, 3, 1, 0, 5, 3, 1, 2, 4, 0, 5, 4, 3, 1, 2, 0}, {0, 1, 3, 5, 2, 4, 0, 2, 1, 3, 5, 4, 0, 3, 5, 2, 1, 4, 0, 5, 2, 1, 3, 4, 1, 0, 2, 4, 3, 5, 1, 2, 4, 3, 0, 5, 1, 3, 0, 2, 4, 5, 1, 4, 3, 0, 2, 5, 2, 0, 5, 4, 1, 3, 2, 1, 0, 5, 4, 3, 2, 4, 1, 0, 5, 3, 2, 5, 4, 1, 0, 3, 3, 0, 1, 4, 5, 2, 3, 1, 4, 5, 0, 2, 3, 4, 5, 0, 1, 2, 3, 5, 0, 1, 4, 2, 4, 1, 2, 5, 3, 0, 4, 2, 5, 3, 1, 0, 4, 3, 1, 2, 5, 0, 4, 5, 3, 1, 2, 0, 5, 0, 3, 4, 2, 1, 5, 2, 0, 3, 4, 1, 5, 3, 4, 2, 0, 1, 5, 4, 2, 0, 3, 1}, {0, 1, 5, 3, 2, 4, 0, 2, 1, 5, 3, 4, 0, 3, 2, 1, 5, 4, 0, 5, 3, 2, 1, 4, 1, 0, 2, 4, 5, 3, 1, 2, 4, 5, 0, 3, 1, 4, 5, 0, 2, 3, 1, 5, 0, 2, 4, 3, 2, 0, 3, 4, 1, 5, 2, 1, 0, 3, 4, 5, 2, 3, 4, 1, 0, 5, 2, 4, 1, 0, 3, 5, 3, 0, 5, 4, 2, 1, 3, 2, 0, 5, 4, 1, 3, 4, 2, 0, 5, 1, 3, 5, 4, 2, 0, 1, 4, 1, 2, 3, 5, 0, 4, 2, 3, 5, 1, 0, 4, 3, 5, 1, 2, 0, 4, 5, 1, 2, 3, 0, 5, 0, 1, 4, 3, 2, 5, 1, 4, 3, 0, 2, 5, 3, 0, 1, 4, 2, 5, 4, 3, 0, 1, 2}, {0, 1, 4, 5, 2, 3, 0, 2, 1, 4, 5, 3, 0, 4, 5, 2, 1, 3, 0, 5, 2, 1, 4, 3, 1, 0, 2, 3, 4, 5, 1, 2, 3, 4, 0, 5, 1, 3, 4, 0, 2, 5, 1, 4, 0, 2, 3, 5, 2, 0, 5, 3, 1, 4, 2, 1, 0, 5, 3, 4, 2, 3, 1, 0, 5, 4, 2, 5, 3, 1, 0, 4, 3, 1, 2, 5, 4, 0, 3, 2, 5, 4, 1, 0, 3, 4, 1, 2, 5, 0, 3, 5, 4, 1, 2, 0, 4, 0, 1, 3, 5, 2, 4, 1, 3, 5, 0, 2, 4, 3, 5, 0, 1, 2, 4, 5, 0, 1, 3, 2, 5, 0, 4, 3, 2, 1, 5, 2, 0, 4, 3, 1, 5, 3, 2, 0, 4, 1, 5, 4, 3, 2, 0, 1}, {0, 1, 5, 4, 2, 3, 0, 2, 1, 5, 4, 3, 0, 4, 2, 1, 5, 3, 0, 5, 4, 2, 1, 3, 1, 0, 2, 3, 5, 4, 1, 2, 3, 5, 0, 4, 1, 3, 5, 0, 2, 4, 1, 5, 0, 2, 3, 4, 2, 0, 4, 3, 1, 5, 2, 1, 0, 4, 3, 5, 2, 3, 1, 0, 4, 5, 2, 4, 3, 1, 0, 5, 3, 1, 2, 4, 5, 0, 3, 2, 4, 5, 1, 0, 3, 4, 5, 1, 2, 0, 3, 5, 1, 2, 4, 0, 4, 0, 5, 3, 2, 1, 4, 2, 0, 5, 3, 1, 4, 3, 2, 0, 5, 1, 4, 5, 3, 2, 0, 1, 5, 0, 1, 3, 4, 2, 5, 1, 3, 4, 0, 2, 5, 3, 4, 0, 1, 2, 5, 4, 0, 1, 3, 2}, {0, 1, 3, 4, 5, 2, 0, 3, 4, 5, 1, 2, 0, 4, 5, 1, 3, 2, 0, 5, 1, 3, 4, 2, 1, 0, 5, 2, 3, 4, 1, 2, 3, 0, 5, 4, 1, 3, 0, 5, 2, 4, 1, 5, 2, 3, 0, 4, 2, 1, 5, 4, 3, 0, 2, 3, 1, 5, 4, 0, 2, 4, 3, 1, 5, 0, 2, 5, 4, 3, 1, 0, 3, 0, 1, 2, 4, 5, 3, 1, 2, 4, 0, 5, 3, 2, 4, 0, 1, 5, 3, 4, 0, 1, 2, 5, 4, 0, 3, 2, 5, 1, 4, 2, 5, 0, 3, 1, 4, 3, 2, 5, 0, 1, 4, 5, 0, 3, 2, 1, 5, 0, 4, 2, 1, 3, 5, 1, 0, 4, 2, 3, 5, 2, 1, 0, 4, 3, 5, 4, 2, 1, 0, 3}, {0, 1, 3, 5, 4, 2, 0, 3, 5, 4, 1, 2, 0, 4, 1, 3, 5, 2, 0, 5, 4, 1, 3, 2, 1, 0, 4, 2, 3, 5, 1, 2, 3, 0, 4, 5, 1, 3, 0, 4, 2, 5, 1, 4, 2, 3, 0, 5, 2, 1, 4, 5, 3, 0, 2, 3, 1, 4, 5, 0, 2, 4, 5, 3, 1, 0, 2, 5, 3, 1, 4, 0, 3, 0, 1, 2, 5, 4, 3, 1, 2, 5, 0, 4, 3, 2, 5, 0, 1, 4, 3, 5, 0, 1, 2, 4, 4, 0, 5, 2, 1, 3, 4, 1, 0, 5, 2, 3, 4, 2, 1, 0, 5, 3, 4, 5, 2, 1, 0, 3, 5, 0, 3, 2, 4, 1, 5, 2, 4, 0, 3, 1, 5, 3, 2, 4, 0, 1, 5, 4, 0, 3, 2, 1}, {0, 1, 4, 3, 5, 2, 0, 3, 5, 1, 4, 2, 0, 4, 3, 5, 1, 2, 0, 5, 1, 4, 3, 2, 1, 0, 5, 2, 4, 3, 1, 2, 4, 0, 5, 3, 1, 4, 0, 5, 2, 3, 1, 5, 2, 4, 0, 3, 2, 1, 5, 3, 4, 0, 2, 3, 4, 1, 5, 0, 2, 4, 1, 5, 3, 0, 2, 5, 3, 4, 1, 0, 3, 0, 4, 2, 5, 1, 3, 2, 5, 0, 4, 1, 3, 4, 2, 5, 0, 1, 3, 5, 0, 4, 2, 1, 4, 0, 1, 2, 3, 5, 4, 1, 2, 3, 0, 5, 4, 2, 3, 0, 1, 5, 4, 3, 0, 1, 2, 5, 5, 0, 3, 2, 1, 4, 5, 1, 0, 3, 2, 4, 5, 2, 1, 0, 3, 4, 5, 3, 2, 1, 0, 4}, {0, 1, 5, 3, 4, 2, 0, 3, 4, 1, 5, 2, 0, 4, 1, 5, 3, 2, 0, 5, 3, 4, 1, 2, 1, 0, 4, 2, 5, 3, 1, 2, 5, 0, 4, 3, 1, 4, 2, 5, 0, 3, 1, 5, 0, 4, 2, 3, 2, 1, 4, 3, 5, 0, 2, 3, 5, 1, 4, 0, 2, 4, 3, 5, 1, 0, 2, 5, 1, 4, 3, 0, 3, 0, 5, 2, 4, 1, 3, 2, 4, 0, 5, 1, 3, 4, 0, 5, 2, 1, 3, 5, 2, 4, 0, 1, 4, 0, 3, 2, 1, 5, 4, 1, 0, 3, 2, 5, 4, 2, 1, 0, 3, 5, 4, 3, 2, 1, 0, 5, 5, 0, 1, 2, 3, 4, 5, 1, 2, 3, 0, 4, 5, 2, 3, 0, 1, 4, 5, 3, 0, 1, 2, 4}, {0, 1, 4, 5, 3, 2, 0, 3, 1, 4, 5, 2, 0, 4, 5, 3, 1, 2, 0, 5, 3, 1, 4, 2, 1, 0, 3, 2, 4, 5, 1, 2, 4, 0, 3, 5, 1, 3, 2, 4, 0, 5, 1, 4, 0, 3, 2, 5, 2, 1, 3, 5, 4, 0, 2, 3, 5, 4, 1, 0, 2, 4, 1, 3, 5, 0, 2, 5, 4, 1, 3, 0, 3, 0, 5, 2, 1, 4, 3, 1, 0, 5, 2, 4, 3, 2, 1, 0, 5, 4, 3, 5, 2, 1, 0, 4, 4, 0, 1, 2, 5, 3, 4, 1, 2, 5, 0, 3, 4, 2, 5, 0, 1, 3, 4, 5, 0, 1, 2, 3, 5, 0, 4, 2, 3, 1, 5, 2, 3, 0, 4, 1, 5, 3, 0, 4, 2, 1, 5, 4, 2, 3, 0, 1}, {0, 1, 5, 4, 3, 2, 0, 3, 1, 5, 4, 2, 0, 4, 3, 1, 5, 2, 0, 5, 4, 3, 1, 2, 1, 0, 3, 2, 5, 4, 1, 2, 5, 0, 3, 4, 1, 3, 2, 5, 0, 4, 1, 5, 0, 3, 2, 4, 2, 1, 3, 4, 5, 0, 2, 3, 4, 5, 1, 0, 2, 4, 5, 1, 3, 0, 2, 5, 1, 3, 4, 0, 3, 0, 4, 2, 1, 5, 3, 1, 0, 4, 2, 5, 3, 2, 1, 0, 4, 5, 3, 4, 2, 1, 0, 5, 4, 0, 5, 2, 3, 1, 4, 2, 3, 0, 5, 1, 4, 3, 0, 5, 2, 1, 4, 5, 2, 3, 0, 1, 5, 0, 1, 2, 4, 3, 5, 1, 2, 4, 0, 3, 5, 2, 4, 0, 1, 3, 5, 4, 0, 1, 2, 3}, {0, 2, 3, 4, 5, 1, 0, 3, 4, 5, 2, 1, 0, 4, 5, 2, 3, 1, 0, 5, 2, 3, 4, 1, 1, 2, 5, 4, 3, 0, 1, 3, 2, 5, 4, 0, 1, 4, 3, 2, 5, 0, 1, 5, 4, 3, 2, 0, 2, 0, 5, 1, 3, 4, 2, 1, 3, 0, 5, 4, 2, 3, 0, 5, 1, 4, 2, 5, 1, 3, 0, 4, 3, 0, 2, 1, 4, 5, 3, 1, 4, 0, 2, 5, 3, 2, 1, 4, 0, 5, 3, 4, 0, 2, 1, 5, 4, 0, 3, 1, 5, 2, 4, 1, 5, 0, 3, 2, 4, 3, 1, 5, 0, 2, 4, 5, 0, 3, 1, 2, 5, 0, 4, 1, 2, 3, 5, 1, 2, 0, 4, 3, 5, 2, 0, 4, 1, 3, 5, 4, 1, 2, 0, 3}, {0, 2, 3, 5, 4, 1, 0, 3, 5, 4, 2, 1, 0, 4, 2, 3, 5, 1, 0, 5, 4, 2, 3, 1, 1, 2, 4, 5, 3, 0, 1, 3, 2, 4, 5, 0, 1, 4, 5, 3, 2, 0, 1, 5, 3, 2, 4, 0, 2, 0, 4, 1, 3, 5, 2, 1, 3, 0, 4, 5, 2, 3, 0, 4, 1, 5, 2, 4, 1, 3, 0, 5, 3, 0, 2, 1, 5, 4, 3, 1, 5, 0, 2, 4, 3, 2, 1, 5, 0, 4, 3, 5, 0, 2, 1, 4, 4, 0, 5, 1, 2, 3, 4, 1, 2, 0, 5, 3, 4, 2, 0, 5, 1, 3, 4, 5, 1, 2, 0, 3, 5, 0, 3, 1, 4, 2, 5, 1, 4, 0, 3, 2, 5, 3, 1, 4, 0, 2, 5, 4, 0, 3, 1, 2}, {0, 2, 4, 3, 5, 1, 0, 3, 5, 2, 4, 1, 0, 4, 3, 5, 2, 1, 0, 5, 2, 4, 3, 1, 1, 2, 5, 3, 4, 0, 1, 3, 4, 2, 5, 0, 1, 4, 2, 5, 3, 0, 1, 5, 3, 4, 2, 0, 2, 0, 5, 1, 4, 3, 2, 1, 4, 0, 5, 3, 2, 4, 0, 5, 1, 3, 2, 5, 1, 4, 0, 3, 3, 0, 4, 1, 5, 2, 3, 1, 5, 0, 4, 2, 3, 4, 1, 5, 0, 2, 3, 5, 0, 4, 1, 2, 4, 0, 2, 1, 3, 5, 4, 1, 3, 0, 2, 5, 4, 2, 1, 3, 0, 5, 4, 3, 0, 2, 1, 5, 5, 0, 3, 1, 2, 4, 5, 1, 2, 0, 3, 4, 5, 2, 0, 3, 1, 4, 5, 3, 1, 2, 0, 4}, {0, 2, 5, 3, 4, 1, 0, 3, 4, 2, 5, 1, 0, 4, 2, 5, 3, 1, 0, 5, 3, 4, 2, 1, 1, 2, 4, 3, 5, 0, 1, 3, 5, 2, 4, 0, 1, 4, 3, 5, 2, 0, 1, 5, 2, 4, 3, 0, 2, 0, 4, 1, 5, 3, 2, 1, 5, 0, 4, 3, 2, 4, 1, 5, 0, 3, 2, 5, 0, 4, 1, 3, 3, 0, 5, 1, 4, 2, 3, 1, 4, 0, 5, 2, 3, 4, 0, 5, 1, 2, 3, 5, 1, 4, 0, 2, 4, 0, 3, 1, 2, 5, 4, 1, 2, 0, 3, 5, 4, 2, 0, 3, 1, 5, 4, 3, 1, 2, 0, 5, 5, 0, 2, 1, 3, 4, 5, 1, 3, 0, 2, 4, 5, 2, 1, 3, 0, 4, 5, 3, 0, 2, 1, 4}, {0, 2, 4, 5, 3, 1, 0, 3, 2, 4, 5, 1, 0, 4, 5, 3, 2, 1, 0, 5, 3, 2, 4, 1, 1, 2, 3, 5, 4, 0, 1, 3, 5, 4, 2, 0, 1, 4, 2, 3, 5, 0, 1, 5, 4, 2, 3, 0, 2, 0, 3, 1, 4, 5, 2, 1, 4, 0, 3, 5, 2, 3, 1, 4, 0, 5, 2, 4, 0, 3, 1, 5, 3, 0, 5, 1, 2, 4, 3, 1, 2, 0, 5, 4, 3, 2, 0, 5, 1, 4, 3, 5, 1, 2, 0, 4, 4, 0, 2, 1, 5, 3, 4, 1, 5, 0, 2, 3, 4, 2, 1, 5, 0, 3, 4, 5, 0, 2, 1, 3, 5, 0, 4, 1, 3, 2, 5, 1, 3, 0, 4, 2, 5, 3, 0, 4, 1, 2, 5, 4, 1, 3, 0, 2}, {0, 2, 5, 4, 3, 1, 0, 3, 2, 5, 4, 1, 0, 4, 3, 2, 5, 1, 0, 5, 4, 3, 2, 1, 1, 2, 3, 4, 5, 0, 1, 3, 4, 5, 2, 0, 1, 4, 5, 2, 3, 0, 1, 5, 2, 3, 4, 0, 2, 0, 3, 1, 5, 4, 2, 1, 5, 0, 3, 4, 2, 3, 1, 5, 0, 4, 2, 5, 0, 3, 1, 4, 3, 0, 4, 1, 2, 5, 3, 1, 2, 0, 4, 5, 3, 2, 0, 4, 1, 5, 3, 4, 1, 2, 0, 5, 4, 0, 5, 1, 3, 2, 4, 1, 3, 0, 5, 2, 4, 3, 0, 5, 1, 2, 4, 5, 1, 3, 0, 2, 5, 0, 2, 1, 4, 3, 5, 1, 4, 0, 2, 3, 5, 2, 1, 4, 0, 3, 5, 4, 0, 2, 1, 3}};

        private Octahedral(int u, int[] vs, int order) {
            if (vs.length != 6) {
                throw new IllegalArgumentException("Octahedral topology requires 6 vertices");
            }
            this.u = u;
            this.vs = vs;
            this.order = order;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            if (this.order >= 1 && this.order <= 30) {
                return Configuration.values()[Configuration.OH1.ordinal() + this.order - 1];
            }
            return Configuration.UNKNOWN;
        }

        @Override
        Topology orderBy(int[] rank) {
            int[] src = Topology.applyInv(this.vs, Octahedral.PERMUTATIONS[this.order - 1]);
            int[] dst = (int[])src.clone();
            Topology.indirectSort(dst, rank);
            for (int i = 1; i <= 30; ++i) {
                if (!Topology.check(dst, src, Octahedral.PERMUTATIONS[i - 1], 6, 4)) continue;
                return new Octahedral(this.u, dst, i);
            }
            return null;
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new Octahedral(mapping[this.u], ws, this.order);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, this.vs.length);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.order;
        }
    }

    private static final class TrigonalBipyramidal
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int order;
        private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 4, 0, 2, 3, 1, 4, 0, 3, 1, 2, 4, 4, 3, 2, 1, 0, 4, 1, 3, 2, 0, 4, 2, 1, 3, 0}, {0, 3, 2, 1, 4, 0, 2, 1, 3, 4, 0, 1, 3, 2, 4, 4, 1, 2, 3, 0, 4, 3, 1, 2, 0, 4, 2, 3, 1, 0}, {0, 1, 2, 4, 3, 0, 2, 4, 1, 3, 0, 4, 1, 2, 3, 3, 4, 2, 1, 0, 3, 1, 4, 2, 0, 3, 2, 1, 4, 0}, {0, 4, 2, 1, 3, 0, 2, 1, 4, 3, 0, 1, 4, 2, 3, 3, 1, 2, 4, 0, 3, 4, 1, 2, 0, 3, 2, 4, 1, 0}, {0, 1, 3, 4, 2, 0, 3, 4, 1, 2, 0, 4, 1, 3, 2, 2, 4, 3, 1, 0, 2, 1, 4, 3, 0, 2, 3, 1, 4, 0}, {0, 4, 3, 1, 2, 0, 3, 1, 4, 2, 0, 1, 4, 3, 2, 2, 1, 3, 4, 0, 2, 4, 1, 3, 0, 2, 3, 4, 1, 0}, {0, 2, 3, 4, 1, 0, 3, 4, 2, 1, 0, 4, 2, 3, 1, 1, 4, 3, 2, 0, 1, 2, 4, 3, 0, 1, 3, 2, 4, 0}, {0, 4, 3, 2, 1, 0, 3, 2, 4, 1, 0, 2, 4, 3, 1, 1, 2, 3, 4, 0, 1, 4, 2, 3, 0, 1, 3, 4, 2, 0}, {1, 0, 2, 3, 4, 1, 2, 3, 0, 4, 1, 3, 0, 2, 4, 4, 3, 2, 0, 1, 4, 0, 3, 2, 1, 4, 2, 0, 3, 1}, {1, 0, 2, 4, 3, 1, 2, 4, 0, 3, 1, 4, 0, 2, 3, 3, 4, 2, 0, 1, 3, 0, 4, 2, 1, 3, 2, 0, 4, 1}, {1, 3, 2, 0, 4, 1, 2, 0, 3, 4, 1, 0, 3, 2, 4, 4, 0, 2, 3, 1, 4, 3, 0, 2, 1, 4, 2, 3, 0, 1}, {1, 4, 2, 0, 3, 1, 2, 0, 4, 3, 1, 0, 4, 2, 3, 3, 0, 2, 4, 1, 3, 4, 0, 2, 1, 3, 2, 4, 0, 1}, {1, 0, 3, 4, 2, 1, 3, 4, 0, 2, 1, 4, 0, 3, 2, 2, 4, 3, 0, 1, 2, 0, 4, 3, 1, 2, 3, 0, 4, 1}, {1, 4, 3, 0, 2, 1, 3, 0, 4, 2, 1, 0, 4, 3, 2, 2, 0, 3, 4, 1, 2, 4, 0, 3, 1, 2, 3, 4, 0, 1}, {2, 0, 1, 3, 4, 2, 1, 3, 0, 4, 2, 3, 0, 1, 4, 4, 3, 1, 0, 2, 4, 0, 3, 1, 2, 4, 1, 0, 3, 2}, {2, 0, 1, 4, 3, 2, 1, 4, 0, 3, 2, 4, 0, 1, 3, 3, 4, 1, 0, 2, 3, 0, 4, 1, 2, 3, 1, 0, 4, 2}, {3, 0, 1, 2, 4, 3, 1, 2, 0, 4, 3, 2, 0, 1, 4, 4, 2, 1, 0, 3, 4, 0, 2, 1, 3, 4, 1, 0, 2, 3}, {3, 2, 1, 0, 4, 3, 1, 0, 2, 4, 3, 0, 2, 1, 4, 4, 0, 1, 2, 3, 4, 2, 0, 1, 3, 4, 1, 2, 0, 3}, {2, 4, 1, 0, 3, 2, 1, 0, 4, 3, 2, 0, 4, 1, 3, 3, 0, 1, 4, 2, 3, 4, 0, 1, 2, 3, 1, 4, 0, 2}, {2, 3, 1, 0, 4, 2, 1, 0, 3, 4, 2, 0, 3, 1, 4, 4, 0, 1, 3, 2, 4, 3, 0, 1, 2, 4, 1, 3, 0, 2}};

        private TrigonalBipyramidal(int u, int[] vs, int order) {
            if (vs.length != 5) {
                throw new IllegalArgumentException("TrigonalBipyramidal topology requires 5 vertices");
            }
            this.u = u;
            this.vs = vs;
            this.order = order;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            if (this.order >= 1 && this.order <= 20) {
                return Configuration.values()[Configuration.TB1.ordinal() + this.order - 1];
            }
            return Configuration.UNKNOWN;
        }

        @Override
        Topology orderBy(int[] rank) {
            int[] src = Topology.applyInv(this.vs, TrigonalBipyramidal.PERMUTATIONS[this.order - 1]);
            int[] dst = (int[])src.clone();
            Topology.indirectSort(dst, rank);
            for (int i = 1; i <= 20; ++i) {
                if (!Topology.check(dst, src, TrigonalBipyramidal.PERMUTATIONS[i - 1], 5, 3)) continue;
                return new TrigonalBipyramidal(this.u, dst, i);
            }
            return null;
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new TrigonalBipyramidal(mapping[this.u], ws, this.order);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, this.vs.length);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.order;
        }
    }

    private static final class SquarePlanar
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int order;
        private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 0, 3, 2, 1, 1, 2, 3, 0, 1, 0, 3, 2, 2, 3, 0, 1, 2, 1, 0, 3, 3, 2, 1, 0, 3, 0, 1, 2}, {0, 2, 1, 3, 0, 3, 1, 2, 1, 3, 0, 2, 1, 2, 0, 3, 2, 0, 3, 1, 2, 1, 3, 0, 3, 1, 2, 0, 3, 0, 2, 1}, {0, 1, 3, 2, 0, 2, 3, 1, 1, 0, 2, 3, 1, 3, 2, 0, 2, 3, 1, 0, 2, 0, 1, 3, 3, 2, 0, 1, 3, 1, 0, 2}};

        private SquarePlanar(int u, int[] vs, int p) {
            if (vs.length != 4) {
                throw new IllegalArgumentException("SquarePlanar topology requires 4 vertices");
            }
            this.u = u;
            this.vs = vs;
            this.order = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            switch (this.order) {
                case 1: {
                    return Configuration.SP1;
                }
                case 2: {
                    return Configuration.SP2;
                }
                case 3: {
                    return Configuration.SP3;
                }
            }
            return Configuration.UNKNOWN;
        }

        @Override
        Topology orderBy(int[] rank) {
            int[] src = Topology.applyInv(this.vs, SquarePlanar.PERMUTATIONS[this.order - 1]);
            int[] dst = (int[])src.clone();
            Topology.indirectSort(dst, rank);
            if (this.order < 1 || this.order > 20) {
                return null;
            }
            for (int i = 1; i <= 3; ++i) {
                if (!Topology.check(dst, src, SquarePlanar.PERMUTATIONS[i - 1], 4, 2)) continue;
                return new SquarePlanar(this.u, dst, i);
            }
            return null;
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new SquarePlanar(mapping[this.u], ws, this.order);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, this.vs.length);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.order;
        }
    }

    private static final class ExtendedTetrahedral
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private ExtendedTetrahedral(int u, int[] vs, int p) {
            if (vs.length != 4) {
                throw new IllegalArgumentException("Tetrahedral topology requires 4 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.AL1 : Configuration.AL2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new ExtendedTetrahedral(this.u, ExtendedTetrahedral.sort(this.vs, rank), this.p * ExtendedTetrahedral.parity4(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new ExtendedTetrahedral(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 4);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }

    private static final class Tetrahedral
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private Tetrahedral(int u, int[] vs, int p) {
            if (vs.length != 4) {
                throw new IllegalArgumentException("Tetrahedral topology requires 4 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.TH1 : Configuration.TH2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new Tetrahedral(this.u, Tetrahedral.sort(this.vs, rank), this.p * Tetrahedral.parity4(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new Tetrahedral(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 4);
        }

        @Override
        Configuration configurationOf(int[] rank) {
            return this.p * Tetrahedral.parity4(this.vs, rank) < 0 ? Configuration.TH1 : Configuration.TH2;
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }
}

