"""Valid FIDO 2 test data."""
# Generated using examples/credential.py from python-fido2
HOSTNAME = 'testserver'
USERNAME = 'kryten'
PASSWORD = 'passwd'
USER_FIRST_NAME = 'Kryten'
USER_LAST_NAME = '2X4B-523P'
USER_FULL_NAME = USER_FIRST_NAME + ' ' + USER_LAST_NAME
REGISTRATION_CHALLENGE = "Rimmerstasks"
REGISTRATION_CLIENT_DATA = ('eyJ0eXBlIjogIndlYmF1dGhuLmNyZWF0ZSIsICJjbGllbnRFeHRlbnNpb25zIjoge30sICJjaGFsbGVuZ2UiOiAiUm'
                            'ltbWVyc3Rhc2tzIiwgIm9yaWdpbiI6ICJodHRwczovL3Rlc3RzZXJ2ZXIifQ==')
USER_HANDLE = 'ecc1479fbb8540a6a22fa655ab4c4baf'
USER_HANDLE_B64 = 'ZWNjMTQ3OWZiYjg1NDBhNmEyMmZhNjU1YWI0YzRiYWY='
ATTESTATION_OBJECT = (
    'owFoZmlkby11MmYCWMTr2rckepjnyU3pMGbSTDiv2aDKKY42hLR6uxEx/MnyAEEAAAAAAAAAAAAAAAAAAAAAAAAAAABAVKZJP1j2MAl+NE9Ho0pa+T'
    'ybzzmoI4XbU/MvHCr7lQBJc3O5WvHF9B85RIk2ZEyRSwVHh8MW+te50I9juwr6gqUBAgMmIAEhWCDhTkbEO9WpfLwhmoLoPnka4fFANkMYCqhpxI6V'
    'jSDt1CJYIPirPpi/vXbFj/xN9eCGW+rTRQvplmahLa2SupgsLQkwA6Jjc2lnWEcwRQIgP4FTyNoVKsH4/f1TBlqJV5kRpIJR3Kof7N7hHygMyaECIQ'
    'DK+UaV3uOSS7QQ2p1OmDxwpOpakKwRGL1yVLq7QyLsE2N4NWOBWQJIMIICRDCCAS6gAwIBAgIEeMDfDjALBgkqhkiG9w0BAQswLjEsMCoGA1UEAxMj'
    'WXViaWNvIFUyRiBSb290IENBIFNlcmlhbCA0NTcyMDA2MzEwIBcNMTQwODAxMDAwMDAwWhgPMjA1MDA5MDQwMDAwMDBaMCoxKDAmBgNVBAMMH1l1Ym'
    'ljbyBVMkYgRUUgU2VyaWFsIDIwMjU5MDU5MzQwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAS1uHFcg/3+DqFcRXeshY30jBdv3oedyvS4PUDTIPJv'
    'reYl/Pf1yK/YNRj4254h7Ag7GEWAxxfsSkcLlopvuj9vozswOTAiBgkrBgEEAYLECgIEFTEuMy42LjEuNC4xLjQxNDgyLjEuMTATBgsrBgEEAYLlHA'
    'IBAQQEAwIFIDALBgkqhkiG9w0BAQsDggEBAD72q/ZKkWsL+ZSTjdyVNOBUQAJoVninLEOnq+ZdkGX/YfRRzoo67thmidGQuVCvAHpU0THu8G/ia06n'
    'uz4yt5IFpd+nYAQ0U+NK+ETDfNSoX4xcLYcOCiiyt+1EAkH9s3krIHaw4Yr6m0Mu7vwmWLoJBcQbJKk8bsi7ptVvM+jWU9fPa9UBVFWiZZdA99zFHM'
    'AxYJzQPqbN6Tmeygh2MpB2P7TI0A9WkGmhJUkAauuwaiGiFOSZmDe0KegdflbTOlSS3ToWHIKTlUCBqn7vdJw6Vj2919ujlcxHPkRpbUGRhcJDesg6'
    'wGTBy+RyJ/96G3fH1eoMNn1F9jC9mY1Zsm4=')
CREDENTIAL_ID = 'VKZJP1j2MAl+NE9Ho0pa+TybzzmoI4XbU/MvHCr7lQBJc3O5WvHF9B85RIk2ZEyRSwVHh8MW+te50I9juwr6gg=='
AUTHENTICATION_CHALLENGE = "Listerspants"
AUTHENTICATION_CLIENT_DATA = ('eyJ0eXBlIjogIndlYmF1dGhuLmdldCIsICJjbGllbnRFeHRlbnNpb25zIjoge30sICJjaGFsbGVuZ2UiOiAiTGlz'
                              'dGVyc3BhbnRzIiwgIm9yaWdpbiI6ICJodHRwczovL3Rlc3RzZXJ2ZXIifQ==')
AUTHENTICATOR_DATA = '69q3JHqY58lN6TBm0kw4r9mgyimONoS0ersRMfzJ8gABAAAAmA=='
SIGNATURE = 'MEUCIFM+4zYIqdomNBAuzWsijo0YJHm4gTJs5DPLCYnSnZoAAiEA4neUdBFkBZH7oFsc6F3GRjMrmqUWCN1I++SGOF7kV4E='

ATTESTATION_OBJECT_AAGUID = (
    'o2NmbXRmcGFja2VkZ2F0dFN0bXSjY2FsZyZjc2lnWEcwRQIhAMMnqZbbhgq13grtBrHycUWYF0wSNnyIUkRumJzaAT47AiB9fNA9kVe+JbTV9ZhAu+'
    'g3cIZEU3EKvfDUkqJEswd15mN4NWOBWQK4MIICtDCCAlmgAwIBAgIJALxeM7i3hpQoMAoGCCqGSM49BAMCMIGvMQswCQYDVQQGEwJLUjERMA8GA1UE'
    'CAwIU2VvdWwtU2kxEzARBgNVBAcMCkdhbmduYW0tR3UxFzAVBgNVBAoMDmVXQk0gQ28uLCBMdGQuMSIwIAYDVQQLDBlBdXRoZW50aWNhdG9yIEF0dG'
    'VzdGF0aW9uMRwwGgYDVQQDDBNlV0JNIENBIENlcnRpZmljYXRlMR0wGwYJKoZIhvcNAQkBFg5pbmZvQGUtd2JtLmNvbTAeFw0xOTA1MDMwNjI2MTNa'
    'Fw0yOTA0MjkwNjI2MTNaMIGxMQswCQYDVQQGEwJLUjERMA8GA1UECAwIU2VvdWwtU2kxEzARBgNVBAcMCkdhbmduYW0tR3UxFzAVBgNVBAoMDmVXQk'
    '0gQ28uLCBMdGQuMSIwIAYDVQQLDBlBdXRoZW50aWNhdG9yIEF0dGVzdGF0aW9uMR8wHQYDVQQDDBZlV0JNIEZJRE8yIENlcnRpZmljYXRlMRwwGgYJ'
    'KoZIhvcNAQkBFg1pbmZvQGV3Ym0uY29tMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEBU3mVqz1Sr9gT1sEOwanyeaKa3siEvNvZ5v+SLe9Hc6zsL'
    'hmOP9FcFM0Q3n0q1S5mMz0ICvZTIwoPUXBYbA9AKNaMFgwCQYDVR0TBAIwADAfBgNVHSMEGDAWgBS3J/fxiAv22irdBs98SODhF7kU/jAdBgNVHQ4E'
    'FgQURC6pWidWMcBGc1y0IAjaedxgYnEwCwYDVR0PBAQDAgXgMAoGCCqGSM49BAMCA0kAMEYCIQCgTYpDe4Z74WrbpTn0TguzSUM2IjMRgRxF8NSnhn'
    'bAIgIhAN5sSXh9kYR73Y36RSV8j8M+nJW7aKOhRqTPZ97VfiCyaGF1dGhEYXRhWQFEpGCn/cm1gYzLN4L17XO5PbIMLIZaj7Pu6DtHsSYxfwVFAAAA'
    'XpVEKy7xXk3vsnDvsQb6y04AwKHL67+i8+su5uUctKM4EEomwNhVpRi9j7dmcYxpEdGhA1pZLzNGIJoFotANTGEO0T6YkCbImP74RhE5uj7ATjxELY'
    'VJ3SyvAPOs6EM89aprfWVAAg7hrYH9HO5b0gdxoiaOmrzClXN75+cVK5mFOTC7Inr8ljg3uFvA4kCH8hU/S6Dr3a/T1YvYXj285XSnGx/7wY9yAKJZ'
    'xHtJc0mk1R/gN9TsDPngqraybvSLvXOUn5zuEtUwxe03Nk6cjiMRpaUBAgMmIAEhWCCeByElTJE3UC9e1Dg7Jm6vnwI4vsneKLHrUcvZRGWCxiJYIK'
    'hCeVWqyhJCQVgGv8KDk/pdngKmYpolIsdoGWbJ3DKw')

ATTESTATION_OBJECT_U2F = (
    'o2NmbXRoZmlkby11MmZnYXR0U3RtdKJjc2lnWEYwRAIgZbKbx6/0ZY8Q91XIJcLdq7mALC9yfKEFrxixAoDELu8CIDba48Jbop8JhW+i5Qfb/mgJv7'
    'm4X/WPZ/ARG+Qa46L7Y3g1Y4FZAuUwggLhMIICiKADAgECAgEBMAoGCCqGSM49BAMCMIGAMQswCQYDVQQGEwJVUzERMA8GA1UECAwITWFyeWxhbmQx'
    'EjAQBgNVBAoMCVNvbG8gS2V5czEQMA4GA1UECwwHUm9vdCBDQTEVMBMGA1UEAwwMc29sb2tleXMuY29tMSEwHwYJKoZIhvcNAQkBFhJoZWxsb0Bzb2'
    'xva2V5cy5jb20wIBcNMTgxMTExMTI1MjAwWhgPMjA2ODEwMjkxMjUyMDBaMIGSMQswCQYDVQQGEwJVUzERMA8GA1UECAwITWFyeWxhbmQxEjAQBgNV'
    'BAoMCVNvbG8gS2V5czEiMCAGA1UECwwZQXV0aGVudGljYXRvciBBdHRlc3RhdGlvbjEVMBMGA1UEAwwMc29sb2tleXMuY29tMSEwHwYJKoZIhvcNAQ'
    'kBFhJoZWxsb0Bzb2xva2V5cy5jb20wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQi/g+1Kni+xkU3GiinV0NJpG+FTcpOJRyfdTA9vxDV0tILuWks'
    '3bJcFNg5hRL2I+6Rusas/0oaJ+/gwVQ/1NnFo4HcMIHZMB0GA1UdDgQWBBQ75tLAb/LnsHydnijAILANB8gVyDCBnwYDVR0jBIGXMIGUoYGGpIGDMI'
    'GAMQswCQYDVQQGEwJVUzERMA8GA1UECAwITWFyeWxhbmQxEjAQBgNVBAoMCVNvbG8gS2V5czEQMA4GA1UECwwHUm9vdCBDQTEVMBMGA1UEAwwMc29s'
    'b2tleXMuY29tMSEwHwYJKoZIhvcNAQkBFhJoZWxsb0Bzb2xva2V5cy5jb22CCQDER2OSj/S+jDAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DAKBggqhk'
    'jOPQQDAgNHADBEAiBxEEYs9RYYl1XKZFA7abLfF3GrrY7A1qYHPWaKO7v+YQIgHoLv615OOgCEZNL4hMN4NZNjgS6+phIybimQyJFLcVJoYXV0aERh'
    'dGFYtKRgp/3JtYGMyzeC9e1zuT2yDCyGWo+z7ug7R7EmMX8FQQAAAAAAAAAAAAAAAAAAAAAAAAAAADDWVlHUfNwvfO0dhBC25QMLgamsHKy0Hvzwsi'
    '/J5sXWIdRfGmQurcz9H6owmA12H3ClAQIDJiABIVggZTB/2wy+Rpwjt6VEGtjBY0fQPnQ9Aj4A79F0LnfFRUEiWCBH2j40STt5MtcqxYDcMBMz76m8'
    'ohTkcbB4n4M0v34RFg==')

ATTESTATION_OBJECT_U2F_NO_EXT = (
    'o2NmbXRoZmlkby11MmZnYXR0U3RtdKJjc2lnWEgwRgIhAI3SgMps+o5Z7bZlb5qFuy6cE+ii/w0FAvV6x3PChl6cAiEA2xhY1pHNZJPkLt3AF8Hz6Y'
    'WqkC9f925IK9oUb29DT7hjeDVjgVkCwTCCAr0wggGloAMCAQICBAsFzVMwDQYJKoZIhvcNAQELBQAwLjEsMCoGA1UEAxMjWXViaWNvIFUyRiBSb290'
    'IENBIFNlcmlhbCA0NTcyMDA2MzEwIBcNMTQwODAxMDAwMDAwWhgPMjA1MDA5MDQwMDAwMDBaMG4xCzAJBgNVBAYTAlNFMRIwEAYDVQQKDAlZdWJpY2'
    '8gQUIxIjAgBgNVBAsMGUF1dGhlbnRpY2F0b3IgQXR0ZXN0YXRpb24xJzAlBgNVBAMMHll1YmljbyBVMkYgRUUgU2VyaWFsIDE4NDkyOTYxOTBZMBMG'
    'ByqGSM49AgEGCCqGSM49AwEHA0IABCEab7G1iSXLCsEYX3wq46i0iBAUebEe//VV4H2XUb0rF2olLe5Z7OOFmSBbs+oov4/X/H2nXAVCcq5IWOWR/F'
    'qjbDBqMCIGCSsGAQQBgsQKAgQVMS4zLjYuMS40LjEuNDE0ODIuMS4xMBMGCysGAQQBguUcAgEBBAQDAgQwMCEGCysGAQQBguUcAQEEBBIEEBSaICGO'
    '9kEzlriB+NW38fUwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsFAAOCAQEAPv6j3z0q4HJXj34E0N1aS2jbAa/oYy4YtOC4c0MYkRlsGEvrwdUzoj'
    '13i7EECMG5qkFOdXaFWwk2lxizSK9c72ywMIZy1h+4vZuGoQqmgs6MLU7wkO1QVBj+U9TOHmJ6KPNyAwlY0I/6WRvEGIDhjooM7RqFgH+QlnFBegtF'
    'MhWzjcFHKiRJdkC06Gv+xPFUY5uFuOiAFJY2JDg1WQEr/Id8C0TsfaeU0gZUsprcHbpcUHvwym3zUrzN3nQNLqfhCCSizjlPkE0dmUFeOnxFtf4oep'
    'vL3GmOi9zVtHmKXO013oo1CQIKFLcmv785p0QHnLmPW53KCbfD67y9oq9pA2hhdXRoRGF0YVjE9FR+LIHBsaZUrxRNi6E9zd92FfIlIzUryD7iZVpL'
    '4uFBAAAAAAAAAAAAAAAAAAAAAAAAAAAAQILKbpBcBL35jQMpW8uf4aZcdmuIS81wq1sNlrdEekqi/0vT6ATO4KsJ92vWK/0WWsefqj9JYu1EnbyFoY'
    'lR2FqlAQIDJiABIVggux8U5a6+O7c5Xy+y/KFBfLqHJBMk9tY6Pmpym22yWzAiWCAWEHFSicquecrC2cJ5dkfyMIoVwgft96x2O/AhQvcIHA==')

# fido-u2f attestation with some random character changed
ATTESTATION_OBJECT_U2F_MALFORMED = (
    'owFoZmlkby11MmYCWMTr2rckepjnyU3pMGbSTDiv2aDKKY42hLR6uxEx/MnyAEEAAAAAAAAAAAAAAAAAAAAAAAAAAABAVKZJP1j2BAl+NE9Ho0pa+T'
    'ybzzmoI4XbU/MvHCr7lQBJc3O5WvHF9B85RIk2ZEyRSwVHh8MW+te50I9juwr6gqUBAgMmIAEhWCDhTkbEO9WpfLwhmoLoPnka4fFANkMYCqhpxI6V'
    'jSDt1CJYIPirPpi/vXbFj/xN9eCGW+rTRQvplmahLa2SupgsLQkwA6Jjc2lnWEcwRQIgP4FTyNoVKsH4/f1TBlqJV5kRpIJR3Kof7N7hHygMyaECIQ'
    'DK+UaV3uOSS7QQ2p1OmDxwpOpakKwRGL1yVLq7QyLsE2N4NWOBWQJIMIICRDCCAS6gAwIBAgIEeMDfDjALBgkqhkiG9w0BAQswLjEsMCoGA1UEAxMj'
    'WXViaWNvIFUyRiBSb290IENBIFNlcmlhbCA0NTcyMDA2MzEwIBcNMTQwODAxMDAwMDAwWhgPMjA1MDA5MDQwMDAwMDBaMCoxKDAmBgNVBAMMH1l1Ym'
    'ljbyBVMkYgRUUgU2VyaWFsIDIwMjU5MDU5MzQwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAS1uHFcg/3+DqFcRXeshY30jBdv3oedyvS4PUDTIPJv'
    'reYl/Pf1yK/YNRj4254h7Ag7GEWAxxfsSkcLlopvuj9vozswOTAiBgkrBgEEAYLECgIEFTEuMy42LjEuNC4xLjQxNDgyLjEuMTATBgsrBgEEAYLlHA'
    'IBAQQEAwIFIDALBgkqhkiG9w0BAQsDggEBAD72q/ZKkWsL+ZSTjdyVNOBUQAJoVninLEOnq+ZdkGX/YfRRzoo67thmidGQuVCvAHpU0THu8G/ia06n'
    'uz4yt5IFpd+nYAQ0U+NK+ETDfNSoX4xcLYcOCiiyt+1EAkH9s3krIHaw4Yr6m0Mu7vwmWLoJBcQbJKk8bsi7ptVvM+jWU9fPa9UBVFWiZZdA99zFHM'
    'AxYJzQPqbN6Tmeygh2MpB2P7TI0A9WkGmhJUkAauuwaiGiFOSZmDe0KegdflbTOlSS3ToWHIKTlUCBqn7vdJw6Vj2919ujlcxHPkRpbUGRhcJDesg6'
    'wGTBy+RyJ/96G3fH1eoMNn1F9jC9mY1Zsm4=')

ATTESTATION_OBJECT_BOGUS = (
    'owFFYm9ndXMCWMTr2rckepjnyU3pMGbSTDiv2aDKKY42hLR6uxEx/MnyAEEAAAAAAAAAAAAAAAAAAAAAAAAAAABAVKZJP1j2MAl+NE9Ho0pa+Tybzz'
    'moI4XbU/MvHCr7lQBJc3O5WvHF9B85RIk2ZEyRSwVHh8MW+te50I9juwr6gqUBAgMmIAEhWCDhTkbEO9WpfLwhmoLoPnka4fFANkMYCqhpxI6VjSDt'
    '1CJYIPirPpi/vXbFj/xN9eCGW+rTRQvplmahLa2SupgsLQkwA6Jjc2lnWEcwRQIgP4FTyNoVKsH4/f1TBlqJV5kRpIJR3Kof7N7hHygMyaECIQDK+U'
    'aV3uOSS7QQ2p1OmDxwpOpakKwRGL1yVLq7QyLsE2N4NWOBWQJIMIICRDCCAS6gAwIBAgIEeMDfDjALBgkqhkiG9w0BAQswLjEsMCoGA1UEAxMjWXVi'
    'aWNvIFUyRiBSb290IENBIFNlcmlhbCA0NTcyMDA2MzEwIBcNMTQwODAxMDAwMDAwWhgPMjA1MDA5MDQwMDAwMDBaMCoxKDAmBgNVBAMMH1l1Ymljby'
    'BVMkYgRUUgU2VyaWFsIDIwMjU5MDU5MzQwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAS1uHFcg/3+DqFcRXeshY30jBdv3oedyvS4PUDTIPJvreYl'
    '/Pf1yK/YNRj4254h7Ag7GEWAxxfsSkcLlopvuj9vozswOTAiBgkrBgEEAYLECgIEFTEuMy42LjEuNC4xLjQxNDgyLjEuMTATBgsrBgEEAYLlHAIBAQ'
    'QEAwIFIDALBgkqhkiG9w0BAQsDggEBAD72q/ZKkWsL+ZSTjdyVNOBUQAJoVninLEOnq+ZdkGX/YfRRzoo67thmidGQuVCvAHpU0THu8G/ia06nuz4y'
    't5IFpd+nYAQ0U+NK+ETDfNSoX4xcLYcOCiiyt+1EAkH9s3krIHaw4Yr6m0Mu7vwmWLoJBcQbJKk8bsi7ptVvM+jWU9fPa9UBVFWiZZdA99zFHMAxYJ'
    'zQPqbN6Tmeygh2MpB2P7TI0A9WkGmhJUkAauuwaiGiFOSZmDe0KegdflbTOlSS3ToWHIKTlUCBqn7vdJw6Vj2919ujlcxHPkRpbUGRhcJDesg6wGTB'
    'y+RyJ/96G3fH1eoMNn1F9jC9mY1Zsm4=')

DETAILED_METADATA = {
    'attestationRootCertificates': [
        'MIICpTCCAkqgAwIBAgIBATAKBggqhkjOPQQDAjCBrzELMAkGA1UEBhMCS1IxETAPBgNVBAgMCFNlb3VsLVNpMRMwEQYDVQQHDApHYW5nbmFtLU'
        'd1MRcwFQYDVQQKDA5lV0JNIENvLiwgTHRkLjEiMCAGA1UECwwZQXV0aGVudGljYXRvciBBdHRlc3RhdGlvbjEcMBoGA1UEAwwTZVdCTSBDQSBD'
        'ZXJ0aWZpY2F0ZTEdMBsGCSqGSIb3DQEJARYOaW5mb0BlLXdibS5jb20wHhcNMTgwNzAyMDUzMTM5WhcNMjMwNzAxMDUzMTM5WjCBrzELMAkGA1'
        'UEBhMCS1IxETAPBgNVBAgMCFNlb3VsLVNpMRMwEQYDVQQHDApHYW5nbmFtLUd1MRcwFQYDVQQKDA5lV0JNIENvLiwgTHRkLjEiMCAGA1UECwwZ'
        'QXV0aGVudGljYXRvciBBdHRlc3RhdGlvbjEcMBoGA1UEAwwTZVdCTSBDQSBDZXJ0aWZpY2F0ZTEdMBsGCSqGSIb3DQEJARYOaW5mb0BlLXdibS'
        '5jb20wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQIfqHisi0oO/eyOqSaDrr9itG2IymBkHnSDGQIIYmT+vqA8AgO81momc2Ld5PGpEN6muE5'
        '4wPHQjvc/yCih8u2o1UwUzASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS3J/fxiAv22irdBs98SODhF7kU/jALBgNVHQ8EBAMCAQYwEQ'
        'YJYIZIAYb4QgEBBAQDAgAHMAoGCCqGSM49BAMCA0kAMEYCIQDc41LFK4LJCBU2VVKIz7Z6sxPhUEkh8nLSLK6IXdkP5wIhAIeKVOZchaVO5aF7'
        'fbdXoSrcyy1YYeUePLojcKI9fX84'],
}

DETAILED_METADATA_ATTESTATION_KEYS = {
    'attestationRootCertificates': [
        'MIIB9DCCAZoCCQDER2OSj/S+jDAKBggqhkjOPQQDAjCBgDELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE1hcnlsYW5kMRIwEAYDVQQKDAlTb2xvIE'
        'tleXMxEDAOBgNVBAsMB1Jvb3QgQ0ExFTATBgNVBAMMDHNvbG9rZXlzLmNvbTEhMB8GCSqGSIb3DQEJARYSaGVsbG9Ac29sb2tleXMuY29tMCAX'
        'DTE4MTExMTEyNTE0MloYDzIwNjgxMDI5MTI1MTQyWjCBgDELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE1hcnlsYW5kMRIwEAYDVQQKDAlTb2xvIE'
        'tleXMxEDAOBgNVBAsMB1Jvb3QgQ0ExFTATBgNVBAMMDHNvbG9rZXlzLmNvbTEhMB8GCSqGSIb3DQEJARYSaGVsbG9Ac29sb2tleXMuY29tMFkw'
        'EwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEWHAN0CCJVZdMs0oktZ5m93uxmB1iyq8ELRLtqVFLSOiHQEab56qRTB/QzrpGAY++Y2mw+vRuQMNhBi'
        'U0KzwjBjAKBggqhkjOPQQDAgNIADBFAiEAz9SlrAXIlEu87vra54rICPs+4b0qhp3PdzcTg7rvnP0CIGjxzlteQQx+jQGd7rwSZuE5RWUPVygY'
        'hUstQO9zNUOs'],
}

DETAILED_METADATA_ATTESTATION_KEYS_NO_EXT = {
    "attestationRootCertificates": [
        'MIIDHjCCAgagAwIBAgIEG0BT9zANBgkqhkiG9w0BAQsFADAuMSwwKgYDVQQDEyNZdWJpY28gVTJGIFJvb3QgQ0EgU2VyaWFsIDQ1NzIwMDYzMT'
        'AgFw0xNDA4MDEwMDAwMDBaGA8yMDUwMDkwNDAwMDAwMFowLjEsMCoGA1UEAxMjWXViaWNvIFUyRiBSb290IENBIFNlcmlhbCA0NTcyMDA2MzEw'
        'ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC/jwYuhBVlqaiYWEMsrWFisgJ+PtM91eSrpI4TK7U53mwCIawSDHy8vUmk5N2KAj9abv'
        'T9NP5SMS1hQi3usxoYGonXQgfO6ZXyUA9a+KAkqdFnBnlyugSeCOep8EdZFfsaRFtMjkwz5Gcz2Py4vIYvCdMHPtwaz0bVuzneueIEz6TnQjE6'
        '3Rdt2zbwnebwTG5ZybeWSwbzy+BJ34ZHcUhPAY89yJQXuE0IzMZFcEBbPNRbWECRKgjq//qT9nmDOFVlSRCt2wiqPSzluwn+v+suQEBsUjTGME'
        'd25tKXXTkNW21wIWbxeSyUoTXwLvGS6xlwQSgNpk2qXYwf8iXg7VWZAgMBAAGjQjBAMB0GA1UdDgQWBBQgIvz0bNGJhjgpToksyKpP9xv9oDAP'
        'BgNVHRMECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAQEAjvjuOMDSa+JXFCLyBKsycXtBVZsJ4Ue3LbaEsPY4MY'
        'N/hIQ5ZM5p7EjfcnMG4CtYkNsfNHc0AhBLdq45rnT87q/6O3vUEtNMafbhU6kthX7Y+9XFN9NpmYxr+ekVY5xOxi8h9JDIgoMP4VB1uS0aunL1'
        'IGqrNooL9mmFnL2kLVVee6/VR6C5+KSTCMCWppMuJIZII2v9o4dkoZ8Y7QRjQlLfYzd3qGtKbw7xaF1UsG/5xUb/Btwb2X2g4InpiB/yt/3CpQ'
        'XpiWX/K4mBvUKiGn05ZsqeY1gx4g0xLBqcU9psmyPzK+Vsgw2jeRQ5JlKDyqE0hebfC1tvFu0CCrJFcw=='],
}

DETAILED_METADATA_WRONG_CERT = {
    'attestationRootCertificates': [
        'MIIEzjCCAragAwIBAgIDAWrwMA0GCSqGSIb3DQEBCwUAMBAxDjAMBgNVBAMMBXRv'
        'bWFzMB4XDTE5MDExNDA5MzY0NVoXDTI5MDExMTA5MzY0NVowEDEOMAwGA1UEAwwF'
        'dG9tYXMwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDPK+4k1AIuGG48'
        'dYso6ICHnYnFQ8jtyDUOuX87AcrLqVfqhmfe6fbjiP13s8xO0670ye+l770zStgL'
        '4NuKqa1kcVifRVBKa6Ut98h0SEcOP4QrEOaMHs8Z9HsRnxG9aFWyil3qg3X6P4yZ'
        'K/LdxBt0WfBn34gICv3A0V52lwfZoRKC62scU9TQ7LlE2sNYd5ScbFvE5t2OCvuM'
        'kilTSCFEQ9y4ryKcSMtbFzjQRFmZLLV06uNVW5Lj4r/uJwEYDtCicho5GV2lAHhV'
        'vYYooAneUtA7F+2qZrErWzvMOGegCeW5hOwo6P8XZkkW4P3tQ87ch2gUzhMF0PLa'
        'uuQC+hzqHHWWHIElf2r0xgcmZT9tgVQurYRfSnzx2V+jUsiT2nCT7DYIuoIhCqNa'
        'FPlQif9iYtCihs4A7TZBrGFWaoUjitWFQ6TdQ2jfK+ufLM/ns9CSreteh2kI+tbQ'
        'WK9PMmM/T89Ng3/8M8Y685cwNKL4O643N0wDGAJNRmAIm7bmDi8wDtsP/GwyMv/y'
        'tYZq69pNqsWKLjf7iJSx4n3Vg+wxNuQimt9IiWqDrgIlkA7k54cWvihCsoD1JdHb'
        'z5aCRTLjjnlGiGSa3/tFyGDG9L1/KQA9UlxTkBPjB42p/IqnxPZ0BXLTHZ5ATLhe'
        'Vfb+3cS8BFeTZV6zCz4LPAawlJTR9QIDAQABozEwLzAtBgNVHREEJjAkggcqLnRv'
        'bWFzghkqLnRvbWFzLmRldi5vZmZpY2UubmljLmN6MA0GCSqGSIb3DQEBCwUAA4IC'
        'AQCXFuTIVDm0JtKisWlix+FLd3nDg8QLP/SCrRjxUwpqZYPf4gy04wUTOTn0CEwN'
        't1RkeQnJkvWDwcgQmsE3OyFVjQHd46iOIGVcpEFJLSLAgAz+mDQG7N5Q3UHyjqZb'
        '23tCQezZyWLvLRnwdqYwpjhBGv4F1lj12VFHDSgkbM1cMO9ONE3FapSvCosY57t6'
        'YPZJAWZPEjjB38kCd283LKeE3l1P84k5yb/O1ZlLD6FRJbqdhyTwKnm8++NNnT14'
        'QrWTLUzbuaZpxz2i/rv6T9d4C7fkiCYJOmF/NK1ro0RBc5x3Sj3O99DqcRiChglk'
        'd84vJTXsOMl4NpY4ukUyUIa73YmIcFV3WIQ4jhn8SnOAqsodtZETKVtuvUurwlN0'
        'a7C6yeYKL2m3YwhtLmlf76sPwzri+xTBerSCwJlPup/OOgwT3f8LDoWu2iuwIuKG'
        'KhmEtDSt9JHinHneGXpl2d/HYqOgBcBdi6T3erL0fmmpCD6P84frao2nFkUIj5XJ'
        'mf213Gbp9WPLiyYFoVn7ViOHWXydaBM8E0u+YvimUh96nGlIex2yuFYH6UTBk1w0'
        'KsZOYhrxE3kgKZH3/kOudSTEq0nkfh07jr7lwGBSK70w0ESbNuJzYsdhE7zMeVXA'
        '3sfdbKpJjd5NUSIDLl6hal9076VE2erfPaeRYeyvaYzUcg=='],
}
