[![Build Status](https://dev.azure.com/Lumispy/lumispy/_apis/build/status/LumiSpy.lumispy?branchName=main)](https://dev.azure.com/Lumispy/lumispy/_build/latest?definitionId=3&branchName=main)
[![Tests](https://github.com/lumispy/lumispy/workflows/Tests/badge.svg)](https://github.com/lumispy/lumispy/actions)
[![Codecov Status](https://codecov.io/gh/lumispy/lumispy/branch/main/graph/badge.svg?token=8ZFX8X4Z1I)](https://codecov.io/gh/lumispy/lumispy)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.4640445.svg)](https://doi.org/10.5281/zenodo.4640445)

[![Python Version](https://img.shields.io/pypi/pyversions/lumispy.svg?style=flat)](https://pypi.python.org/pypi/lumispy)
[![PyPi Version](http://img.shields.io/pypi/v/lumispy.svg?style=flat)](https://pypi.python.org/pypi/lumispy)
[![Anaconda Version](https://anaconda.org/conda-forge/lumispy/badges/version.svg)](https://anaconda.org/conda-forge/lumispy)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Documentation Status](https://readthedocs.org/projects/lumispy/badge/?version=latest)](https://lumispy.readthedocs.io/en/latest/?badge=latest)


<img src="https://github.com/LumiSpy/lumispy/raw/main/doc/_static/logo_rec_april21.svg" width="300" alt="LumiSpy">

LumiSpy is a Python package extending the functionality for multi-dimensional
data analysis provided by the [HyperSpy](https://hyperspy.org) library. It is
aimed at helping with the analysis of luminescence spectroscopy data
(cathodoluminescence, photoluminescence, electroluminescence, Raman, SNOM).

If analysis using LumiSpy forms a part of published work, please consider 
recognising the code development by citing the project using the
[Zenodo-DOI](https://doi.org/10.5281/zenodo.4640445).

Go to the documentation for instructions on how to install LumiSpy and start an
analysis: [Read the docs](https://lumispy.readthedocs.io).

[Tutorials and exemplary workflows](https://github.com/lumispy/lumispy-demos)
have been curated as a series of Jupyter notebooks that you can work through 
and modify to perform many common analyses. These can be either downloaded and
run locally or tried out using interactive online sessions.

Everyone is welcome to contribute. Please read our
[contributing guidelines](https://github.com/LumiSpy/lumispy/blob/main/CONTRIBUTING.rst) and get started!

Development of LumiSpy is documented in the
[changelog](https://github.com/LumiSpy/lumispy/blob/main/CHANGELOG.rst).
