#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.app.portfwd',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20210316',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Manage persistent ssh tunnels and port forwards.',
  long_description =
    ('Manage persistent ssh tunnels and port forwards.\n'    
 '\n'    
 '*Latest release 20210316*:\n'    
 '* Portfwds: accept any iterable for target_list.\n'    
 '* Portability fix.\n'    
 '\n'    
 'Portfwd runs a collection of ssh tunnel commands persistently,\n'    
 'each in its own `cs.app.svcd <https://pypi.org/project/cs.app.svcd>`_ '    
 'instance\n'    
 'with all the visibility and process control that SvcD brings.\n'    
 '\n'    
 'It reads tunnel preconditions from special comments within the ssh config '    
 'file.\n'    
 'It uses the configuration options from the config file\n'    
 'as the SvcD signature function\n'    
 'thus restarting particular ssh tunnels when their specific configuration '    
 'changes.\n'    
 'It has an "automatic" mode (the -A option)\n'    
 'which monitors the desired list of tunnels\n'    
 'from statuses expressed via `cs.app.flag '    
 '<https://pypi.org/project/cs.app.flag>`_\n'    
 'which allows live addition or removal of tunnels as needed.\n'    
 '\n'    
 '## Function `Condition(portfwd, op, invert, *args)`\n'    
 '\n'    
 'Factory to construct a condition from a specification.\n'    
 '\n'    
 '## Class `FlagCondition(_PortfwdCondition)`\n'    
 '\n'    
 'A flag based condition.\n'    
 '\n'    
 '### Method `FlagCondition.test(self, trace=False)`\n'    
 '\n'    
 'Core test, before inversion.\n'    
 '\n'    
 '## Function `main(argv=None, environ=None)`\n'    
 '\n'    
 'Command line main programme.\n'    
 '\n'    
 '## Class `PingCondition(_PortfwdCondition)`\n'    
 '\n'    
 'A ping based condition.\n'    
 '\n'    
 '### Method `PingCondition.test(self, trace=False)`\n'    
 '\n'    
 'Ping the target as a test.\n'    
 '\n'    
 '## Class `Portfwd(cs.app.flag.FlaggedMixin)`\n'    
 '\n'    
 'An ssh tunnel built on a SvcD.\n'    
 '\n'    
 '### Method `Portfwd.__init__(self, target, ssh_config=None, conditions=(), '    
 'test_shcmd=None, trace=False, verbose=False, flags=None)`\n'    
 '\n'    
 'Initialise the Portfwd.\n'    
 '\n'    
 'Parameters:\n'    
 '* `target`: the tunnel name, and also the name of the ssh configuration '    
 'used\n'    
 '* `ssh_config`: ssh configuration file if not the default\n'    
 '* `conditions`: an iterable of `Condition`s\n'    
 '  which must hold before the tunnel is set up;\n'    
 '  the tunnel also aborts if these cease to hold\n'    
 '* `test_shcmd`: a shell command which must succeed\n'    
 '  before the tunnel is set up;\n'    
 '  the tunnel also aborts if this command subsequently fails\n'    
 '* `trace`: issue tracing messages; default `False`\n'    
 '* `verbose`: be verbose; default `False`\n'    
 '* `flags`: optional preexisting `Flags` instance\n'    
 '\n'    
 '### Method `Portfwd.on_reap(self)`\n'    
 '\n'    
 'Actions to perform after the ssh tunnel exits.\n'    
 '\n'    
 '### Method `Portfwd.on_spawn(self)`\n'    
 '\n'    
 'Actions to perform before commencing the ssh tunnel.\n'    
 '\n'    
 'Initially remove local socket paths.\n'    
 '\n'    
 '### Method `Portfwd.ssh_argv(self, bare=False)`\n'    
 '\n'    
 'An ssh command line argument list.\n'    
 '\n'    
 '`bare`: just to command and options, no trailing "--".\n'    
 '\n'    
 '### Method `Portfwd.ssh_options(self)`\n'    
 '\n'    
 'Return a defaultdict(list) of `{option: values}`\n'    
 'representing the ssh configuration.\n'    
 '\n'    
 '### Method `Portfwd.start(self)`\n'    
 '\n'    
 'Call the service start method.\n'    
 '\n'    
 '### Method `Portfwd.stop(self)`\n'    
 '\n'    
 'Call the service stop method.\n'    
 '\n'    
 '### Method `Portfwd.test_func(self)`\n'    
 '\n'    
 'Servuice test function: probe all the conditions.\n'    
 '\n'    
 '### Method `Portfwd.wait(self)`\n'    
 '\n'    
 'Call the service wait method.\n'    
 '\n'    
 '## Class `Portfwds`\n'    
 '\n'    
 'A collection of `Portfwd` instances and associated control methods.\n'    
 '\n'    
 '### Method `Portfwds.__init__(self, ssh_config=None, environ=None, '    
 'target_list=None, auto_mode=None, trace=False, verbose=False, flags=None)`\n'    
 '\n'    
 'Initialise the `Portfwds` instance.\n'    
 '\n'    
 'Parameters:\n'    
 '* `ssh_config`: the ssh configuration file if not the default\n'    
 '* `environ`: the environment mapping to use;\n'    
 '  default: `os.environ`\n'    
 '* `target_list`: an iterable of `Portfwd` target names\n'    
 '* `auto_mode`: also derive target names\n'    
 '  from the set of true `PORTFWD_`*name*`_AUTO` flags\n'    
 '* `trace`: trace mode, default `False`\n'    
 '* `verbose`: verbose mode, default `False`\n'    
 '* `flags`: the `cs.app.flags.Flags` instance to use,\n'    
 '  default is to construct a new one\n'    
 '\n'    
 '### Method `Portfwds.forward(self, target)`\n'    
 '\n'    
 'Obtain the named Portfwd, creating it if necessary.\n'    
 '\n'    
 '### Property `Portfwds.forwards`\n'    
 '\n'    
 'A list of the existing Portfwd instances.\n'    
 '\n'    
 '### Method `Portfwds.resolve_target_spec(self, spec)`\n'    
 '\n'    
 'Accept a target spec and expand it if it is a group.\n'    
 'Return a set of targets.\n'    
 '\n'    
 '### Method `Portfwds.start(self)`\n'    
 '\n'    
 'Start all nonrunning targets, stop all running nonrequired targets.\n'    
 '\n'    
 '### Method `Portfwds.stop(self)`\n'    
 '\n'    
 'Stop all running targets.\n'    
 '\n'    
 '### Method `Portfwds.targets_required(self)`\n'    
 '\n'    
 'The concrete list of targets.\n'    
 '\n'    
 'Computed from the target spec and, if in auto mode, the\n'    
 'PORTFWD_*_AUTO flags.\n'    
 '\n'    
 '### Method `Portfwds.wait(self)`\n'    
 '\n'    
 'Wait for all running targets to stop.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20210316*:\n'    
 '* Portfwds: accept any iterable for target_list.\n'    
 '* Portability fix.\n'    
 '\n'    
 '*Release 20190602*:\n'    
 '* Support alert groups.\n'    
 '* ssh_argv no longer a property in order to support `bare` param.\n'    
 '* New method `ssh_options` to wrap ssh_argv.\n'    
 '* Drop sig_func, use ssh_options instead.\n'    
 '* Remove local UNIX domain socket forward endpoints before starting ssh '    
 'tunnel.\n'    
 '* Improve option parse.\n'    
 '\n'    
 '*Release 20170906*:\n'    
 'Initial PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  entry_points = {'console_scripts': ['portfwd = cs.app.portfwd:main']},
  install_requires = ['cs.app.flag', 'cs.app.svcd', 'cs.env', 'cs.logutils', 'cs.pfx', 'cs.psutils', 'cs.py.func', 'cs.py3', 'cs.sh'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.app.portfwd'],
)
