import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface AcmCertificateConfig extends TerraformMetaArguments {
    readonly certificateAuthorityArn?: string;
    readonly certificateBody?: string;
    readonly certificateChain?: string;
    readonly domainName?: string;
    readonly privateKey?: string;
    readonly subjectAlternativeNames?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly validationMethod?: string;
    /** options block */
    readonly options?: AcmCertificateOptions[];
}
export declare class AcmCertificateDomainValidationOptions extends ComplexComputedList {
    get domainName(): string;
    get resourceRecordName(): string;
    get resourceRecordType(): string;
    get resourceRecordValue(): string;
}
export interface AcmCertificateOptions {
    readonly certificateTransparencyLoggingPreference?: string;
}
export declare class AcmCertificate extends TerraformResource {
    constructor(scope: Construct, id: string, config?: AcmCertificateConfig);
    get arn(): string;
    private _certificateAuthorityArn?;
    get certificateAuthorityArn(): string | undefined;
    set certificateAuthorityArn(value: string | undefined);
    private _certificateBody?;
    get certificateBody(): string | undefined;
    set certificateBody(value: string | undefined);
    private _certificateChain?;
    get certificateChain(): string | undefined;
    set certificateChain(value: string | undefined);
    private _domainName?;
    get domainName(): string | undefined;
    set domainName(value: string | undefined);
    domainValidationOptions(index: string): AcmCertificateDomainValidationOptions;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    get status(): string;
    private _subjectAlternativeNames?;
    get subjectAlternativeNames(): string[] | undefined;
    set subjectAlternativeNames(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get validationEmails(): string[];
    private _validationMethod?;
    get validationMethod(): string | undefined;
    set validationMethod(value: string | undefined);
    private _options?;
    get options(): AcmCertificateOptions[] | undefined;
    set options(value: AcmCertificateOptions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
