import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AcmpcaCertificateAuthorityConfig extends TerraformMetaArguments {
    readonly enabled?: boolean;
    readonly permanentDeletionTimeInDays?: number;
    readonly tags?: {
        [key: string]: string;
    };
    readonly type?: string;
    /** certificate_authority_configuration block */
    readonly certificateAuthorityConfiguration: AcmpcaCertificateAuthorityCertificateAuthorityConfiguration[];
    /** revocation_configuration block */
    readonly revocationConfiguration?: AcmpcaCertificateAuthorityRevocationConfiguration[];
    /** timeouts block */
    readonly timeouts?: AcmpcaCertificateAuthorityTimeouts;
}
export interface AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject {
    readonly commonName?: string;
    readonly country?: string;
    readonly distinguishedNameQualifier?: string;
    readonly generationQualifier?: string;
    readonly givenName?: string;
    readonly initials?: string;
    readonly locality?: string;
    readonly organization?: string;
    readonly organizationalUnit?: string;
    readonly pseudonym?: string;
    readonly state?: string;
    readonly surname?: string;
    readonly title?: string;
}
export interface AcmpcaCertificateAuthorityCertificateAuthorityConfiguration {
    readonly keyAlgorithm: string;
    readonly signingAlgorithm: string;
    /** subject block */
    readonly subject: AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject[];
}
export interface AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration {
    readonly customCname?: string;
    readonly enabled?: boolean;
    readonly expirationInDays: number;
    readonly s3BucketName?: string;
}
export interface AcmpcaCertificateAuthorityRevocationConfiguration {
    /** crl_configuration block */
    readonly crlConfiguration?: AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration[];
}
export interface AcmpcaCertificateAuthorityTimeouts {
    readonly create?: string;
}
export declare class AcmpcaCertificateAuthority extends TerraformResource {
    constructor(scope: Construct, id: string, config: AcmpcaCertificateAuthorityConfig);
    get arn(): string;
    get certificate(): string;
    get certificateChain(): string;
    get certificateSigningRequest(): string;
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get notAfter(): string;
    get notBefore(): string;
    private _permanentDeletionTimeInDays?;
    get permanentDeletionTimeInDays(): number | undefined;
    set permanentDeletionTimeInDays(value: number | undefined);
    get serial(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    private _certificateAuthorityConfiguration;
    get certificateAuthorityConfiguration(): AcmpcaCertificateAuthorityCertificateAuthorityConfiguration[];
    set certificateAuthorityConfiguration(value: AcmpcaCertificateAuthorityCertificateAuthorityConfiguration[]);
    private _revocationConfiguration?;
    get revocationConfiguration(): AcmpcaCertificateAuthorityRevocationConfiguration[] | undefined;
    set revocationConfiguration(value: AcmpcaCertificateAuthorityRevocationConfiguration[] | undefined);
    private _timeouts?;
    get timeouts(): AcmpcaCertificateAuthorityTimeouts | undefined;
    set timeouts(value: AcmpcaCertificateAuthorityTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
