import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AlbListenerRuleConfig extends TerraformMetaArguments {
    readonly listenerArn: string;
    readonly priority?: number;
    /** action block */
    readonly action: AlbListenerRuleAction[];
    /** condition block */
    readonly condition: AlbListenerRuleCondition[];
}
export interface AlbListenerRuleActionAuthenticateCognito {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly userPoolArn: string;
    readonly userPoolClientId: string;
    readonly userPoolDomain: string;
}
export interface AlbListenerRuleActionAuthenticateOidc {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly authorizationEndpoint: string;
    readonly clientId: string;
    readonly clientSecret: string;
    readonly issuer: string;
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly tokenEndpoint: string;
    readonly userInfoEndpoint: string;
}
export interface AlbListenerRuleActionFixedResponse {
    readonly contentType: string;
    readonly messageBody?: string;
    readonly statusCode?: string;
}
export interface AlbListenerRuleActionForwardStickiness {
    readonly duration: number;
    readonly enabled?: boolean;
}
export interface AlbListenerRuleActionForwardTargetGroup {
    readonly arn: string;
    readonly weight?: number;
}
export interface AlbListenerRuleActionForward {
    /** stickiness block */
    readonly stickiness?: AlbListenerRuleActionForwardStickiness[];
    /** target_group block */
    readonly targetGroup: AlbListenerRuleActionForwardTargetGroup[];
}
export interface AlbListenerRuleActionRedirect {
    readonly host?: string;
    readonly path?: string;
    readonly port?: string;
    readonly protocol?: string;
    readonly query?: string;
    readonly statusCode: string;
}
export interface AlbListenerRuleAction {
    readonly order?: number;
    readonly targetGroupArn?: string;
    readonly type: string;
    /** authenticate_cognito block */
    readonly authenticateCognito?: AlbListenerRuleActionAuthenticateCognito[];
    /** authenticate_oidc block */
    readonly authenticateOidc?: AlbListenerRuleActionAuthenticateOidc[];
    /** fixed_response block */
    readonly fixedResponse?: AlbListenerRuleActionFixedResponse[];
    /** forward block */
    readonly forward?: AlbListenerRuleActionForward[];
    /** redirect block */
    readonly redirect?: AlbListenerRuleActionRedirect[];
}
export interface AlbListenerRuleConditionHostHeader {
    readonly values?: string[];
}
export interface AlbListenerRuleConditionHttpHeader {
    readonly httpHeaderName: string;
    readonly values: string[];
}
export interface AlbListenerRuleConditionHttpRequestMethod {
    readonly values: string[];
}
export interface AlbListenerRuleConditionPathPattern {
    readonly values?: string[];
}
export interface AlbListenerRuleConditionQueryString {
    readonly key?: string;
    readonly value: string;
}
export interface AlbListenerRuleConditionSourceIp {
    readonly values: string[];
}
export interface AlbListenerRuleCondition {
    readonly field?: string;
    readonly values?: string[];
    /** host_header block */
    readonly hostHeader?: AlbListenerRuleConditionHostHeader[];
    /** http_header block */
    readonly httpHeader?: AlbListenerRuleConditionHttpHeader[];
    /** http_request_method block */
    readonly httpRequestMethod?: AlbListenerRuleConditionHttpRequestMethod[];
    /** path_pattern block */
    readonly pathPattern?: AlbListenerRuleConditionPathPattern[];
    /** query_string block */
    readonly queryString?: AlbListenerRuleConditionQueryString[];
    /** source_ip block */
    readonly sourceIp?: AlbListenerRuleConditionSourceIp[];
}
export declare class AlbListenerRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: AlbListenerRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _listenerArn;
    get listenerArn(): string;
    set listenerArn(value: string);
    private _priority?;
    get priority(): number | undefined;
    set priority(value: number | undefined);
    private _action;
    get action(): AlbListenerRuleAction[];
    set action(value: AlbListenerRuleAction[]);
    private _condition;
    get condition(): AlbListenerRuleCondition[];
    set condition(value: AlbListenerRuleCondition[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
