import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AlbListenerConfig extends TerraformMetaArguments {
    readonly certificateArn?: string;
    readonly loadBalancerArn: string;
    readonly port: number;
    readonly protocol?: string;
    readonly sslPolicy?: string;
    /** default_action block */
    readonly defaultAction: AlbListenerDefaultAction[];
    /** timeouts block */
    readonly timeouts?: AlbListenerTimeouts;
}
export interface AlbListenerDefaultActionAuthenticateCognito {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly userPoolArn: string;
    readonly userPoolClientId: string;
    readonly userPoolDomain: string;
}
export interface AlbListenerDefaultActionAuthenticateOidc {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly authorizationEndpoint: string;
    readonly clientId: string;
    readonly clientSecret: string;
    readonly issuer: string;
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly tokenEndpoint: string;
    readonly userInfoEndpoint: string;
}
export interface AlbListenerDefaultActionFixedResponse {
    readonly contentType: string;
    readonly messageBody?: string;
    readonly statusCode?: string;
}
export interface AlbListenerDefaultActionForwardStickiness {
    readonly duration: number;
    readonly enabled?: boolean;
}
export interface AlbListenerDefaultActionForwardTargetGroup {
    readonly arn: string;
    readonly weight?: number;
}
export interface AlbListenerDefaultActionForward {
    /** stickiness block */
    readonly stickiness?: AlbListenerDefaultActionForwardStickiness[];
    /** target_group block */
    readonly targetGroup: AlbListenerDefaultActionForwardTargetGroup[];
}
export interface AlbListenerDefaultActionRedirect {
    readonly host?: string;
    readonly path?: string;
    readonly port?: string;
    readonly protocol?: string;
    readonly query?: string;
    readonly statusCode: string;
}
export interface AlbListenerDefaultAction {
    readonly order?: number;
    readonly targetGroupArn?: string;
    readonly type: string;
    /** authenticate_cognito block */
    readonly authenticateCognito?: AlbListenerDefaultActionAuthenticateCognito[];
    /** authenticate_oidc block */
    readonly authenticateOidc?: AlbListenerDefaultActionAuthenticateOidc[];
    /** fixed_response block */
    readonly fixedResponse?: AlbListenerDefaultActionFixedResponse[];
    /** forward block */
    readonly forward?: AlbListenerDefaultActionForward[];
    /** redirect block */
    readonly redirect?: AlbListenerDefaultActionRedirect[];
}
export interface AlbListenerTimeouts {
    readonly read?: string;
}
export declare class AlbListener extends TerraformResource {
    constructor(scope: Construct, id: string, config: AlbListenerConfig);
    get arn(): string;
    private _certificateArn?;
    get certificateArn(): string | undefined;
    set certificateArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _loadBalancerArn;
    get loadBalancerArn(): string;
    set loadBalancerArn(value: string);
    private _port;
    get port(): number;
    set port(value: number);
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    private _sslPolicy?;
    get sslPolicy(): string | undefined;
    set sslPolicy(value: string | undefined);
    private _defaultAction;
    get defaultAction(): AlbListenerDefaultAction[];
    set defaultAction(value: AlbListenerDefaultAction[]);
    private _timeouts?;
    get timeouts(): AlbListenerTimeouts | undefined;
    set timeouts(value: AlbListenerTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
