import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AlbTargetGroupConfig extends TerraformMetaArguments {
    readonly deregistrationDelay?: number;
    readonly lambdaMultiValueHeadersEnabled?: boolean;
    readonly loadBalancingAlgorithmType?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly port?: number;
    readonly protocol?: string;
    readonly proxyProtocolV2?: boolean;
    readonly slowStart?: number;
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetType?: string;
    readonly vpcId?: string;
    /** health_check block */
    readonly healthCheck?: AlbTargetGroupHealthCheck[];
    /** stickiness block */
    readonly stickiness?: AlbTargetGroupStickiness[];
}
export interface AlbTargetGroupHealthCheck {
    readonly enabled?: boolean;
    readonly healthyThreshold?: number;
    readonly interval?: number;
    readonly matcher?: string;
    readonly path?: string;
    readonly port?: string;
    readonly protocol?: string;
    readonly timeout?: number;
    readonly unhealthyThreshold?: number;
}
export interface AlbTargetGroupStickiness {
    readonly cookieDuration?: number;
    readonly enabled?: boolean;
    readonly type: string;
}
export declare class AlbTargetGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config?: AlbTargetGroupConfig);
    get arn(): string;
    get arnSuffix(): string;
    private _deregistrationDelay?;
    get deregistrationDelay(): number | undefined;
    set deregistrationDelay(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _lambdaMultiValueHeadersEnabled?;
    get lambdaMultiValueHeadersEnabled(): boolean | undefined;
    set lambdaMultiValueHeadersEnabled(value: boolean | undefined);
    private _loadBalancingAlgorithmType?;
    get loadBalancingAlgorithmType(): string | undefined;
    set loadBalancingAlgorithmType(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    private _proxyProtocolV2?;
    get proxyProtocolV2(): boolean | undefined;
    set proxyProtocolV2(value: boolean | undefined);
    private _slowStart?;
    get slowStart(): number | undefined;
    set slowStart(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetType?;
    get targetType(): string | undefined;
    set targetType(value: string | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _healthCheck?;
    get healthCheck(): AlbTargetGroupHealthCheck[] | undefined;
    set healthCheck(value: AlbTargetGroupHealthCheck[] | undefined);
    private _stickiness?;
    get stickiness(): AlbTargetGroupStickiness[] | undefined;
    set stickiness(value: AlbTargetGroupStickiness[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
