import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AmiCopyConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly encrypted?: boolean;
    readonly kmsKeyId?: string;
    readonly name: string;
    readonly sourceAmiId: string;
    readonly sourceAmiRegion: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** ebs_block_device block */
    readonly ebsBlockDevice?: AmiCopyEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: AmiCopyEphemeralBlockDevice[];
    /** timeouts block */
    readonly timeouts?: AmiCopyTimeouts;
}
export interface AmiCopyEbsBlockDevice {
}
export interface AmiCopyEphemeralBlockDevice {
}
export interface AmiCopyTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class AmiCopy extends TerraformResource {
    constructor(scope: Construct, id: string, config: AmiCopyConfig);
    get architecture(): string;
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get enaSupport(): boolean;
    private _encrypted?;
    get encrypted(): boolean | undefined;
    set encrypted(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get imageLocation(): string;
    get kernelId(): string;
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    get manageEbsSnapshots(): boolean;
    private _name;
    get name(): string;
    set name(value: string);
    get ramdiskId(): string;
    get rootDeviceName(): string;
    get rootSnapshotId(): string;
    private _sourceAmiId;
    get sourceAmiId(): string;
    set sourceAmiId(value: string);
    private _sourceAmiRegion;
    get sourceAmiRegion(): string;
    set sourceAmiRegion(value: string);
    get sriovNetSupport(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get virtualizationType(): string;
    private _ebsBlockDevice?;
    get ebsBlockDevice(): AmiCopyEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: AmiCopyEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): AmiCopyEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: AmiCopyEphemeralBlockDevice[] | undefined);
    private _timeouts?;
    get timeouts(): AmiCopyTimeouts | undefined;
    set timeouts(value: AmiCopyTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
