import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AmiFromInstanceConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly snapshotWithoutReboot?: boolean;
    readonly sourceInstanceId: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** ebs_block_device block */
    readonly ebsBlockDevice?: AmiFromInstanceEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: AmiFromInstanceEphemeralBlockDevice[];
    /** timeouts block */
    readonly timeouts?: AmiFromInstanceTimeouts;
}
export interface AmiFromInstanceEbsBlockDevice {
}
export interface AmiFromInstanceEphemeralBlockDevice {
}
export interface AmiFromInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class AmiFromInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: AmiFromInstanceConfig);
    get architecture(): string;
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get enaSupport(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get imageLocation(): string;
    get kernelId(): string;
    get manageEbsSnapshots(): boolean;
    private _name;
    get name(): string;
    set name(value: string);
    get ramdiskId(): string;
    get rootDeviceName(): string;
    get rootSnapshotId(): string;
    private _snapshotWithoutReboot?;
    get snapshotWithoutReboot(): boolean | undefined;
    set snapshotWithoutReboot(value: boolean | undefined);
    private _sourceInstanceId;
    get sourceInstanceId(): string;
    set sourceInstanceId(value: string);
    get sriovNetSupport(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get virtualizationType(): string;
    private _ebsBlockDevice?;
    get ebsBlockDevice(): AmiFromInstanceEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: AmiFromInstanceEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): AmiFromInstanceEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: AmiFromInstanceEphemeralBlockDevice[] | undefined);
    private _timeouts?;
    get timeouts(): AmiFromInstanceTimeouts | undefined;
    set timeouts(value: AmiFromInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
