import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AmiConfig extends TerraformMetaArguments {
    readonly architecture?: string;
    readonly description?: string;
    readonly enaSupport?: boolean;
    readonly imageLocation?: string;
    readonly kernelId?: string;
    readonly name: string;
    readonly ramdiskId?: string;
    readonly rootDeviceName?: string;
    readonly sriovNetSupport?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly virtualizationType?: string;
    /** ebs_block_device block */
    readonly ebsBlockDevice?: AmiEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: AmiEphemeralBlockDevice[];
    /** timeouts block */
    readonly timeouts?: AmiTimeouts;
}
export interface AmiEbsBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly deviceName: string;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface AmiEphemeralBlockDevice {
    readonly deviceName: string;
    readonly virtualName: string;
}
export interface AmiTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Ami extends TerraformResource {
    constructor(scope: Construct, id: string, config: AmiConfig);
    private _architecture?;
    get architecture(): string | undefined;
    set architecture(value: string | undefined);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enaSupport?;
    get enaSupport(): boolean | undefined;
    set enaSupport(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _imageLocation?;
    get imageLocation(): string | undefined;
    set imageLocation(value: string | undefined);
    private _kernelId?;
    get kernelId(): string | undefined;
    set kernelId(value: string | undefined);
    get manageEbsSnapshots(): boolean;
    private _name;
    get name(): string;
    set name(value: string);
    private _ramdiskId?;
    get ramdiskId(): string | undefined;
    set ramdiskId(value: string | undefined);
    private _rootDeviceName?;
    get rootDeviceName(): string | undefined;
    set rootDeviceName(value: string | undefined);
    get rootSnapshotId(): string;
    private _sriovNetSupport?;
    get sriovNetSupport(): string | undefined;
    set sriovNetSupport(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _virtualizationType?;
    get virtualizationType(): string | undefined;
    set virtualizationType(value: string | undefined);
    private _ebsBlockDevice?;
    get ebsBlockDevice(): AmiEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: AmiEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): AmiEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: AmiEphemeralBlockDevice[] | undefined);
    private _timeouts?;
    get timeouts(): AmiTimeouts | undefined;
    set timeouts(value: AmiTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
