import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface ApiGatewayAccountConfig extends TerraformMetaArguments {
    readonly cloudwatchRoleArn?: string;
}
export declare class ApiGatewayAccountThrottleSettings extends ComplexComputedList {
    get burstLimit(): number;
    get rateLimit(): number;
}
export declare class ApiGatewayAccount extends TerraformResource {
    constructor(scope: Construct, id: string, config?: ApiGatewayAccountConfig);
    private _cloudwatchRoleArn?;
    get cloudwatchRoleArn(): string | undefined;
    set cloudwatchRoleArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    throttleSettings(index: string): ApiGatewayAccountThrottleSettings;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
