"use strict";
// https://www.terraform.io/docs/providers/aws/r/api_gateway_account.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayAccount = exports.ApiGatewayAccountThrottleSettings = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
class ApiGatewayAccountThrottleSettings extends cdktf_2.ComplexComputedList {
    // burst_limit - computed: true, optional: false, required: true
    get burstLimit() {
        return this.getNumberAttribute('burst_limit');
    }
    // rate_limit - computed: true, optional: false, required: true
    get rateLimit() {
        return this.getNumberAttribute('rate_limit');
    }
}
exports.ApiGatewayAccountThrottleSettings = ApiGatewayAccountThrottleSettings;
// Resource
class ApiGatewayAccount extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_api_gateway_account',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cloudwatchRoleArn = config.cloudwatchRoleArn;
    }
    get cloudwatchRoleArn() {
        return this._cloudwatchRoleArn;
    }
    set cloudwatchRoleArn(value) {
        this._cloudwatchRoleArn = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // throttle_settings - computed: true, optional: false, required: true
    throttleSettings(index) {
        return new ApiGatewayAccountThrottleSettings(this, 'throttle_settings', index);
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cloudwatch_role_arn: this._cloudwatchRoleArn,
        };
    }
}
exports.ApiGatewayAccount = ApiGatewayAccount;
//# sourceMappingURL=data:application/json;base64,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