import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayApiKeyConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly enabled?: boolean;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly value?: string;
    /** stage_key block */
    readonly stageKey?: ApiGatewayApiKeyStageKey[];
}
export interface ApiGatewayApiKeyStageKey {
    readonly restApiId: string;
    readonly stageName: string;
}
export declare class ApiGatewayApiKey extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayApiKeyConfig);
    get arn(): string;
    get createdDate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _value?;
    get value(): string | undefined;
    set value(value: string | undefined);
    private _stageKey?;
    get stageKey(): ApiGatewayApiKeyStageKey[] | undefined;
    set stageKey(value: ApiGatewayApiKeyStageKey[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
