import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayAuthorizerConfig extends TerraformMetaArguments {
    readonly authorizerCredentials?: string;
    readonly authorizerResultTtlInSeconds?: number;
    readonly authorizerUri?: string;
    readonly identitySource?: string;
    readonly identityValidationExpression?: string;
    readonly name: string;
    readonly providerArns?: string[];
    readonly restApiId: string;
    readonly type?: string;
}
export declare class ApiGatewayAuthorizer extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayAuthorizerConfig);
    private _authorizerCredentials?;
    get authorizerCredentials(): string | undefined;
    set authorizerCredentials(value: string | undefined);
    private _authorizerResultTtlInSeconds?;
    get authorizerResultTtlInSeconds(): number | undefined;
    set authorizerResultTtlInSeconds(value: number | undefined);
    private _authorizerUri?;
    get authorizerUri(): string | undefined;
    set authorizerUri(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identitySource?;
    get identitySource(): string | undefined;
    set identitySource(value: string | undefined);
    private _identityValidationExpression?;
    get identityValidationExpression(): string | undefined;
    set identityValidationExpression(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _providerArns?;
    get providerArns(): string[] | undefined;
    set providerArns(value: string[] | undefined);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
