import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayDeploymentConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly restApiId: string;
    readonly stageDescription?: string;
    readonly stageName?: string;
    readonly triggers?: {
        [key: string]: string;
    };
    readonly variables?: {
        [key: string]: string;
    };
}
export declare class ApiGatewayDeployment extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayDeploymentConfig);
    get createdDate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeUrl(): string;
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _stageDescription?;
    get stageDescription(): string | undefined;
    set stageDescription(value: string | undefined);
    private _stageName?;
    get stageName(): string | undefined;
    set stageName(value: string | undefined);
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    } | undefined;
    set triggers(value: {
        [key: string]: string;
    } | undefined);
    private _variables?;
    get variables(): {
        [key: string]: string;
    } | undefined;
    set variables(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
