import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayDocumentationPartConfig extends TerraformMetaArguments {
    readonly properties: string;
    readonly restApiId: string;
    /** location block */
    readonly location: ApiGatewayDocumentationPartLocation[];
}
export interface ApiGatewayDocumentationPartLocation {
    readonly method?: string;
    readonly name?: string;
    readonly path?: string;
    readonly statusCode?: string;
    readonly type: string;
}
export declare class ApiGatewayDocumentationPart extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayDocumentationPartConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _properties;
    get properties(): string;
    set properties(value: string);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _location;
    get location(): ApiGatewayDocumentationPartLocation[];
    set location(value: ApiGatewayDocumentationPartLocation[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
