import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayDomainNameConfig extends TerraformMetaArguments {
    readonly certificateArn?: string;
    readonly certificateBody?: string;
    readonly certificateChain?: string;
    readonly certificateName?: string;
    readonly certificatePrivateKey?: string;
    readonly domainName: string;
    readonly regionalCertificateArn?: string;
    readonly regionalCertificateName?: string;
    readonly securityPolicy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** endpoint_configuration block */
    readonly endpointConfiguration?: ApiGatewayDomainNameEndpointConfiguration[];
}
export interface ApiGatewayDomainNameEndpointConfiguration {
    readonly types: string[];
}
export declare class ApiGatewayDomainName extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayDomainNameConfig);
    get arn(): string;
    private _certificateArn?;
    get certificateArn(): string | undefined;
    set certificateArn(value: string | undefined);
    private _certificateBody?;
    get certificateBody(): string | undefined;
    set certificateBody(value: string | undefined);
    private _certificateChain?;
    get certificateChain(): string | undefined;
    set certificateChain(value: string | undefined);
    private _certificateName?;
    get certificateName(): string | undefined;
    set certificateName(value: string | undefined);
    private _certificatePrivateKey?;
    get certificatePrivateKey(): string | undefined;
    set certificatePrivateKey(value: string | undefined);
    get certificateUploadDate(): string;
    get cloudfrontDomainName(): string;
    get cloudfrontZoneId(): string;
    private _domainName;
    get domainName(): string;
    set domainName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _regionalCertificateArn?;
    get regionalCertificateArn(): string | undefined;
    set regionalCertificateArn(value: string | undefined);
    private _regionalCertificateName?;
    get regionalCertificateName(): string | undefined;
    set regionalCertificateName(value: string | undefined);
    get regionalDomainName(): string;
    get regionalZoneId(): string;
    private _securityPolicy?;
    get securityPolicy(): string | undefined;
    set securityPolicy(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _endpointConfiguration?;
    get endpointConfiguration(): ApiGatewayDomainNameEndpointConfiguration[] | undefined;
    set endpointConfiguration(value: ApiGatewayDomainNameEndpointConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
